/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.security.authenticator;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerConfigurationManager;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.security.OSecurityAuthenticatorAbstract;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

public class ODefaultPasswordAuthenticator
extends OSecurityAuthenticatorAbstract {
    private ConcurrentHashMap<String, OServerUserConfiguration> usersMap = new ConcurrentHashMap();

    @Override
    public void active() {
        OLogManager.instance().info((Object)this, "ODefaultPasswordAuthenticator is active", new Object[0]);
    }

    @Override
    public void config(OServer oServer, OServerConfigurationManager serverCfg, ODocument jsonConfig) {
        super.config(oServer, serverCfg, jsonConfig);
        try {
            if (jsonConfig.containsField("users")) {
                List usersList = (List)jsonConfig.field("users");
                for (ODocument userDoc : usersList) {
                    OServerUserConfiguration userCfg = this.createServerUser(userDoc);
                    if (userCfg == null) continue;
                    String checkName = userCfg.name;
                    if (!this.isCaseSensitive()) {
                        checkName = checkName.toLowerCase(Locale.ENGLISH);
                    }
                    this.usersMap.put(checkName, userCfg);
                }
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error(this, "config()", ex, new Object[0]);
        }
    }

    protected OServerUserConfiguration createServerUser(ODocument userDoc) {
        OServerUserConfiguration userCfg = null;
        if (userDoc.containsField("username") && userDoc.containsField("resources")) {
            String user = (String)userDoc.field("username");
            String resources = (String)userDoc.field("resources");
            String password = (String)userDoc.field("password");
            if (password == null) {
                password = "";
            }
            userCfg = new OServerUserConfiguration(user, password, resources);
        }
        return userCfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ConcurrentHashMap<String, OServerUserConfiguration> concurrentHashMap = this.usersMap;
        synchronized (concurrentHashMap) {
            this.usersMap.clear();
            this.usersMap = null;
        }
    }

    @Override
    public String authenticate(String username, String password) {
        String principal = null;
        try {
            OServerUserConfiguration user = this.getUser(username);
            if (this.isPasswordValid(user) && OSecurityManager.instance().checkPassword(password, user.password)) {
                principal = user.name;
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error(this, "ODefaultPasswordAuthenticator.authenticate()", ex, new Object[0]);
        }
        return principal;
    }

    @Override
    public boolean isAuthorized(String username, String resource) {
        if (username == null || resource == null) {
            return false;
        }
        OServerUserConfiguration userCfg = this.getUser(username);
        if (userCfg != null) {
            String[] resourceParts;
            if (userCfg.resources.equals("*")) {
                return true;
            }
            for (String r : resourceParts = userCfg.resources.split(",")) {
                if (!r.equalsIgnoreCase(resource)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OServerUserConfiguration getUser(String username) {
        OServerUserConfiguration userCfg = null;
        ConcurrentHashMap<String, OServerUserConfiguration> concurrentHashMap = this.usersMap;
        synchronized (concurrentHashMap) {
            if (username != null) {
                String checkName = username;
                if (!this.isCaseSensitive()) {
                    checkName = username.toLowerCase(Locale.ENGLISH);
                }
                if (this.usersMap.containsKey(checkName)) {
                    userCfg = (OServerUserConfiguration)this.usersMap.get(checkName);
                }
            }
        }
        return userCfg;
    }
}

