/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.tinkerpop.gremlin.driver.AuthProperties;
import org.apache.tinkerpop.gremlin.driver.Channelizer;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Host;
import org.apache.tinkerpop.gremlin.driver.LoadBalancingStrategy;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.Settings;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.ser.Serializers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Cluster {
    private static final Logger logger = LoggerFactory.getLogger(Cluster.class);
    private Manager manager;

    private Cluster(Builder builder) {
        this.manager = new Manager(builder);
    }

    public synchronized void init() {
        if (!this.manager.initialized) {
            this.manager.init();
        }
    }

    public <T extends Client> T connect() {
        Client.ClusteredClient client = new Client.ClusteredClient(this, Client.Settings.build().create());
        this.manager.trackClient(client);
        return (T)client;
    }

    public <T extends Client> T connect(String sessionId) {
        return this.connect(sessionId, false);
    }

    public <T extends Client> T connect(String sessionId, boolean manageTransactions) {
        Client.SessionSettings sessionSettings = Client.SessionSettings.build().manageTransactions(manageTransactions).sessionId(sessionId).create();
        Client.Settings settings = Client.Settings.build().useSession(sessionSettings).create();
        return this.connect(settings);
    }

    public <T extends Client> T connect(Client.Settings settings) {
        Client client = settings.getSession().isPresent() ? new Client.SessionedClient(this, settings) : new Client.ClusteredClient(this, settings);
        this.manager.trackClient(client);
        return (T)client;
    }

    public String toString() {
        return this.manager.toString();
    }

    public static Builder build() {
        return new Builder();
    }

    public static Builder build(String address) {
        return new Builder(address);
    }

    public static Builder build(File configurationFile) throws FileNotFoundException {
        Settings settings = Settings.read(new FileInputStream(configurationFile));
        return Cluster.getBuilderFromSettings(settings);
    }

    private static Builder getBuilderFromSettings(Settings settings) {
        List<String> addresses = settings.hosts;
        if (addresses.size() == 0) {
            throw new IllegalStateException("At least one value must be specified to the hosts setting");
        }
        Builder builder = new Builder(settings.hosts.get(0)).port(settings.port).path(settings.path).enableSsl(settings.connectionPool.enableSsl).trustCertificateChainFile(settings.connectionPool.trustCertChainFile).keepAliveInterval(settings.connectionPool.keepAliveInterval).keyCertChainFile(settings.connectionPool.keyCertChainFile).keyFile(settings.connectionPool.keyFile).keyPassword(settings.connectionPool.keyPassword).keyStore(settings.connectionPool.keyStore).keyStorePassword(settings.connectionPool.keyStorePassword).keyStoreType(settings.connectionPool.keyStoreType).trustStore(settings.connectionPool.trustStore).trustStorePassword(settings.connectionPool.trustStorePassword).sslCipherSuites(settings.connectionPool.sslCipherSuites).sslEnabledProtocols(settings.connectionPool.sslEnabledProtocols).sslSkipCertValidation(settings.connectionPool.sslSkipCertValidation).nioPoolSize(settings.nioPoolSize).workerPoolSize(settings.workerPoolSize).reconnectInterval(settings.connectionPool.reconnectInterval).resultIterationBatchSize(settings.connectionPool.resultIterationBatchSize).channelizer(settings.connectionPool.channelizer).maxContentLength(settings.connectionPool.maxContentLength).maxWaitForConnection(settings.connectionPool.maxWaitForConnection).maxInProcessPerConnection(settings.connectionPool.maxInProcessPerConnection).minInProcessPerConnection(settings.connectionPool.minInProcessPerConnection).maxSimultaneousUsagePerConnection(settings.connectionPool.maxSimultaneousUsagePerConnection).minSimultaneousUsagePerConnection(settings.connectionPool.minSimultaneousUsagePerConnection).maxConnectionPoolSize(settings.connectionPool.maxSize).minConnectionPoolSize(settings.connectionPool.minSize).validationRequest(settings.connectionPool.validationRequest);
        if (settings.username != null && settings.password != null) {
            builder.credentials(settings.username, settings.password);
        }
        if (settings.jaasEntry != null) {
            builder.jaasEntry(settings.jaasEntry);
        }
        if (settings.protocol != null) {
            builder.protocol(settings.protocol);
        }
        if (addresses.size() > 1) {
            addresses.stream().skip(1L).forEach(builder::addContactPoint);
        }
        try {
            builder.serializer(settings.serializer.create());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not establish serializer - " + ex.getMessage());
        }
        return builder;
    }

    public static Cluster open() {
        return Cluster.build("localhost").create();
    }

    public static Cluster open(Configuration conf) {
        return Cluster.getBuilderFromSettings(Settings.from(conf)).create();
    }

    public static Cluster open(String configurationFile) throws Exception {
        File systemFile = new File(configurationFile);
        if (!systemFile.exists()) {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            URL resource = currentClassLoader.getResource(configurationFile);
            File resourceFile = new File(resource.getFile());
            if (!resourceFile.exists()) {
                throw new IllegalArgumentException(String.format("Configuration file at %s does not exist", configurationFile));
            }
            return Cluster.build(resourceFile).create();
        }
        return Cluster.build(systemFile).create();
    }

    public void close() {
        this.closeAsync().join();
    }

    public CompletableFuture<Void> closeAsync() {
        return this.manager.close();
    }

    public boolean isClosing() {
        return this.manager.isClosing();
    }

    public boolean isClosed() {
        return this.manager.isClosing() && this.manager.close().isDone();
    }

    public List<URI> availableHosts() {
        return Collections.unmodifiableList(this.allHosts().stream().filter(Host::isAvailable).map(Host::getHostUri).collect(Collectors.toList()));
    }

    public String getPath() {
        return this.manager.path;
    }

    public int getNioPoolSize() {
        return this.manager.nioPoolSize;
    }

    public int getWorkerPoolSize() {
        return this.manager.workerPoolSize;
    }

    public String[] getSerializers() {
        return this.getSerializer().mimeTypesSupported();
    }

    public boolean isSslEnabled() {
        return ((Manager)this.manager).connectionPoolSettings.enableSsl;
    }

    public int getMinInProcessPerConnection() {
        return ((Manager)this.manager).connectionPoolSettings.minInProcessPerConnection;
    }

    public int getMaxInProcessPerConnection() {
        return ((Manager)this.manager).connectionPoolSettings.maxInProcessPerConnection;
    }

    public int maxSimultaneousUsagePerConnection() {
        return ((Manager)this.manager).connectionPoolSettings.maxSimultaneousUsagePerConnection;
    }

    public int minSimultaneousUsagePerConnection() {
        return ((Manager)this.manager).connectionPoolSettings.minSimultaneousUsagePerConnection;
    }

    public int maxConnectionPoolSize() {
        return ((Manager)this.manager).connectionPoolSettings.maxSize;
    }

    public int minConnectionPoolSize() {
        return ((Manager)this.manager).connectionPoolSettings.minSize;
    }

    public int getResultIterationBatchSize() {
        return ((Manager)this.manager).connectionPoolSettings.resultIterationBatchSize;
    }

    public int getMaxWaitForConnection() {
        return ((Manager)this.manager).connectionPoolSettings.maxWaitForConnection;
    }

    public int getMaxWaitForSessionClose() {
        return ((Manager)this.manager).connectionPoolSettings.maxWaitForSessionClose;
    }

    public int getMaxContentLength() {
        return ((Manager)this.manager).connectionPoolSettings.maxContentLength;
    }

    public String getChannelizer() {
        return ((Manager)this.manager).connectionPoolSettings.channelizer;
    }

    public int getReconnectInterval() {
        return ((Manager)this.manager).connectionPoolSettings.reconnectInterval;
    }

    public long getKeepAliveInterval() {
        return ((Manager)this.manager).connectionPoolSettings.keepAliveInterval;
    }

    public Class<? extends LoadBalancingStrategy> getLoadBalancingStrategy() {
        return this.manager.loadBalancingStrategy.getClass();
    }

    public int getPort() {
        return this.manager.port;
    }

    public Collection<Host> allHosts() {
        return Collections.unmodifiableCollection(this.manager.allHosts());
    }

    Factory getFactory() {
        return this.manager.factory;
    }

    MessageSerializer getSerializer() {
        return this.manager.serializer;
    }

    ScheduledExecutorService executor() {
        return this.manager.executor;
    }

    Settings.ConnectionPoolSettings connectionPoolSettings() {
        return this.manager.connectionPoolSettings;
    }

    LoadBalancingStrategy loadBalancingStrategy() {
        return this.manager.loadBalancingStrategy;
    }

    AuthProperties authProperties() {
        return this.manager.authProps;
    }

    RequestMessage.Builder validationRequest() {
        return (RequestMessage.Builder)this.manager.validationRequest.get();
    }

    SslContext createSSLContext() throws Exception {
        SslContextBuilder builder;
        Settings.ConnectionPoolSettings connectionPoolSettings;
        SslProvider provider;
        block34: {
            if (this.manager.sslContextOptional.isPresent()) {
                return (SslContext)this.manager.sslContextOptional.get();
            }
            provider = SslProvider.JDK;
            connectionPoolSettings = this.connectionPoolSettings();
            builder = SslContextBuilder.forClient();
            if (connectionPoolSettings.trustCertChainFile != null) {
                logger.warn("Using deprecated SSL trustCertChainFile support");
                builder.trustManager(new File(connectionPoolSettings.trustCertChainFile));
            }
            if (null != connectionPoolSettings.keyCertChainFile && null != connectionPoolSettings.keyFile) {
                logger.warn("Using deprecated SSL keyFile support");
                File keyCertChainFile = new File(connectionPoolSettings.keyCertChainFile);
                File keyFile = new File(connectionPoolSettings.keyFile);
                builder.keyManager(keyCertChainFile, keyFile, connectionPoolSettings.keyPassword);
            }
            try {
                Throwable throwable;
                FileInputStream in;
                char[] password;
                if (null != connectionPoolSettings.keyStore) {
                    String keyStoreType = null == connectionPoolSettings.keyStoreType ? KeyStore.getDefaultType() : connectionPoolSettings.keyStoreType;
                    KeyStore keystore = KeyStore.getInstance(keyStoreType);
                    password = null == connectionPoolSettings.keyStorePassword ? null : connectionPoolSettings.keyStorePassword.toCharArray();
                    in = new FileInputStream(connectionPoolSettings.keyStore);
                    throwable = null;
                    try {
                        keystore.load(in, password);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in != null) {
                            if (throwable != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((InputStream)in).close();
                            }
                        }
                    }
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    kmf.init(keystore, password);
                    builder.keyManager(kmf);
                }
                if (null == connectionPoolSettings.trustStore) break block34;
                String keystoreType = null == connectionPoolSettings.keyStoreType ? KeyStore.getDefaultType() : connectionPoolSettings.keyStoreType;
                KeyStore truststore = KeyStore.getInstance(keystoreType);
                password = null == connectionPoolSettings.trustStorePassword ? null : connectionPoolSettings.trustStorePassword.toCharArray();
                in = new FileInputStream(connectionPoolSettings.trustStore);
                throwable = null;
                try {
                    truststore.load(in, password);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((InputStream)in).close();
                        }
                    }
                }
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(truststore);
                builder.trustManager(tmf);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                logger.error("There was an error enabling SSL.", (Throwable)e);
                return null;
            }
        }
        if (null != connectionPoolSettings.sslCipherSuites && !connectionPoolSettings.sslCipherSuites.isEmpty()) {
            builder.ciphers(connectionPoolSettings.sslCipherSuites);
        }
        if (null != connectionPoolSettings.sslEnabledProtocols && !connectionPoolSettings.sslEnabledProtocols.isEmpty()) {
            builder.protocols(connectionPoolSettings.sslEnabledProtocols.toArray(new String[0]));
        }
        if (connectionPoolSettings.sslSkipCertValidation) {
            logger.warn("SSL configured with sslSkipCertValidation thus trusts all certificates without verification (not suitable for production)");
            builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        }
        builder.sslProvider(provider);
        return builder.build();
    }

    class Manager {
        private final ConcurrentMap<InetSocketAddress, Host> hosts = new ConcurrentHashMap<InetSocketAddress, Host>();
        private boolean initialized;
        private final List<InetSocketAddress> contactPoints;
        private final Factory factory;
        private final MessageSerializer serializer;
        private final Settings.ConnectionPoolSettings connectionPoolSettings;
        private final LoadBalancingStrategy loadBalancingStrategy;
        private final AuthProperties authProps;
        private final Optional<SslContext> sslContextOptional;
        private final Supplier<RequestMessage.Builder> validationRequest;
        private final ScheduledThreadPoolExecutor executor;
        private final int nioPoolSize;
        private final int workerPoolSize;
        private final int port;
        private final String path;
        private final AtomicReference<CompletableFuture<Void>> closeFuture = new AtomicReference();
        private final List<WeakReference<Client>> openedClients = new ArrayList<WeakReference<Client>>();

        private Manager(Builder builder) {
            this.validateBuilder(builder);
            this.loadBalancingStrategy = builder.loadBalancingStrategy;
            this.authProps = builder.authProps;
            this.contactPoints = builder.getContactPoints();
            this.connectionPoolSettings = new Settings.ConnectionPoolSettings();
            this.connectionPoolSettings.maxInProcessPerConnection = builder.maxInProcessPerConnection;
            this.connectionPoolSettings.minInProcessPerConnection = builder.minInProcessPerConnection;
            this.connectionPoolSettings.maxSimultaneousUsagePerConnection = builder.maxSimultaneousUsagePerConnection;
            this.connectionPoolSettings.minSimultaneousUsagePerConnection = builder.minSimultaneousUsagePerConnection;
            this.connectionPoolSettings.maxSize = builder.maxConnectionPoolSize;
            this.connectionPoolSettings.minSize = builder.minConnectionPoolSize;
            this.connectionPoolSettings.maxWaitForConnection = builder.maxWaitForConnection;
            this.connectionPoolSettings.maxWaitForSessionClose = builder.maxWaitForSessionClose;
            this.connectionPoolSettings.maxContentLength = builder.maxContentLength;
            this.connectionPoolSettings.reconnectInterval = builder.reconnectInterval;
            this.connectionPoolSettings.resultIterationBatchSize = builder.resultIterationBatchSize;
            this.connectionPoolSettings.enableSsl = builder.enableSsl;
            this.connectionPoolSettings.trustCertChainFile = builder.trustCertChainFile;
            this.connectionPoolSettings.keyCertChainFile = builder.keyCertChainFile;
            this.connectionPoolSettings.keyFile = builder.keyFile;
            this.connectionPoolSettings.keyPassword = builder.keyPassword;
            this.connectionPoolSettings.keyStore = builder.keyStore;
            this.connectionPoolSettings.keyStorePassword = builder.keyStorePassword;
            this.connectionPoolSettings.trustStore = builder.trustStore;
            this.connectionPoolSettings.trustStorePassword = builder.trustStorePassword;
            this.connectionPoolSettings.keyStoreType = builder.keyStoreType;
            this.connectionPoolSettings.sslCipherSuites = builder.sslCipherSuites;
            this.connectionPoolSettings.sslEnabledProtocols = builder.sslEnabledProtocols;
            this.connectionPoolSettings.sslSkipCertValidation = builder.sslSkipCertValidation;
            this.connectionPoolSettings.keepAliveInterval = builder.keepAliveInterval;
            this.connectionPoolSettings.channelizer = builder.channelizer;
            this.connectionPoolSettings.validationRequest = builder.validationRequest;
            this.sslContextOptional = Optional.ofNullable(builder.sslContext);
            this.nioPoolSize = builder.nioPoolSize;
            this.workerPoolSize = builder.workerPoolSize;
            this.port = builder.port;
            this.path = builder.path;
            this.factory = new Factory(builder.nioPoolSize);
            this.serializer = builder.serializer;
            this.executor = new ScheduledThreadPoolExecutor(builder.workerPoolSize, new BasicThreadFactory.Builder().namingPattern("gremlin-driver-worker-%d").build());
            this.executor.setRemoveOnCancelPolicy(true);
            this.validationRequest = () -> RequestMessage.build("eval").add("gremlin", builder.validationRequest);
        }

        private void validateBuilder(Builder builder) {
            if (builder.minInProcessPerConnection < 0) {
                throw new IllegalArgumentException("minInProcessPerConnection must be greater than or equal to zero");
            }
            if (builder.maxInProcessPerConnection < 1) {
                throw new IllegalArgumentException("maxInProcessPerConnection must be greater than zero");
            }
            if (builder.minInProcessPerConnection > builder.maxInProcessPerConnection) {
                throw new IllegalArgumentException("maxInProcessPerConnection cannot be less than minInProcessPerConnection");
            }
            if (builder.minSimultaneousUsagePerConnection < 0) {
                throw new IllegalArgumentException("minSimultaneousUsagePerConnection must be greater than or equal to zero");
            }
            if (builder.maxSimultaneousUsagePerConnection < 1) {
                throw new IllegalArgumentException("maxSimultaneousUsagePerConnection must be greater than zero");
            }
            if (builder.minSimultaneousUsagePerConnection > builder.maxSimultaneousUsagePerConnection) {
                throw new IllegalArgumentException("maxSimultaneousUsagePerConnection cannot be less than minSimultaneousUsagePerConnection");
            }
            if (builder.minConnectionPoolSize < 0) {
                throw new IllegalArgumentException("minConnectionPoolSize must be greater than or equal to zero");
            }
            if (builder.maxConnectionPoolSize < 1) {
                throw new IllegalArgumentException("maxConnectionPoolSize must be greater than zero");
            }
            if (builder.minConnectionPoolSize > builder.maxConnectionPoolSize) {
                throw new IllegalArgumentException("maxConnectionPoolSize cannot be less than minConnectionPoolSize");
            }
            if (builder.maxWaitForConnection < 1) {
                throw new IllegalArgumentException("maxWaitForConnection must be greater than zero");
            }
            if (builder.maxWaitForSessionClose < 1) {
                throw new IllegalArgumentException("maxWaitForSessionClose must be greater than zero");
            }
            if (builder.maxContentLength < 1) {
                throw new IllegalArgumentException("maxContentLength must be greater than zero");
            }
            if (builder.reconnectInterval < 1) {
                throw new IllegalArgumentException("reconnectInterval must be greater than zero");
            }
            if (builder.resultIterationBatchSize < 1) {
                throw new IllegalArgumentException("resultIterationBatchSize must be greater than zero");
            }
            if (builder.nioPoolSize < 1) {
                throw new IllegalArgumentException("nioPoolSize must be greater than zero");
            }
            if (builder.workerPoolSize < 1) {
                throw new IllegalArgumentException("workerPoolSize must be greater than zero");
            }
            try {
                Class.forName(builder.channelizer);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("The channelizer specified [" + builder.channelizer + "] could not be instantiated - it should be the fully qualified classname of a Channelizer implementation available on the classpath", ex);
            }
        }

        synchronized void init() {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            this.contactPoints.forEach(address -> {
                Host host = this.add((InetSocketAddress)address);
                if (host != null) {
                    host.makeAvailable();
                }
            });
        }

        void trackClient(Client client) {
            this.openedClients.add(new WeakReference<Client>(client));
        }

        public Host add(InetSocketAddress address) {
            Host newHost = new Host(address, Cluster.this);
            Host previous = this.hosts.putIfAbsent(address, newHost);
            return previous == null ? newHost : null;
        }

        Collection<Host> allHosts() {
            return this.hosts.values();
        }

        synchronized CompletableFuture<Void> close() {
            if (this.closeFuture.get() != null) {
                return this.closeFuture.get();
            }
            for (WeakReference<Client> openedClient : this.openedClients) {
                Client client = (Client)openedClient.get();
                if (client == null || client.isClosing()) continue;
                client.close();
            }
            CompletableFuture<Void> closeIt = new CompletableFuture<Void>();
            this.closeFuture.set(closeIt);
            Cluster.this.executor().submit(() -> {
                this.factory.shutdown();
                closeIt.complete(null);
            });
            this.executor.shutdown();
            return closeIt;
        }

        boolean isClosing() {
            return this.closeFuture.get() != null;
        }

        public String toString() {
            return String.join((CharSequence)", ", this.contactPoints.stream().map(InetSocketAddress::toString).collect(Collectors.toList()));
        }
    }

    static class Factory {
        private final EventLoopGroup group;

        public Factory(int nioPoolSize) {
            BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("gremlin-driver-loop-%d").build();
            this.group = new NioEventLoopGroup(nioPoolSize, threadFactory);
        }

        Bootstrap createBootstrap() {
            Bootstrap b = (Bootstrap)new Bootstrap().group(this.group);
            b.option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
            return b;
        }

        void shutdown() {
            this.group.shutdownGracefully().awaitUninterruptibly();
        }
    }

    public static final class Builder {
        private List<InetAddress> addresses = new ArrayList<InetAddress>();
        private int port = 8182;
        private String path = "/gremlin";
        private MessageSerializer serializer = Serializers.GRYO_V3D0.simpleInstance();
        private int nioPoolSize = Runtime.getRuntime().availableProcessors();
        private int workerPoolSize = Runtime.getRuntime().availableProcessors() * 2;
        private int minConnectionPoolSize = 2;
        private int maxConnectionPoolSize = 8;
        private int minSimultaneousUsagePerConnection = 8;
        private int maxSimultaneousUsagePerConnection = 16;
        private int maxInProcessPerConnection = 4;
        private int minInProcessPerConnection = 1;
        private int maxWaitForConnection = 16000;
        private int maxWaitForSessionClose = 3000;
        private int maxContentLength = 65536;
        private int reconnectInterval = 1000;
        private int resultIterationBatchSize = 64;
        private long keepAliveInterval = 180000L;
        private String channelizer = Channelizer.WebSocketChannelizer.class.getName();
        private boolean enableSsl = false;
        private String trustCertChainFile = null;
        private String keyCertChainFile = null;
        private String keyFile = null;
        private String keyPassword = null;
        private String keyStore = null;
        private String keyStorePassword = null;
        private String trustStore = null;
        private String trustStorePassword = null;
        private String keyStoreType = null;
        private String validationRequest = "''";
        private List<String> sslEnabledProtocols = new ArrayList<String>();
        private List<String> sslCipherSuites = new ArrayList<String>();
        private boolean sslSkipCertValidation = false;
        private SslContext sslContext = null;
        private LoadBalancingStrategy loadBalancingStrategy = new LoadBalancingStrategy.RoundRobin();
        private AuthProperties authProps = new AuthProperties();

        private Builder() {
        }

        private Builder(String address) {
            this.addContactPoint(address);
        }

        public Builder nioPoolSize(int nioPoolSize) {
            this.nioPoolSize = nioPoolSize;
            return this;
        }

        public Builder workerPoolSize(int workerPoolSize) {
            this.workerPoolSize = workerPoolSize;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder serializer(String mimeType) {
            this.serializer = Serializers.valueOf(mimeType).simpleInstance();
            return this;
        }

        public Builder serializer(Serializers mimeType) {
            this.serializer = mimeType.simpleInstance();
            return this;
        }

        public Builder serializer(MessageSerializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder enableSsl(boolean enable) {
            this.enableSsl = enable;
            return this;
        }

        public Builder sslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        @Deprecated
        public Builder trustCertificateChainFile(String certificateChainFile) {
            this.trustCertChainFile = certificateChainFile;
            return this;
        }

        public Builder keepAliveInterval(long keepAliveInterval) {
            this.keepAliveInterval = keepAliveInterval;
            return this;
        }

        @Deprecated
        public Builder keyCertChainFile(String keyCertChainFile) {
            this.keyCertChainFile = keyCertChainFile;
            return this;
        }

        @Deprecated
        public Builder keyFile(String keyFile) {
            this.keyFile = keyFile;
            return this;
        }

        @Deprecated
        public Builder keyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
            return this;
        }

        public Builder keyStore(String keyStore) {
            this.keyStore = keyStore;
            return this;
        }

        public Builder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Builder trustStore(String trustStore) {
            this.trustStore = trustStore;
            return this;
        }

        public Builder trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public Builder keyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public Builder sslEnabledProtocols(List<String> sslEnabledProtocols) {
            this.sslEnabledProtocols = sslEnabledProtocols;
            return this;
        }

        public Builder sslCipherSuites(List<String> sslCipherSuites) {
            this.sslCipherSuites = sslCipherSuites;
            return this;
        }

        public Builder sslSkipCertValidation(boolean sslSkipCertValidation) {
            this.sslSkipCertValidation = sslSkipCertValidation;
            return this;
        }

        public Builder minInProcessPerConnection(int minInProcessPerConnection) {
            this.minInProcessPerConnection = minInProcessPerConnection;
            return this;
        }

        public Builder maxInProcessPerConnection(int maxInProcessPerConnection) {
            this.maxInProcessPerConnection = maxInProcessPerConnection;
            return this;
        }

        public Builder maxSimultaneousUsagePerConnection(int maxSimultaneousUsagePerConnection) {
            this.maxSimultaneousUsagePerConnection = maxSimultaneousUsagePerConnection;
            return this;
        }

        public Builder minSimultaneousUsagePerConnection(int minSimultaneousUsagePerConnection) {
            this.minSimultaneousUsagePerConnection = minSimultaneousUsagePerConnection;
            return this;
        }

        public Builder maxConnectionPoolSize(int maxSize) {
            this.maxConnectionPoolSize = maxSize;
            return this;
        }

        public Builder minConnectionPoolSize(int minSize) {
            this.minConnectionPoolSize = minSize;
            return this;
        }

        public Builder resultIterationBatchSize(int size) {
            this.resultIterationBatchSize = size;
            return this;
        }

        public Builder maxWaitForConnection(int maxWait) {
            this.maxWaitForConnection = maxWait;
            return this;
        }

        public Builder maxWaitForSessionClose(int maxWait) {
            this.maxWaitForSessionClose = maxWait;
            return this;
        }

        public Builder maxContentLength(int maxContentLength) {
            this.maxContentLength = maxContentLength;
            return this;
        }

        public Builder channelizer(String channelizerClass) {
            this.channelizer = channelizerClass;
            return this;
        }

        public Builder channelizer(Class channelizerClass) {
            return this.channelizer(channelizerClass.getCanonicalName());
        }

        public Builder validationRequest(String script) {
            this.validationRequest = script;
            return this;
        }

        public Builder reconnectInterval(int interval) {
            this.reconnectInterval = interval;
            return this;
        }

        public Builder loadBalancingStrategy(LoadBalancingStrategy loadBalancingStrategy) {
            this.loadBalancingStrategy = loadBalancingStrategy;
            return this;
        }

        public Builder authProperties(AuthProperties authProps) {
            this.authProps = authProps;
            return this;
        }

        public Builder credentials(String username, String password) {
            this.authProps = this.authProps.with(AuthProperties.Property.USERNAME, username).with(AuthProperties.Property.PASSWORD, password);
            return this;
        }

        public Builder protocol(String protocol) {
            this.authProps = this.authProps.with(AuthProperties.Property.PROTOCOL, protocol);
            return this;
        }

        public Builder jaasEntry(String jaasEntry) {
            this.authProps = this.authProps.with(AuthProperties.Property.JAAS_ENTRY, jaasEntry);
            return this;
        }

        public Builder addContactPoint(String address) {
            try {
                this.addresses.add(InetAddress.getByName(address));
                return this;
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        public Builder addContactPoints(String ... addresses) {
            for (String address : addresses) {
                this.addContactPoint(address);
            }
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        List<InetSocketAddress> getContactPoints() {
            return this.addresses.stream().map(addy -> new InetSocketAddress((InetAddress)addy, this.port)).collect(Collectors.toList());
        }

        public Cluster create() {
            if (this.addresses.size() == 0) {
                this.addContactPoint("localhost");
            }
            return new Cluster(this);
        }
    }
}

