/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.MessageTextSerializer;

@ChannelHandler.Sharable
public final class WebSocketGremlinResponseDecoder
extends MessageToMessageDecoder<WebSocketFrame> {
    private final MessageSerializer serializer;

    public WebSocketGremlinResponseDecoder(MessageSerializer serializer) {
        this.serializer = serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> objects) throws Exception {
        block5: {
            try {
                if (webSocketFrame instanceof BinaryWebSocketFrame) {
                    BinaryWebSocketFrame tf = (BinaryWebSocketFrame)webSocketFrame;
                    objects.add(this.serializer.deserializeResponse(tf.content()));
                    break block5;
                }
                if (webSocketFrame instanceof TextWebSocketFrame) {
                    TextWebSocketFrame tf = (TextWebSocketFrame)webSocketFrame;
                    MessageTextSerializer textSerializer = (MessageTextSerializer)this.serializer;
                    objects.add(textSerializer.deserializeResponse(tf.text()));
                    break block5;
                }
                throw new RuntimeException(String.format("WebSocket channel does not handle this type of message: %s", webSocketFrame.getClass().getName()));
            }
            finally {
                ReferenceCountUtil.release(webSocketFrame);
            }
        }
    }
}

