/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import java.nio.ByteBuffer;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.ser.AbstractGraphSONMessageSerializerV2d0;
import org.apache.tinkerpop.gremlin.driver.ser.MessageTextSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphSONMessageSerializerV3d0
extends AbstractGraphSONMessageSerializerV2d0
implements MessageTextSerializer {
    private static final Logger logger = LoggerFactory.getLogger(GraphSONMessageSerializerV3d0.class);
    private static final String MIME_TYPE = "application/vnd.gremlin-v3.0+json";
    private static byte[] header;

    public GraphSONMessageSerializerV3d0() {
    }

    @Deprecated
    public GraphSONMessageSerializerV3d0(GraphSONMapper mapper) {
        super(mapper);
    }

    public GraphSONMessageSerializerV3d0(GraphSONMapper.Builder mapperBuilder) {
        super(mapperBuilder);
    }

    @Override
    public String[] mimeTypesSupported() {
        return new String[]{MIME_TYPE, "application/json"};
    }

    @Override
    GraphSONMapper.Builder configureBuilder(GraphSONMapper.Builder builder) {
        return builder.version(GraphSONVersion.V3_0).addCustomModule(new AbstractGraphSONMessageSerializerV2d0.GremlinServerModule());
    }

    @Override
    byte[] obtainHeader() {
        return header;
    }

    @Override
    public ResponseMessage deserializeResponse(String msg) throws SerializationException {
        try {
            return this.mapper.readValue(msg, ResponseMessage.class);
        }
        catch (Exception ex) {
            logger.warn(String.format("Response [%s] could not be deserialized by %s.", msg, GraphSONMessageSerializerV3d0.class.getName()), (Throwable)ex);
            throw new SerializationException(ex);
        }
    }

    @Override
    public String serializeResponseAsString(ResponseMessage responseMessage) throws SerializationException {
        try {
            return this.mapper.writeValueAsString(responseMessage);
        }
        catch (Exception ex) {
            logger.warn(String.format("Response [%s] could not be serialized by %s.", responseMessage.toString(), GraphSONMessageSerializerV3d0.class.getName()), (Throwable)ex);
            throw new SerializationException(ex);
        }
    }

    @Override
    public RequestMessage deserializeRequest(String msg) throws SerializationException {
        try {
            return this.mapper.readValue(msg, RequestMessage.class);
        }
        catch (Exception ex) {
            logger.warn(String.format("Request [%s] could not be deserialized by %s.", msg, GraphSONMessageSerializerV3d0.class.getName()), (Throwable)ex);
            throw new SerializationException(ex);
        }
    }

    @Override
    public String serializeRequestAsString(RequestMessage requestMessage) throws SerializationException {
        try {
            return this.mapper.writeValueAsString(requestMessage);
        }
        catch (Exception ex) {
            logger.warn(String.format("Request [%s] could not be serialized by %s.", requestMessage.toString(), GraphSONMessageSerializerV3d0.class.getName()), (Throwable)ex);
            throw new SerializationException(ex);
        }
    }

    static {
        ByteBuffer buffer = ByteBuffer.allocate(MIME_TYPE.length() + 1);
        buffer.put((byte)MIME_TYPE.length());
        buffer.put(MIME_TYPE.getBytes());
        header = buffer.array();
    }
}

