/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.tinkerpop.gremlin.groovy.jsr223.CompilationOptionsCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.CompileStaticGroovyCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.ConfigurationGroovyCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.InterpreterModeGroovyCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.ThreadInterruptGroovyCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.TimedInterruptGroovyCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.TypeCheckedGroovyCustomizer;
import org.apache.tinkerpop.gremlin.jsr223.AbstractGremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.Customizer;

public class GroovyCompilerGremlinPlugin
extends AbstractGremlinPlugin {
    private static final String NAME = "tinkerpop.groovy";

    private GroovyCompilerGremlinPlugin(Builder builder) {
        super(NAME, new HashSet<String>(Collections.singletonList("gremlin-groovy")), builder.asCustomizers());
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder {
        private boolean interpreterMode;
        private boolean threadInterrupt;
        private long timeInMillis = 0L;
        private Compilation compilation = Compilation.NONE;
        private String extensions = null;
        private int expectedCompilationTime = 5000;
        private Map<String, Object> keyValues = Collections.emptyMap();

        public Builder expectedCompilationTime(int timeInMillis) {
            this.expectedCompilationTime = timeInMillis;
            return this;
        }

        public Builder enableInterpreterMode(boolean interpreterMode) {
            this.interpreterMode = interpreterMode;
            return this;
        }

        public Builder compilerConfigurationOptions(Map<String, Object> keyValues) {
            this.keyValues = keyValues;
            return this;
        }

        public Builder enableThreadInterrupt(boolean threadInterrupt) {
            this.threadInterrupt = threadInterrupt;
            return this;
        }

        public Builder timedInterrupt(long timeInMillis) {
            this.timeInMillis = timeInMillis;
            return this;
        }

        public Builder compilation(Compilation compilation) {
            this.compilation = compilation;
            return this;
        }

        public Builder compilation(String compilation) {
            return this.compilation(Compilation.valueOf(compilation));
        }

        public Builder extensions(String extensions) {
            this.extensions = extensions;
            return this;
        }

        Customizer[] asCustomizers() {
            ArrayList<Customizer> list = new ArrayList<Customizer>();
            if (this.interpreterMode) {
                list.add(new InterpreterModeGroovyCustomizer());
            }
            if (!this.keyValues.isEmpty()) {
                list.add(new ConfigurationGroovyCustomizer(this.keyValues));
            }
            if (this.threadInterrupt) {
                list.add(new ThreadInterruptGroovyCustomizer());
            }
            if (this.timeInMillis > 0L) {
                list.add(new TimedInterruptGroovyCustomizer(this.timeInMillis));
            }
            if (this.expectedCompilationTime > 0) {
                list.add(new CompilationOptionsCustomizer(this.expectedCompilationTime));
            }
            if (this.compilation == Compilation.COMPILE_STATIC) {
                list.add(new CompileStaticGroovyCustomizer(this.extensions));
            } else if (this.compilation == Compilation.TYPE_CHECKED) {
                list.add(new TypeCheckedGroovyCustomizer(this.extensions));
            } else if (this.compilation != Compilation.NONE) {
                throw new IllegalStateException("Use of unknown compilation type: " + (Object)((Object)this.compilation));
            }
            if (list.isEmpty()) {
                throw new IllegalStateException("No customizer options have been selected for this plugin");
            }
            Customizer[] customizers = new Customizer[list.size()];
            list.toArray(customizers);
            return customizers;
        }

        public GroovyCompilerGremlinPlugin create() {
            return new GroovyCompilerGremlinPlugin(this);
        }
    }

    public static enum Compilation {
        COMPILE_STATIC,
        TYPE_CHECKED,
        NONE;

    }
}

