/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.clustering.connected;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.TraversalVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.util.AbstractVertexProgramBuilder;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.IndexedTraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.PureTraversal;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public class ConnectedComponentVertexProgram
implements VertexProgram<String> {
    public static final String COMPONENT = "gremlin.connectedComponentVertexProgram.component";
    private static final String PROPERTY = "gremlin.connectedComponentVertexProgram.property";
    private static final String EDGE_TRAVERSAL = "gremlin.pageRankVertexProgram.edgeTraversal";
    private static final String VOTE_TO_HALT = "gremlin.connectedComponentVertexProgram.voteToHalt";
    private static final Set<MemoryComputeKey> MEMORY_COMPUTE_KEYS = Collections.singleton(MemoryComputeKey.of("gremlin.connectedComponentVertexProgram.voteToHalt", Operator.and, false, true));
    private MessageScope.Local<?> scope = MessageScope.Local.of(() -> __.bothE(new String[0]));
    private Set<MessageScope> scopes;
    private String property = "gremlin.connectedComponentVertexProgram.component";
    private PureTraversal<Vertex, Edge> edgeTraversal = null;
    private Configuration configuration;
    private TraverserSet<Vertex> haltedTraversers;
    private IndexedTraverserSet<Vertex, Vertex> haltedTraversersIndex;

    private ConnectedComponentVertexProgram() {
    }

    @Override
    public void loadState(Graph graph, Configuration config) {
        this.configuration = new BaseConfiguration();
        if (config != null) {
            ConfigurationUtils.copy(config, this.configuration);
        }
        if (this.configuration.containsKey(EDGE_TRAVERSAL)) {
            this.edgeTraversal = PureTraversal.loadState(this.configuration, EDGE_TRAVERSAL, graph);
            this.scope = MessageScope.Local.of(() -> this.edgeTraversal.get().clone());
        }
        this.scopes = new HashSet(Collections.singletonList(this.scope));
        this.property = this.configuration.getString(PROPERTY, COMPONENT);
        this.haltedTraversers = TraversalVertexProgram.loadHaltedTraversers(this.configuration);
        this.haltedTraversersIndex = new IndexedTraverserSet<Vertex, Vertex>(v -> v);
        for (Traverser.Admin<Vertex> admin : this.haltedTraversers) {
            this.haltedTraversersIndex.add(admin.split());
        }
    }

    @Override
    public void storeState(Configuration config) {
        VertexProgram.super.storeState(config);
        if (this.configuration != null) {
            ConfigurationUtils.copy(this.configuration, config);
        }
    }

    @Override
    public void setup(Memory memory) {
        memory.set(VOTE_TO_HALT, true);
    }

    @Override
    public void execute(Vertex vertex, Messenger<String> messenger, Memory memory) {
        if (memory.isInitialIteration()) {
            this.copyHaltedTraversersFromMemory(vertex);
            vertex.property(VertexProperty.Cardinality.single, this.property, vertex.id().toString(), new Object[0]);
            if (vertex.edges(Direction.BOTH, new String[0]).hasNext()) {
                messenger.sendMessage(this.scope, vertex.id().toString());
                memory.add(VOTE_TO_HALT, false);
            }
        } else {
            String currentComponent = (String)vertex.value(this.property);
            boolean different = false;
            Iterator<String> componentIterator = messenger.receiveMessages();
            while (componentIterator.hasNext()) {
                String candidateComponent = componentIterator.next();
                if (candidateComponent.compareTo(currentComponent) >= 0) continue;
                currentComponent = candidateComponent;
                different = true;
            }
            if (different) {
                vertex.property(VertexProperty.Cardinality.single, this.property, currentComponent, new Object[0]);
                messenger.sendMessage(this.scope, currentComponent);
                memory.add(VOTE_TO_HALT, false);
            }
        }
    }

    @Override
    public Set<VertexComputeKey> getVertexComputeKeys() {
        return new HashSet<VertexComputeKey>(Arrays.asList(VertexComputeKey.of(this.property, false), VertexComputeKey.of("gremlin.traversalVertexProgram.haltedTraversers", false)));
    }

    @Override
    public Set<MemoryComputeKey> getMemoryComputeKeys() {
        return MEMORY_COMPUTE_KEYS;
    }

    @Override
    public boolean terminate(Memory memory) {
        boolean voteToHalt;
        if (memory.isInitialIteration() && this.haltedTraversersIndex != null) {
            this.haltedTraversersIndex.clear();
        }
        if (voteToHalt = ((Boolean)memory.get(VOTE_TO_HALT)).booleanValue()) {
            return true;
        }
        memory.set(VOTE_TO_HALT, true);
        return false;
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        return this.scopes;
    }

    @Override
    public GraphComputer.ResultGraph getPreferredResultGraph() {
        return GraphComputer.ResultGraph.NEW;
    }

    @Override
    public GraphComputer.Persist getPreferredPersist() {
        return GraphComputer.Persist.VERTEX_PROPERTIES;
    }

    public ConnectedComponentVertexProgram clone() {
        return this;
    }

    @Override
    public VertexProgram.Features getFeatures() {
        return new VertexProgram.Features(){

            @Override
            public boolean requiresLocalMessageScopes() {
                return true;
            }

            @Override
            public boolean requiresVertexPropertyAddition() {
                return true;
            }
        };
    }

    private void copyHaltedTraversersFromMemory(Vertex vertex) {
        Collection<Traverser.Admin<Vertex>> traversers = this.haltedTraversersIndex.get(vertex);
        if (traversers != null) {
            TraverserSet newHaltedTraversers = new TraverserSet();
            newHaltedTraversers.addAll(traversers);
            vertex.property(VertexProperty.Cardinality.single, "gremlin.traversalVertexProgram.haltedTraversers", newHaltedTraversers, new Object[0]);
        }
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractVertexProgramBuilder<Builder> {
        private Builder() {
            super(ConnectedComponentVertexProgram.class);
        }

        public Builder edges(Traversal.Admin<Vertex, Edge> edgeTraversal) {
            PureTraversal.storeState(this.configuration, ConnectedComponentVertexProgram.EDGE_TRAVERSAL, edgeTraversal);
            return this;
        }

        public Builder property(String key) {
            this.configuration.setProperty(ConnectedComponentVertexProgram.PROPERTY, key);
            return this;
        }
    }
}

