/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.traversal.step.map;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.TraversalVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.VertexProgramStep;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.PureTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class ProgramVertexProgramStep
extends VertexProgramStep {
    private final Map<String, Object> configuration = new HashMap<String, Object>();
    private final String toStringOfVertexProgram;
    private final Set<TraverserRequirement> traverserRequirements;

    public ProgramVertexProgramStep(Traversal.Admin traversal, VertexProgram vertexProgram) {
        super(traversal);
        MapConfiguration base = new MapConfiguration(this.configuration);
        base.setDelimiterParsingDisabled(true);
        vertexProgram.storeState(base);
        this.toStringOfVertexProgram = vertexProgram.toString();
        this.traverserRequirements = vertexProgram.getTraverserRequirements();
    }

    @Override
    public VertexProgram generateProgram(Graph graph, Memory memory) {
        MapConfiguration base = new MapConfiguration(this.configuration);
        base.setDelimiterParsingDisabled(true);
        PureTraversal.storeState(base, "gremlin.vertexProgramStep.rootTraversal", TraversalHelper.getRootTraversal(this.getTraversal()).clone());
        base.setProperty("gremlin.vertexProgramStep.stepId", this.getId());
        if (memory.exists("gremlin.traversalVertexProgram.haltedTraversers")) {
            TraversalVertexProgram.storeHaltedTraversers(base, (TraverserSet)memory.get("gremlin.traversalVertexProgram.haltedTraversers"));
        }
        return VertexProgram.createVertexProgram(graph, base);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.traverserRequirements;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.configuration.hashCode();
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.toStringOfVertexProgram, new GraphFilter(this.computer));
    }
}

