/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.remote.traversal.strategy.decoration;

import java.util.HashSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.decoration.VertexProgramStrategy;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.traversal.step.map.RemoteStep;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.ConnectiveStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.ElementIdStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.HaltedTraverserStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.PartitionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.RequirementsStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SackStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SideEffectStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SubgraphStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class RemoteStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    private final RemoteConnection remoteConnection;
    private static final Set<Class<? extends TraversalStrategy.DecorationStrategy>> POSTS = new HashSet<Class<? extends TraversalStrategy.DecorationStrategy>>(){
        {
            this.add(VertexProgramStrategy.class);
            this.add(ConnectiveStrategy.class);
            this.add(ElementIdStrategy.class);
            this.add(EventStrategy.class);
            this.add(HaltedTraverserStrategy.class);
            this.add(PartitionStrategy.class);
            this.add(RequirementsStrategy.class);
            this.add(SackStrategy.class);
            this.add(SideEffectStrategy.class);
            this.add(SubgraphStrategy.class);
        }
    };

    public RemoteStrategy(RemoteConnection remoteConnection) {
        if (null == remoteConnection) {
            throw new IllegalArgumentException("remoteConnection cannot be null");
        }
        this.remoteConnection = remoteConnection;
    }

    @Override
    public Set<Class<? extends TraversalStrategy.DecorationStrategy>> applyPost() {
        return POSTS;
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (!(traversal.getParent() instanceof EmptyStep)) {
            return;
        }
        RemoteStep remoteStep = new RemoteStep(traversal, this.remoteConnection);
        TraversalHelper.removeAllSteps(traversal);
        traversal.addStep(remoteStep);
        assert (traversal.getStartStep().equals(remoteStep));
        assert (traversal.getSteps().size() == 1);
        assert (traversal.getEndStep() == remoteStep);
    }
}

