/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.verification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.Parameterizing;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddEdgeStartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddEdgeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.AddPropertyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.AbstractWarningVerificationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException;

public class ReservedKeysVerificationStrategy
extends AbstractWarningVerificationStrategy {
    private static final String KEYS = "keys";
    private static final Set<String> DEFAULT_RESERVED_KEYS = new HashSet<String>(Arrays.asList("id", "label"));
    private final Set<String> reservedKeys;

    private ReservedKeysVerificationStrategy(Builder builder) {
        super(builder);
        this.reservedKeys = builder.reservedKeys;
    }

    @Override
    void verify(Traversal.Admin<?, ?> traversal) throws VerificationException {
        for (Step step : traversal.getSteps()) {
            if (!(step instanceof AddVertexStep) && !(step instanceof AddVertexStartStep) && !(step instanceof AddEdgeStartStep) && !(step instanceof AddEdgeStep) && !(step instanceof AddPropertyStep)) continue;
            Parameterizing propertySettingStep = (Parameterizing)((Object)step);
            Parameters params = propertySettingStep.getParameters();
            for (String key : this.reservedKeys) {
                if (!params.contains(key)) continue;
                String msg = String.format("The provided traversal contains a %s that is setting a property key to a reserved word: %s", propertySettingStep.getClass().getSimpleName(), key);
                throw new VerificationException(msg, traversal);
            }
        }
    }

    public static ReservedKeysVerificationStrategy create(Configuration configuration) {
        return ((Builder)((Builder)ReservedKeysVerificationStrategy.build().reservedKeys(configuration.getList(KEYS, new ArrayList<String>(DEFAULT_RESERVED_KEYS)).stream().map(Object::toString).collect(Collectors.toSet())).throwException(configuration.getBoolean("throwException", false))).logWarning(configuration.getBoolean("logWarning", false))).create();
    }

    public static Builder build() {
        return new Builder();
    }

    static /* synthetic */ Set access$200() {
        return DEFAULT_RESERVED_KEYS;
    }

    public static final class Builder
    extends AbstractWarningVerificationStrategy.Builder<ReservedKeysVerificationStrategy, Builder> {
        private Set<String> reservedKeys = ReservedKeysVerificationStrategy.access$200();

        private Builder() {
        }

        public Builder reservedKeys(Set<String> keys) {
            this.reservedKeys = keys;
            return this;
        }

        @Override
        public ReservedKeysVerificationStrategy create() {
            return new ReservedKeysVerificationStrategy(this);
        }
    }
}

