/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerProperty;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class TinkerEdge
extends TinkerElement
implements Edge {
    protected Map<String, Property> properties;
    protected final Vertex inVertex;
    protected final Vertex outVertex;

    protected TinkerEdge(Object id, Vertex outVertex, String label, Vertex inVertex) {
        super(id, label);
        this.outVertex = outVertex;
        this.inVertex = inVertex;
        TinkerHelper.autoUpdateIndex(this, T.label.getAccessor(), (Object)this.label, null);
    }

    @Override
    public <V> Property<V> property(String key, V value) {
        if (this.removed) {
            throw TinkerEdge.elementAlreadyRemoved(Edge.class, this.id);
        }
        ElementHelper.validateProperty(key, value);
        Property oldProperty = super.property(key);
        TinkerProperty<V> newProperty = new TinkerProperty<V>(this, key, value);
        if (null == this.properties) {
            this.properties = new HashMap<String, Property>();
        }
        this.properties.put(key, newProperty);
        TinkerHelper.autoUpdateIndex(this, key, value, oldProperty.isPresent() ? oldProperty.value() : null);
        return newProperty;
    }

    @Override
    public <V> Property<V> property(String key) {
        return null == this.properties ? Property.empty() : this.properties.getOrDefault(key, Property.empty());
    }

    @Override
    public Set<String> keys() {
        return null == this.properties ? Collections.emptySet() : this.properties.keySet();
    }

    @Override
    public void remove() {
        Set<Edge> edges;
        TinkerVertex outVertex = (TinkerVertex)this.outVertex;
        TinkerVertex inVertex = (TinkerVertex)this.inVertex;
        if (null != outVertex && null != outVertex.outEdges && null != (edges = outVertex.outEdges.get(this.label()))) {
            edges.remove(this);
        }
        if (null != inVertex && null != inVertex.inEdges && null != (edges = inVertex.inEdges.get(this.label()))) {
            edges.remove(this);
        }
        TinkerHelper.removeElementIndex(this);
        ((TinkerGraph)this.graph()).edges.remove(this.id());
        this.properties = null;
        this.removed = true;
    }

    public String toString() {
        return StringFactory.edgeString(this);
    }

    @Override
    public Vertex outVertex() {
        return this.outVertex;
    }

    @Override
    public Vertex inVertex() {
        return this.inVertex;
    }

    @Override
    public Iterator<Vertex> vertices(Direction direction) {
        if (this.removed) {
            return Collections.emptyIterator();
        }
        switch (direction) {
            case OUT: {
                return IteratorUtils.of(this.outVertex);
            }
            case IN: {
                return IteratorUtils.of(this.inVertex);
            }
        }
        return IteratorUtils.of(this.outVertex, this.inVertex);
    }

    @Override
    public Graph graph() {
        return this.inVertex.graph();
    }

    @Override
    public <V> Iterator<Property<V>> properties(String ... propertyKeys) {
        if (null == this.properties) {
            return Collections.emptyIterator();
        }
        if (propertyKeys.length == 1) {
            Property property = this.properties.get(propertyKeys[0]);
            return null == property ? Collections.emptyIterator() : IteratorUtils.of(property);
        }
        return this.properties.entrySet().stream().filter(entry -> ElementHelper.keyExists((String)entry.getKey(), propertyKeys)).map(entry -> (Property)entry.getValue()).collect(Collectors.toList()).iterator();
    }
}

