/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerGraphComputerView;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;

public final class TinkerHelper {
    private TinkerHelper() {
    }

    protected static Edge addEdge(TinkerGraph graph, TinkerVertex outVertex, TinkerVertex inVertex, String label, Object ... keyValues) {
        ElementHelper.validateLabel(label);
        ElementHelper.legalPropertyKeyValueArray(keyValues);
        Object idValue = graph.edgeIdManager.convert(ElementHelper.getIdValue(keyValues).orElse(null));
        if (null != idValue) {
            if (graph.edges.containsKey(idValue)) {
                throw Graph.Exceptions.edgeWithIdAlreadyExists(idValue);
            }
        } else {
            idValue = graph.edgeIdManager.getNextId(graph);
        }
        TinkerEdge edge = new TinkerEdge(idValue, outVertex, label, inVertex);
        ElementHelper.attachProperties(edge, keyValues);
        graph.edges.put(edge.id(), edge);
        TinkerHelper.addOutEdge(outVertex, label, edge);
        TinkerHelper.addInEdge(inVertex, label, edge);
        return edge;
    }

    protected static void addOutEdge(TinkerVertex vertex, String label, Edge edge) {
        Set<Edge> edges;
        if (null == vertex.outEdges) {
            vertex.outEdges = new HashMap<String, Set<Edge>>();
        }
        if (null == (edges = vertex.outEdges.get(label))) {
            edges = new HashSet<Edge>();
            vertex.outEdges.put(label, edges);
        }
        edges.add(edge);
    }

    protected static void addInEdge(TinkerVertex vertex, String label, Edge edge) {
        Set<Edge> edges;
        if (null == vertex.inEdges) {
            vertex.inEdges = new HashMap<String, Set<Edge>>();
        }
        if (null == (edges = vertex.inEdges.get(label))) {
            edges = new HashSet<Edge>();
            vertex.inEdges.put(label, edges);
        }
        edges.add(edge);
    }

    public static List<TinkerVertex> queryVertexIndex(TinkerGraph graph, String key, Object value) {
        return null == graph.vertexIndex ? Collections.emptyList() : graph.vertexIndex.get(key, value);
    }

    public static List<TinkerEdge> queryEdgeIndex(TinkerGraph graph, String key, Object value) {
        return null == graph.edgeIndex ? Collections.emptyList() : graph.edgeIndex.get(key, value);
    }

    public static boolean inComputerMode(TinkerGraph graph) {
        return null != graph.graphComputerView;
    }

    public static TinkerGraphComputerView createGraphComputerView(TinkerGraph graph, GraphFilter graphFilter, Set<VertexComputeKey> computeKeys) {
        graph.graphComputerView = new TinkerGraphComputerView(graph, graphFilter, computeKeys);
        return graph.graphComputerView;
    }

    public static TinkerGraphComputerView getGraphComputerView(TinkerGraph graph) {
        return graph.graphComputerView;
    }

    public static void dropGraphComputerView(TinkerGraph graph) {
        graph.graphComputerView = null;
    }

    public static Map<String, List<VertexProperty>> getProperties(TinkerVertex vertex) {
        return null == vertex.properties ? Collections.emptyMap() : vertex.properties;
    }

    public static void autoUpdateIndex(TinkerEdge edge, String key, Object newValue, Object oldValue) {
        TinkerGraph graph = (TinkerGraph)edge.graph();
        if (graph.edgeIndex != null) {
            graph.edgeIndex.autoUpdate(key, newValue, oldValue, edge);
        }
    }

    public static void autoUpdateIndex(TinkerVertex vertex, String key, Object newValue, Object oldValue) {
        TinkerGraph graph = (TinkerGraph)vertex.graph();
        if (graph.vertexIndex != null) {
            graph.vertexIndex.autoUpdate(key, newValue, oldValue, vertex);
        }
    }

    public static void removeElementIndex(TinkerVertex vertex) {
        TinkerGraph graph = (TinkerGraph)vertex.graph();
        if (graph.vertexIndex != null) {
            graph.vertexIndex.removeElement(vertex);
        }
    }

    public static void removeElementIndex(TinkerEdge edge) {
        TinkerGraph graph = (TinkerGraph)edge.graph();
        if (graph.edgeIndex != null) {
            graph.edgeIndex.removeElement(edge);
        }
    }

    public static void removeIndex(TinkerVertex vertex, String key, Object value) {
        TinkerGraph graph = (TinkerGraph)vertex.graph();
        if (graph.vertexIndex != null) {
            graph.vertexIndex.remove(key, value, vertex);
        }
    }

    public static void removeIndex(TinkerEdge edge, String key, Object value) {
        TinkerGraph graph = (TinkerGraph)edge.graph();
        if (graph.edgeIndex != null) {
            graph.edgeIndex.remove(key, value, edge);
        }
    }

    public static Iterator<TinkerEdge> getEdges(TinkerVertex vertex, Direction direction, String ... edgeLabels) {
        ArrayList edges = new ArrayList();
        if ((direction.equals((Object)Direction.OUT) || direction.equals((Object)Direction.BOTH)) && vertex.outEdges != null) {
            if (edgeLabels.length == 0) {
                vertex.outEdges.values().forEach(edges::addAll);
            } else if (edgeLabels.length == 1) {
                edges.addAll(vertex.outEdges.getOrDefault(edgeLabels[0], Collections.emptySet()));
            } else {
                Stream.of(edgeLabels).map(vertex.outEdges::get).filter(Objects::nonNull).forEach(edges::addAll);
            }
        }
        if ((direction.equals((Object)Direction.IN) || direction.equals((Object)Direction.BOTH)) && vertex.inEdges != null) {
            if (edgeLabels.length == 0) {
                vertex.inEdges.values().forEach(edges::addAll);
            } else if (edgeLabels.length == 1) {
                edges.addAll(vertex.inEdges.getOrDefault(edgeLabels[0], Collections.emptySet()));
            } else {
                Stream.of(edgeLabels).map(vertex.inEdges::get).filter(Objects::nonNull).forEach(edges::addAll);
            }
        }
        return edges.iterator();
    }

    public static Iterator<TinkerVertex> getVertices(TinkerVertex vertex, Direction direction, String ... edgeLabels) {
        ArrayList vertices = new ArrayList();
        if ((direction.equals((Object)Direction.OUT) || direction.equals((Object)Direction.BOTH)) && vertex.outEdges != null) {
            if (edgeLabels.length == 0) {
                vertex.outEdges.values().forEach(set -> set.forEach(edge -> vertices.add(((TinkerEdge)edge).inVertex)));
            } else if (edgeLabels.length == 1) {
                vertex.outEdges.getOrDefault(edgeLabels[0], Collections.emptySet()).forEach(edge -> vertices.add(((TinkerEdge)edge).inVertex));
            } else {
                Stream.of(edgeLabels).map(vertex.outEdges::get).filter(Objects::nonNull).flatMap(Collection::stream).forEach(edge -> vertices.add(((TinkerEdge)edge).inVertex));
            }
        }
        if ((direction.equals((Object)Direction.IN) || direction.equals((Object)Direction.BOTH)) && vertex.inEdges != null) {
            if (edgeLabels.length == 0) {
                vertex.inEdges.values().forEach(set -> set.forEach(edge -> vertices.add(((TinkerEdge)edge).outVertex)));
            } else if (edgeLabels.length == 1) {
                vertex.inEdges.getOrDefault(edgeLabels[0], Collections.emptySet()).forEach(edge -> vertices.add(((TinkerEdge)edge).outVertex));
            } else {
                Stream.of(edgeLabels).map(vertex.inEdges::get).filter(Objects::nonNull).flatMap(Collection::stream).forEach(edge -> vertices.add(((TinkerEdge)edge).outVertex));
            }
        }
        return vertices.iterator();
    }

    public static Map<Object, Vertex> getVertices(TinkerGraph graph) {
        return graph.vertices;
    }

    public static Map<Object, Edge> getEdges(TinkerGraph graph) {
        return graph.edges;
    }
}

