/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core;

import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphException;

public class InvalidElementException
extends JanusGraphException {
    private final JanusGraphElement element;

    public InvalidElementException(String msg, JanusGraphElement element) {
        super(msg);
        this.element = element;
    }

    public JanusGraphElement getElement() {
        return this.element;
    }

    @Override
    public String toString() {
        return super.toString() + " [" + this.element.toString() + "]";
    }

    public static IllegalStateException removedException(JanusGraphElement element) {
        Class<Vertex> elementClass = Vertex.class.isAssignableFrom(element.getClass()) ? Vertex.class : (Edge.class.isAssignableFrom(element.getClass()) ? Edge.class : VertexProperty.class);
        return new IllegalStateException(String.format("%s with id %s was removed.", elementClass.getSimpleName(), element.id()));
    }
}

