/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.time.Instant;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphManagerUtility;
import org.janusgraph.core.log.LogProcessorFramework;
import org.janusgraph.core.log.TransactionRecovery;
import org.janusgraph.diskstorage.Backend;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.StandardStoreManager;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.builder.GraphDatabaseConfigurationBuilder;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.log.StandardLogProcessorFramework;
import org.janusgraph.graphdb.log.StandardTransactionLogProcessor;
import org.janusgraph.graphdb.management.JanusGraphManager;
import org.janusgraph.util.system.IOUtils;
import org.janusgraph.util.system.LoggerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JanusGraphFactory {
    private static final Logger log = LoggerFactory.getLogger(JanusGraphFactory.class);

    public static JanusGraph open(String shortcutOrFile) {
        return JanusGraphFactory.open(JanusGraphFactory.getLocalConfiguration(shortcutOrFile));
    }

    public static JanusGraph open(String shortcutOrFile, String backupName) {
        return JanusGraphFactory.open(JanusGraphFactory.getLocalConfiguration(shortcutOrFile), backupName);
    }

    public static JanusGraph open(Configuration configuration) {
        return JanusGraphFactory.open(new CommonsConfiguration(configuration));
    }

    public static JanusGraph open(BasicConfiguration configuration) {
        return JanusGraphFactory.open(configuration.getConfiguration());
    }

    public static JanusGraph open(ReadConfiguration configuration) {
        return JanusGraphFactory.open(configuration, null);
    }

    public static JanusGraph open(ReadConfiguration configuration, String backupName) {
        ModifiableConfiguration config = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, (WriteConfiguration)configuration, BasicConfiguration.Restriction.NONE);
        String graphName = config.has(GraphDatabaseConfiguration.GRAPH_NAME, new String[0]) ? config.get(GraphDatabaseConfiguration.GRAPH_NAME, new String[0]) : backupName;
        JanusGraphManager jgm = JanusGraphManagerUtility.getInstance();
        if (null != graphName) {
            Preconditions.checkNotNull((Object)jgm, (Object)"Gremlin Server must be configured to use the JanusGraphManager.");
            return (JanusGraph)jgm.openGraph(graphName, gName -> new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build(configuration)));
        }
        if (jgm != null) {
            log.warn("You should supply \"graph.graphname\" in your .properties file configuration if you are opening a graph that has not already been opened at server start, i.e. it was defined in your YAML file. This will ensure the graph is tracked by the JanusGraphManager, which will enable autocommit and rollback functionality upon all gremlin script executions. Note that JanusGraphFactory#open(String === shortcut notation) does not support consuming the property \"graph.graphname\" so these graphs should be accessed dynamically by supplying a .properties file here or by using the ConfiguredGraphFactory.");
        }
        return new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build(configuration));
    }

    public static Set<String> getGraphNames() {
        JanusGraphManager jgm = JanusGraphManagerUtility.getInstance();
        Preconditions.checkNotNull((Object)jgm, (Object)"Gremlin Server must be configured to use the JanusGraphManager.");
        return jgm.getGraphNames();
    }

    public static void close(Graph graph) throws Exception {
        JanusGraphManager jgm = JanusGraphManagerUtility.getInstance();
        if (jgm != null) {
            jgm.removeGraph(((StandardJanusGraph)graph).getGraphName());
        }
        graph.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drop(JanusGraph graph) throws BackendException {
        Preconditions.checkNotNull((Object)graph);
        Preconditions.checkArgument((boolean)(graph instanceof StandardJanusGraph), (String)"Invalid graph instance detected: %s", (Object[])new Object[]{graph.getClass()});
        StandardJanusGraph g = (StandardJanusGraph)graph;
        JanusGraphManager jgm = JanusGraphManagerUtility.getInstance();
        if (jgm != null) {
            jgm.removeGraph(g.getGraphName());
        }
        if (graph.isOpen()) {
            graph.close();
        }
        GraphDatabaseConfiguration config = g.getConfiguration();
        Backend backend = config.getBackend();
        try {
            backend.clearStorage();
        }
        finally {
            IOUtils.closeQuietly(backend);
        }
    }

    public static Builder build() {
        return new Builder();
    }

    public static LogProcessorFramework openTransactionLog(JanusGraph graph) {
        return new StandardLogProcessorFramework((StandardJanusGraph)graph);
    }

    public static TransactionRecovery startTransactionRecovery(JanusGraph graph, Instant start) {
        return new StandardTransactionLogProcessor((StandardJanusGraph)graph, start);
    }

    private static ReadConfiguration getLocalConfiguration(String shortcutOrFile) {
        File file = new File(shortcutOrFile);
        if (file.exists()) {
            return JanusGraphFactory.getLocalConfiguration(file);
        }
        int pos = shortcutOrFile.indexOf(58);
        if (pos < 0) {
            pos = shortcutOrFile.length();
        }
        String backend = shortcutOrFile.substring(0, pos);
        Preconditions.checkArgument((boolean)StandardStoreManager.getAllManagerClasses().containsKey(backend.toLowerCase()), (String)"Backend shorthand unknown: %s", (Object[])new Object[]{backend});
        String secondArg = null;
        if (pos + 1 < shortcutOrFile.length()) {
            secondArg = shortcutOrFile.substring(pos + 1).trim();
        }
        BaseConfiguration config = new BaseConfiguration();
        ModifiableConfiguration writeConfig = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, new CommonsConfiguration(config), BasicConfiguration.Restriction.NONE);
        writeConfig.set(GraphDatabaseConfiguration.STORAGE_BACKEND, backend, new String[0]);
        ConfigOption<?> option = Backend.getOptionForShorthand(backend);
        if (option == null) {
            Preconditions.checkArgument((secondArg == null ? 1 : 0) != 0);
        } else if (option == GraphDatabaseConfiguration.STORAGE_DIRECTORY || option == GraphDatabaseConfiguration.STORAGE_CONF_FILE) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank(secondArg), (Object)"Need to provide additional argument to initialize storage backend");
            writeConfig.set(option, JanusGraphFactory.getAbsolutePath(secondArg), new String[0]);
        } else if (option == GraphDatabaseConfiguration.STORAGE_HOSTS) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank(secondArg), (Object)"Need to provide additional argument to initialize storage backend");
            writeConfig.set(option, new String[]{secondArg}, new String[0]);
        } else {
            throw new IllegalArgumentException("Invalid configuration option for backend " + option);
        }
        return new CommonsConfiguration(config);
    }

    private static ReadConfiguration getLocalConfiguration(File file) {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkArgument((file.exists() && file.isFile() && file.canRead() ? 1 : 0) != 0, (String)"Need to specify a readable configuration file, but was given: %s", (Object[])new Object[]{file.toString()});
        try {
            PropertiesConfiguration configuration = new PropertiesConfiguration(file);
            File tmpParent = file.getParentFile();
            File configParent = null == tmpParent ? new File(System.getProperty("user.dir")) : tmpParent;
            Preconditions.checkNotNull((Object)configParent);
            Preconditions.checkArgument((boolean)configParent.isDirectory());
            Pattern p = Pattern.compile("(" + Pattern.quote(GraphDatabaseConfiguration.STORAGE_NS.getName()) + "\\..*(" + Pattern.quote(GraphDatabaseConfiguration.STORAGE_DIRECTORY.getName()) + "|" + Pattern.quote(GraphDatabaseConfiguration.STORAGE_CONF_FILE.getName()) + ")|" + Pattern.quote(GraphDatabaseConfiguration.INDEX_NS.getName()) + "\\..*(" + Pattern.quote(GraphDatabaseConfiguration.INDEX_DIRECTORY.getName()) + "|" + Pattern.quote(GraphDatabaseConfiguration.INDEX_CONF_FILE.getName()) + "))");
            UnmodifiableIterator keysToMangle = Iterators.filter(configuration.getKeys(), key -> null != key && p.matcher((CharSequence)key).matches());
            while (keysToMangle.hasNext()) {
                String k = (String)keysToMangle.next();
                Preconditions.checkNotNull((Object)k);
                String s = configuration.getString(k);
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank(s), (String)"Invalid Configuration: key %s has null empty value", (Object[])new Object[]{k});
                configuration.setProperty(k, JanusGraphFactory.getAbsolutePath(configParent, s));
            }
            return new CommonsConfiguration(configuration);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Could not load configuration at: " + file, e);
        }
    }

    private static String getAbsolutePath(String file) {
        return JanusGraphFactory.getAbsolutePath(new File(System.getProperty("user.dir")), file);
    }

    private static String getAbsolutePath(File configParent, String file) {
        File storeDirectory = new File(file);
        if (!storeDirectory.isAbsolute()) {
            String newFile = configParent.getAbsolutePath() + File.separator + file;
            log.debug("Overwrote relative path: was {}, now {}", (Object)LoggerUtil.sanitizeAndLaunder(file), (Object)LoggerUtil.sanitizeAndLaunder(newFile));
            return newFile;
        }
        log.debug("Loaded absolute path for key: {}", (Object)LoggerUtil.sanitizeAndLaunder(file));
        return file;
    }

    public static class Builder {
        private final WriteConfiguration writeConfiguration = new CommonsConfiguration();

        private Builder() {
        }

        public Builder set(String path, Object value) {
            this.writeConfiguration.set(path, value);
            return this;
        }

        public JanusGraph open() {
            ModifiableConfiguration mc = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, this.writeConfiguration.copy(), BasicConfiguration.Restriction.NONE);
            return JanusGraphFactory.open(mc);
        }
    }
}

