/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;

public abstract class ConfigElement {
    public static final char SEPARATOR = '.';
    public static final char[] ILLEGAL_CHARS = new char[]{'.', ' ', '\t', '#', '@', '<', '>', '?', '/', ';', '\"', '\'', ':', '+', '(', ')', '*', '^', '`', '~', '$', '%', '|', '\\', '{', '[', ']', '}'};
    private final ConfigNamespace namespace;
    private final String name;
    private final String description;

    public ConfigElement(ConfigNamespace namespace, String name, String description) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(name), (String)"Name cannot be empty: %s", (Object[])new Object[]{name});
        Preconditions.checkArgument((!StringUtils.containsAny(name, ILLEGAL_CHARS) ? 1 : 0) != 0, (String)"Name contains illegal character: %s (%s)", (Object[])new Object[]{name, ILLEGAL_CHARS});
        Preconditions.checkArgument((namespace != null || this instanceof ConfigNamespace ? 1 : 0) != 0, (Object)"Need to specify namespace for ConfigOption");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(description));
        this.namespace = namespace;
        this.name = name;
        this.description = description;
        if (namespace != null) {
            namespace.registerChild(this);
        }
    }

    public ConfigNamespace getNamespace() {
        Preconditions.checkArgument((this.namespace != null ? 1 : 0) != 0, (Object)"Cannot get namespace of root");
        return this.namespace;
    }

    public boolean isRoot() {
        return this.namespace == null;
    }

    public ConfigNamespace getRoot() {
        if (this.isRoot()) {
            return (ConfigNamespace)this;
        }
        return this.getNamespace().getRoot();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract boolean isOption();

    public boolean isNamespace() {
        return !this.isOption();
    }

    public String toString() {
        return (this.namespace != null ? this.namespace.toString() + '.' : "") + this.name;
    }

    public String toStringWithoutRoot() {
        return this.toString().substring(this.getRoot().toString().length() + 1);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.namespace);
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (!this.getClass().isInstance(oth)) {
            return false;
        }
        ConfigElement c = (ConfigElement)oth;
        return this.name.equals(c.name) && this.namespace == c.namespace;
    }

    public static String[] getComponents(String path) {
        return StringUtils.split(path, '.');
    }

    public static String toString(ConfigElement element) {
        String result = element.getName();
        if (element.isNamespace()) {
            result = "+ " + result;
            if (((ConfigNamespace)element).isUmbrella()) {
                result = result + " [*]";
            }
        } else {
            result = "- " + result;
            ConfigOption option = (ConfigOption)element;
            result = result + " [";
            switch (option.getType()) {
                case FIXED: {
                    result = result + "f";
                    break;
                }
                case GLOBAL_OFFLINE: {
                    result = result + "g!";
                    break;
                }
                case GLOBAL: {
                    result = result + "g";
                    break;
                }
                case MASKABLE: {
                    result = result + "m";
                    break;
                }
                case LOCAL: {
                    result = result + "l";
                }
            }
            result = result + "," + option.getDatatype().getSimpleName();
            result = result + "," + option.getDefaultValue();
            result = result + "]";
        }
        result = result + "\n";
        String desc = element.getDescription();
        result = result + "\t\"" + desc.substring(0, Math.min(desc.length(), 50)) + '\"';
        return result;
    }

    public static String getPath(ConfigElement element, String ... umbrellaElements) {
        return ConfigElement.getPath(element, false, umbrellaElements);
    }

    public static String getPath(ConfigElement element, boolean includeRoot, String ... umbrellaElements) {
        Preconditions.checkNotNull((Object)element);
        if (umbrellaElements == null) {
            umbrellaElements = new String[]{};
        }
        StringBuilder path = new StringBuilder(element.getName());
        int umbrellaPos = umbrellaElements.length - 1;
        while (!element.isRoot() && !element.getNamespace().isRoot()) {
            ConfigNamespace parent = element.getNamespace();
            if (parent.isUmbrella()) {
                Preconditions.checkArgument((umbrellaPos >= 0 ? 1 : 0) != 0, (String)"Missing umbrella element path for element: %s", (Object[])new Object[]{element});
                String umbrellaName = umbrellaElements[umbrellaPos];
                Preconditions.checkArgument((!StringUtils.containsAny(umbrellaName, ILLEGAL_CHARS) ? 1 : 0) != 0, (String)"Invalid umbrella name provided: %s. Contains illegal chars", (Object[])new Object[]{umbrellaName});
                path.insert(0, umbrellaName + '.');
                --umbrellaPos;
            }
            path.insert(0, parent.getName() + '.');
            element = parent;
        }
        if (includeRoot) {
            path.insert(0, (element.isRoot() ? element.getName() : element.getNamespace().getName()) + '.');
        }
        Preconditions.checkArgument((umbrellaPos < 0 ? 1 : 0) != 0, (String)"Found unused umbrella element: %s", (Object[])new Object[]{umbrellaPos < 0 ? null : umbrellaElements[umbrellaPos]});
        return path.toString();
    }

    public static PathIdentifier parse(ConfigNamespace root, String path) {
        Preconditions.checkNotNull((Object)root);
        if (StringUtils.isBlank(path)) {
            return new PathIdentifier(root, new String[0], false);
        }
        String[] components = ConfigElement.getComponents(path);
        Preconditions.checkArgument((components.length > 0 ? 1 : 0) != 0, (String)"Empty path provided: %s", (Object[])new Object[]{path});
        ArrayList umbrellaElements = Lists.newArrayList();
        ConfigNamespace parent = root;
        ConfigElement last = root;
        boolean lastIsUmbrella = false;
        for (int i = 0; i < components.length; ++i) {
            if (parent.isUmbrella() && !lastIsUmbrella) {
                umbrellaElements.add(components[i]);
                lastIsUmbrella = true;
                continue;
            }
            last = parent.getChild(components[i]);
            Preconditions.checkArgument((last != null ? 1 : 0) != 0, (String)"Unknown configuration element in namespace [%s]: %s", (Object[])new Object[]{parent.toString(), components[i]});
            if (i + 1 < components.length) {
                Preconditions.checkArgument((boolean)(last instanceof ConfigNamespace), (String)"Expected namespace at position [%s] of [%s] but got: %s", (Object[])new Object[]{i, path, last});
                parent = last;
            }
            lastIsUmbrella = false;
        }
        return new PathIdentifier(last, umbrellaElements.toArray(new String[umbrellaElements.size()]), lastIsUmbrella);
    }

    public static class PathIdentifier {
        public final ConfigElement element;
        public final String[] umbrellaElements;
        public final boolean lastIsUmbrella;

        private PathIdentifier(ConfigElement element, String[] umbrellaElements, boolean lastIsUmbrella) {
            this.lastIsUmbrella = lastIsUmbrella;
            Preconditions.checkNotNull((Object)element);
            Preconditions.checkNotNull((Object)umbrellaElements);
            this.element = element;
            this.umbrellaElements = umbrellaElements;
        }

        public boolean hasUmbrellaElements() {
            return this.umbrellaElements.length > 0;
        }
    }
}

