/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.keycolumnvalue.cache;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.cache.CachableStaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.cache.KCVSCache;
import org.janusgraph.diskstorage.util.CacheMetricsAction;

public class ExpirationKCVSCache
extends KCVSCache {
    private static final int STATIC_ARRAY_BUFFER_SIZE = 64;
    private static final int KEY_QUERY_SIZE = 233;
    private static final int INVALIDATE_KEY_FRACTION_PENALTY = 1000;
    private static final int PENALTY_THRESHOLD = 5;
    private volatile CountDownLatch penaltyCountdown;
    private final Cache<KeySliceQuery, EntryList> cache;
    private final ConcurrentHashMap<StaticBuffer, Long> expiredKeys;
    private final long cacheTimeMS;
    private final long invalidationGracePeriodMS;
    private final CleanupThread cleanupThread;

    public ExpirationKCVSCache(KeyColumnValueStore store, String metricsName, long cacheTimeMS, long invalidationGracePeriodMS, long maximumByteSize) {
        super(store, metricsName);
        Preconditions.checkArgument((cacheTimeMS > 0L ? 1 : 0) != 0, (String)"Cache expiration must be positive: %s", (Object[])new Object[]{cacheTimeMS});
        Preconditions.checkArgument((System.currentTimeMillis() + 3153600000000L + cacheTimeMS > 0L ? 1 : 0) != 0, (String)"Cache expiration time too large, overflow may occur: %s", (Object[])new Object[]{cacheTimeMS});
        this.cacheTimeMS = cacheTimeMS;
        int concurrencyLevel = Runtime.getRuntime().availableProcessors();
        Preconditions.checkArgument((invalidationGracePeriodMS >= 0L ? 1 : 0) != 0, (String)"Invalid expiration grace period: %s", (Object[])new Object[]{invalidationGracePeriodMS});
        this.invalidationGracePeriodMS = invalidationGracePeriodMS;
        CacheBuilder cachebuilder = CacheBuilder.newBuilder().maximumWeight(maximumByteSize).concurrencyLevel(concurrencyLevel).initialCapacity(1000).expireAfterWrite(cacheTimeMS, TimeUnit.MILLISECONDS).weigher((keySliceQuery, entries) -> 337 + entries.getByteSize());
        this.cache = cachebuilder.build();
        this.expiredKeys = new ConcurrentHashMap(50, 0.75f, concurrencyLevel);
        this.penaltyCountdown = new CountDownLatch(5);
        this.cleanupThread = new CleanupThread();
        this.cleanupThread.start();
    }

    @Override
    public EntryList getSlice(KeySliceQuery query, StoreTransaction txh) throws BackendException {
        this.incActionBy(1, CacheMetricsAction.RETRIEVAL, txh);
        if (this.isExpired(query)) {
            this.incActionBy(1, CacheMetricsAction.MISS, txh);
            return this.store.getSlice(query, this.unwrapTx(txh));
        }
        try {
            return (EntryList)this.cache.get((Object)query, () -> {
                this.incActionBy(1, CacheMetricsAction.MISS, txh);
                return this.store.getSlice(query, this.unwrapTx(txh));
            });
        }
        catch (Exception e) {
            if (e instanceof JanusGraphException) {
                throw (JanusGraphException)e;
            }
            if (e.getCause() instanceof JanusGraphException) {
                throw (JanusGraphException)e.getCause();
            }
            throw new JanusGraphException(e);
        }
    }

    @Override
    public Map<StaticBuffer, EntryList> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
        HashMap<StaticBuffer, EntryList> results = new HashMap<StaticBuffer, EntryList>(keys.size());
        ArrayList<StaticBuffer> remainingKeys = new ArrayList<StaticBuffer>(keys.size());
        KeySliceQuery[] ksqs = new KeySliceQuery[keys.size()];
        this.incActionBy(keys.size(), CacheMetricsAction.RETRIEVAL, txh);
        for (int i = 0; i < keys.size(); ++i) {
            StaticBuffer key = keys.get(i);
            ksqs[i] = new KeySliceQuery(key, query);
            EntryList result = null;
            if (!this.isExpired(ksqs[i])) {
                result = (EntryList)this.cache.getIfPresent((Object)ksqs[i]);
            } else {
                ksqs[i] = null;
            }
            if (result != null) {
                results.put(key, result);
                continue;
            }
            remainingKeys.add(key);
        }
        if (!remainingKeys.isEmpty()) {
            this.incActionBy(remainingKeys.size(), CacheMetricsAction.MISS, txh);
            Map<StaticBuffer, EntryList> subresults = this.store.getSlice(remainingKeys, query, this.unwrapTx(txh));
            for (int i = 0; i < keys.size(); ++i) {
                StaticBuffer key = keys.get(i);
                EntryList subresult = subresults.get(key);
                if (subresult == null) continue;
                results.put(key, subresult);
                if (ksqs[i] == null) continue;
                this.cache.put((Object)ksqs[i], (Object)subresult);
            }
        }
        return results;
    }

    @Override
    public void clearCache() {
        this.cache.invalidateAll();
        this.expiredKeys.clear();
        this.penaltyCountdown = new CountDownLatch(5);
    }

    @Override
    public void invalidate(StaticBuffer key, List<CachableStaticBuffer> entries) {
        Preconditions.checkArgument((!this.hasValidateKeysOnly() || entries.isEmpty() ? 1 : 0) != 0);
        this.expiredKeys.put(key, this.getExpirationTime());
        if (Math.random() < 0.001) {
            this.penaltyCountdown.countDown();
        }
    }

    @Override
    public void close() throws BackendException {
        this.cleanupThread.stopThread();
        super.close();
    }

    private boolean isExpired(KeySliceQuery query) {
        Long until = (Long)this.expiredKeys.get(query.getKey());
        if (until == null) {
            return false;
        }
        if (this.isBeyondExpirationTime(until)) {
            this.expiredKeys.remove(query.getKey(), until);
            return false;
        }
        this.penaltyCountdown.countDown();
        return true;
    }

    private long getExpirationTime() {
        return System.currentTimeMillis() + this.cacheTimeMS;
    }

    private boolean isBeyondExpirationTime(long until) {
        return until < System.currentTimeMillis();
    }

    private long getAge(long until) {
        long age = System.currentTimeMillis() - (until - this.cacheTimeMS);
        assert (age >= 0L);
        return age;
    }

    private class CleanupThread
    extends Thread {
        private boolean stop = false;

        public CleanupThread() {
            this.setDaemon(true);
            this.setName("ExpirationStoreCache-" + this.getId());
        }

        @Override
        public void run() {
            block2: while (!this.stop) {
                try {
                    ExpirationKCVSCache.this.penaltyCountdown.await();
                }
                catch (InterruptedException e) {
                    if (this.stop) {
                        return;
                    }
                    throw new RuntimeException("Cleanup thread got interrupted", e);
                }
                HashMap expiredKeysCopy = new HashMap(ExpirationKCVSCache.this.expiredKeys.size());
                for (Map.Entry<Object, Object> expKey : ExpirationKCVSCache.this.expiredKeys.entrySet()) {
                    if (ExpirationKCVSCache.this.isBeyondExpirationTime((Long)expKey.getValue())) {
                        ExpirationKCVSCache.this.expiredKeys.remove(expKey.getKey(), expKey.getValue());
                        continue;
                    }
                    if (ExpirationKCVSCache.this.getAge((Long)expKey.getValue()) < ExpirationKCVSCache.this.invalidationGracePeriodMS) continue;
                    expiredKeysCopy.put(expKey.getKey(), expKey.getValue());
                }
                for (KeySliceQuery ksq : ExpirationKCVSCache.this.cache.asMap().keySet()) {
                    if (!expiredKeysCopy.containsKey(ksq.getKey())) continue;
                    ExpirationKCVSCache.this.cache.invalidate((Object)ksq);
                }
                ExpirationKCVSCache.this.penaltyCountdown = new CountDownLatch(5);
                Iterator<Map.Entry<Object, Object>> iterator = expiredKeysCopy.entrySet().iterator();
                while (true) {
                    Map.Entry<Object, Object> expKey;
                    if (!iterator.hasNext()) continue block2;
                    expKey = iterator.next();
                    ExpirationKCVSCache.this.expiredKeys.remove(expKey.getKey(), expKey.getValue());
                }
                break;
            }
            return;
        }

        void stopThread() {
            this.stop = true;
            this.interrupt();
        }
    }
}

