/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.locking.consistentkey;

import java.time.Instant;
import org.janusgraph.diskstorage.locking.LockStatus;

public class ConsistentKeyLockStatus
implements LockStatus {
    private final Instant write;
    private final Instant expire;
    private boolean checked;

    public ConsistentKeyLockStatus(Instant written, Instant expire) {
        this.write = written;
        this.expire = expire;
        this.checked = false;
    }

    @Override
    public Instant getExpirationTimestamp() {
        return this.expire;
    }

    public Instant getWriteTimestamp() {
        return this.write;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked() {
        this.checked = true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checked ? 1231 : 1237);
        result = 31 * result + (this.expire == null ? 0 : this.expire.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConsistentKeyLockStatus other = (ConsistentKeyLockStatus)obj;
        if (this.checked != other.checked) {
            return false;
        }
        if (this.expire == null) {
            return other.expire == null;
        }
        return this.expire.equals(other.expire);
    }
}

