/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import java.io.IOException;
import org.apache.tinkerpop.shaded.jackson.databind.JsonNode;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.OrderPreservingSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.JsonNodeParseException;
import org.janusgraph.graphdb.database.serialize.attribute.StringSerializer;

public class JsonSerializer<T extends JsonNode>
implements OrderPreservingSerializer<T> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final StringSerializer stringSerializer = new StringSerializer();
    private final Class<T> jsonType;

    public JsonSerializer(Class<T> jsonType) {
        this.jsonType = jsonType;
    }

    @Override
    public T readByteOrder(ScanBuffer buffer) {
        return this.parse(this.stringSerializer.readByteOrder(buffer));
    }

    @Override
    public void writeByteOrder(WriteBuffer buffer, T attribute) {
        this.stringSerializer.writeByteOrder(buffer, ((JsonNode)attribute).toString());
    }

    @Override
    public T read(ScanBuffer buffer) {
        return this.parse(this.stringSerializer.read(buffer));
    }

    @Override
    public void write(WriteBuffer buffer, T attribute) {
        this.stringSerializer.write(buffer, ((JsonNode)attribute).toString());
    }

    @Override
    public void verifyAttribute(T value) {
        this.stringSerializer.verifyAttribute(((JsonNode)value).toString());
    }

    @Override
    public T convert(Object value) {
        if (this.jsonType.isAssignableFrom(value.getClass())) {
            return (T)((JsonNode)this.jsonType.cast(value));
        }
        if (value instanceof String) {
            return this.parse(this.stringSerializer.convert(value));
        }
        return null;
    }

    private T parse(String json) {
        try {
            return (T)((JsonNode)this.jsonType.cast(OBJECT_MAPPER.readTree(json)));
        }
        catch (IOException e) {
            throw new JsonNodeParseException(e);
        }
    }
}

