/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.log;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.log.Change;
import org.janusgraph.core.log.ChangeProcessor;
import org.janusgraph.core.log.LogProcessorBuilder;
import org.janusgraph.core.log.LogProcessorFramework;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.ReadBuffer;
import org.janusgraph.diskstorage.log.Log;
import org.janusgraph.diskstorage.log.Message;
import org.janusgraph.diskstorage.log.MessageReader;
import org.janusgraph.diskstorage.log.ReadMarker;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.log.LogTxMeta;
import org.janusgraph.graphdb.database.log.TransactionLogHeader;
import org.janusgraph.graphdb.database.serialize.Serializer;
import org.janusgraph.graphdb.internal.ElementLifeCycle;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.log.ModificationDeserializer;
import org.janusgraph.graphdb.log.StandardChangeState;
import org.janusgraph.graphdb.log.StandardTransactionId;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.system.BaseKey;
import org.janusgraph.graphdb.vertices.StandardVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardLogProcessorFramework
implements LogProcessorFramework {
    private static final Logger logger = LoggerFactory.getLogger(StandardLogProcessorFramework.class);
    private final StandardJanusGraph graph;
    private final Serializer serializer;
    private final TimestampProvider times;
    private final Map<String, Log> processorLogs;
    private boolean isOpen = true;

    public StandardLogProcessorFramework(StandardJanusGraph graph) {
        Preconditions.checkArgument((graph != null && graph.isOpen() ? 1 : 0) != 0);
        this.graph = graph;
        this.serializer = graph.getDataSerializer();
        this.times = graph.getConfiguration().getTimestampProvider();
        this.processorLogs = new HashMap<String, Log>();
    }

    private void checkOpen() {
        Preconditions.checkState((boolean)this.isOpen, (Object)"Transaction log framework has already been closed");
    }

    @Override
    public synchronized boolean removeLogProcessor(String logIdentifier) {
        this.checkOpen();
        if (this.processorLogs.containsKey(logIdentifier)) {
            try {
                this.processorLogs.get(logIdentifier).close();
            }
            catch (BackendException e) {
                throw new JanusGraphException("Could not close transaction log: " + logIdentifier, e);
            }
            this.processorLogs.remove(logIdentifier);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void shutdown() throws JanusGraphException {
        if (!this.isOpen) {
            return;
        }
        this.isOpen = false;
        try {
            for (Log log : this.processorLogs.values()) {
                log.close();
            }
            this.processorLogs.clear();
        }
        catch (BackendException e) {
            throw new JanusGraphException(e);
        }
    }

    @Override
    public LogProcessorBuilder addLogProcessor(String logIdentifier) {
        return new Builder(logIdentifier);
    }

    private class MsgReaderConverter
    implements MessageReader {
        private final String userlogName;
        private final ChangeProcessor processor;
        private final int retryAttempts;

        private MsgReaderConverter(String userLogName, ChangeProcessor processor, int retryAttempts) {
            this.userlogName = userLogName;
            this.processor = processor;
            this.retryAttempts = retryAttempts;
        }

        private void readRelations(TransactionLogHeader.Entry transactionEntry, StandardJanusGraphTx tx, StandardChangeState changes) {
            for (TransactionLogHeader.Modification modification : transactionEntry.getContentAsModifications(StandardLogProcessorFramework.this.serializer)) {
                InternalRelation rel = ModificationDeserializer.parseRelation(modification, tx);
                Change state = modification.state;
                if (rel.getType().equals(BaseKey.VertexExists) && !(rel.getVertex(0) instanceof JanusGraphSchemaElement)) {
                    if (state == Change.REMOVED) {
                        ((StandardVertex)rel.getVertex(0)).updateLifeCycle(ElementLifeCycle.Event.REMOVED);
                    }
                    changes.addVertex(rel.getVertex(0), state);
                    continue;
                }
                if (rel.isInvisible()) continue;
                changes.addRelation(rel, state);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void read(Message message) {
            for (int i = 1; i <= this.retryAttempts; ++i) {
                StandardTransactionId transactionId;
                StandardJanusGraphTx tx = (StandardJanusGraphTx)StandardLogProcessorFramework.this.graph.newTransaction();
                StandardChangeState changes = new StandardChangeState();
                try {
                    ReadBuffer content = message.getContent().asReadBuffer();
                    String senderId = message.getSenderId();
                    TransactionLogHeader.Entry transactionEntry = TransactionLogHeader.parse(content, StandardLogProcessorFramework.this.serializer, StandardLogProcessorFramework.this.times);
                    transactionId = transactionEntry.getMetadata().containsKey((Object)LogTxMeta.SOURCE_TRANSACTION) ? (StandardTransactionId)transactionEntry.getMetadata().get((Object)LogTxMeta.SOURCE_TRANSACTION) : new StandardTransactionId(senderId, transactionEntry.getHeader().getId(), transactionEntry.getHeader().getTimestamp());
                    this.readRelations(transactionEntry, tx, changes);
                }
                catch (Throwable e) {
                    tx.rollback();
                    logger.error("Encountered exception [{}] when preparing processor [{}] for user log [{}] on attempt {} of {}", new Object[]{e.getMessage(), this.processor, this.userlogName, i, this.retryAttempts});
                    logger.error("Full exception: ", e);
                    continue;
                }
                assert (transactionId != null);
                try {
                    this.processor.process(tx, transactionId, changes);
                    return;
                }
                catch (Throwable e) {
                    tx.rollback();
                    tx = null;
                    logger.error("Encountered exception [{}] when running processor [{}] for user log [{}] on attempt {} of {}", new Object[]{e.getMessage(), this.processor, this.userlogName, i, this.retryAttempts});
                    logger.error("Full exception: ", e);
                    continue;
                }
                finally {
                    if (tx != null) {
                        tx.commit();
                    }
                }
            }
        }

        @Override
        public void updateState() {
        }
    }

    private class Builder
    implements LogProcessorBuilder {
        private final String userLogName;
        private final List<ChangeProcessor> processors;
        private String readMarkerName = null;
        private Instant startTime = null;
        private int retryAttempts = 1;

        private Builder(String userLogName) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank(userLogName));
            this.userLogName = userLogName;
            this.processors = new ArrayList<ChangeProcessor>();
        }

        @Override
        public String getLogIdentifier() {
            return this.userLogName;
        }

        @Override
        public LogProcessorBuilder setProcessorIdentifier(String name) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank(name));
            this.readMarkerName = name;
            return this;
        }

        @Override
        public LogProcessorBuilder setStartTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public LogProcessorBuilder setStartTimeNow() {
            this.startTime = null;
            return this;
        }

        @Override
        public LogProcessorBuilder addProcessor(ChangeProcessor processor) {
            Preconditions.checkArgument((processor != null ? 1 : 0) != 0);
            this.processors.add(processor);
            return this;
        }

        @Override
        public LogProcessorBuilder setRetryAttempts(int attempts) {
            Preconditions.checkArgument((attempts > 0 ? 1 : 0) != 0, (String)"Invalid number: %s", (Object[])new Object[]{attempts});
            this.retryAttempts = attempts;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void build() {
            Preconditions.checkArgument((!this.processors.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one processor");
            ReadMarker readMarker = this.startTime == null && this.readMarkerName == null ? ReadMarker.fromNow() : (this.readMarkerName == null ? ReadMarker.fromTime(this.startTime) : (this.startTime == null ? ReadMarker.fromIdentifierOrNow(this.readMarkerName) : ReadMarker.fromIdentifierOrTime(this.readMarkerName, this.startTime)));
            StandardLogProcessorFramework standardLogProcessorFramework = StandardLogProcessorFramework.this;
            synchronized (standardLogProcessorFramework) {
                Preconditions.checkArgument((!StandardLogProcessorFramework.this.processorLogs.containsKey(this.userLogName) ? 1 : 0) != 0, (String)"Processors have already been registered for user log: %s", (Object[])new Object[]{this.userLogName});
                try {
                    Log log = StandardLogProcessorFramework.this.graph.getBackend().getUserLog(this.userLogName);
                    log.registerReaders(readMarker, Iterables.transform(this.processors, (Function)new Function<ChangeProcessor, MessageReader>(){

                        @Nullable
                        public MessageReader apply(@Nullable ChangeProcessor changeProcessor) {
                            return new MsgReaderConverter(Builder.this.userLogName, changeProcessor, Builder.this.retryAttempts);
                        }
                    }));
                    StandardLogProcessorFramework.this.processorLogs.put(this.userLogName, log);
                }
                catch (BackendException e) {
                    throw new JanusGraphException("Could not open user transaction log for name: " + this.userLogName, e);
                }
            }
        }
    }
}

