/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query;

import com.codahale.metrics.Timer;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.graphdb.query.BackendQuery;
import org.janusgraph.graphdb.query.ElementQuery;
import org.janusgraph.graphdb.query.QueryExecutor;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.util.stats.MetricManager;

public class MetricsQueryExecutor<Q extends ElementQuery, R extends JanusGraphElement, B extends BackendQuery>
implements QueryExecutor<Q, R, B> {
    private final QueryExecutor<Q, R, B> qe;
    private final String metricsPrefix;
    private static final String M_CALLS = "calls";
    private static final String M_TIME = "time";
    private static final String M_EXCEPTIONS = "exceptions";

    public MetricsQueryExecutor(String prefix, String name, QueryExecutor<Q, R, B> qe) {
        this.qe = qe;
        this.metricsPrefix = prefix + ".query." + name;
    }

    @Override
    public Iterator<R> getNew(Q query) {
        return (Iterator)this.runWithMetrics("getNew", v -> this.qe.getNew((ElementQuery)query));
    }

    @Override
    public boolean hasDeletions(Q query) {
        return (Boolean)this.runWithMetrics("hasDeletions", v -> this.qe.hasDeletions((ElementQuery)query));
    }

    @Override
    public boolean isDeleted(Q query, R result) {
        return (Boolean)this.runWithMetrics("isDeleted", v -> this.qe.isDeleted((ElementQuery)query, (JanusGraphElement)result));
    }

    @Override
    public Iterator<R> execute(Q query, B subquery, Object executionInfo, QueryProfiler profiler) {
        return (Iterator)this.runWithMetrics("execute", v -> this.qe.execute((ElementQuery)query, (BackendQuery)subquery, executionInfo, profiler));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T runWithMetrics(String opName, Function<Void, T> impl) {
        Preconditions.checkNotNull((Object)opName);
        Preconditions.checkNotNull(impl);
        MetricManager mgr = MetricManager.INSTANCE;
        mgr.getCounter(this.metricsPrefix, opName, M_CALLS).inc();
        try (Timer.Context tc = mgr.getTimer(this.metricsPrefix, opName, M_TIME).time();){
            Object object = impl.apply(null);
            return (T)object;
        }
        catch (RuntimeException e) {
            mgr.getCounter(this.metricsPrefix, opName, M_EXCEPTIONS).inc();
            throw e;
        }
    }
}

