/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.relations;

import com.google.common.base.Preconditions;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.relations.AbstractTypedRelation;
import org.janusgraph.graphdb.relations.EdgeDirection;

public abstract class AbstractEdge
extends AbstractTypedRelation
implements JanusGraphEdge {
    private InternalVertex start;
    private InternalVertex end;

    public AbstractEdge(long id, EdgeLabel label, InternalVertex start, InternalVertex end) {
        super(id, label);
        assert (start != null && end != null);
        this.start = start;
        this.end = end;
    }

    public String toString() {
        return StringFactory.edgeString(this);
    }

    @Override
    public String label() {
        return this.type.name();
    }

    public void setVertexAt(int pos, InternalVertex vertex) {
        Preconditions.checkArgument((vertex != null && this.getVertex(pos).equals(vertex) ? 1 : 0) != 0);
        switch (pos) {
            case 0: {
                this.start = vertex;
                break;
            }
            case 1: {
                this.end = vertex;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid position: " + pos);
            }
        }
    }

    @Override
    public InternalVertex getVertex(int pos) {
        switch (pos) {
            case 0: {
                return this.start;
            }
            case 1: {
                return this.end;
            }
        }
        throw new IllegalArgumentException("Invalid position: " + pos);
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public int getLen() {
        assert (!this.type.isUnidirected(Direction.IN));
        return this.type.isUnidirected(Direction.OUT) ? 1 : 2;
    }

    @Override
    public JanusGraphVertex vertex(Direction dir) {
        return this.getVertex(EdgeDirection.position(dir));
    }

    @Override
    public JanusGraphVertex otherVertex(Vertex vertex) {
        if (this.start.equals(vertex)) {
            return this.end;
        }
        if (this.end.equals(vertex)) {
            return this.start;
        }
        throw new IllegalArgumentException("Edge is not incident on vertex");
    }

    @Override
    public boolean isProperty() {
        return false;
    }

    @Override
    public boolean isEdge() {
        return true;
    }
}

