/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.util.AbstractThreadedTransaction;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.diskstorage.util.Hex;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.olap.computer.FulgoraGraphComputer;
import org.janusgraph.graphdb.relations.RelationIdentifier;
import org.janusgraph.graphdb.tinkerpop.ElementUtils;
import org.janusgraph.graphdb.tinkerpop.JanusGraphBlueprintsGraph;
import org.janusgraph.graphdb.types.system.BaseVertexLabel;

public abstract class JanusGraphBlueprintsTransaction
implements JanusGraphTransaction {
    protected abstract JanusGraphBlueprintsGraph getGraph();

    @Override
    public Graph.Features features() {
        return this.getGraph().features();
    }

    @Override
    public Graph.Variables variables() {
        return this.getGraph().variables();
    }

    @Override
    public Configuration configuration() {
        return this.getGraph().configuration();
    }

    @Override
    public <I extends Io> I io(Io.Builder<I> builder) {
        return this.getGraph().io(builder);
    }

    @Override
    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) throws IllegalArgumentException {
        JanusGraphBlueprintsGraph graph = this.getGraph();
        if (this.isOpen()) {
            this.commit();
        }
        return graph.compute(graphComputerClass);
    }

    @Override
    public FulgoraGraphComputer compute() throws IllegalArgumentException {
        JanusGraphBlueprintsGraph graph = this.getGraph();
        if (this.isOpen()) {
            this.commit();
        }
        return graph.compute();
    }

    @Override
    public JanusGraphVertex addVertex(Object ... keyValues) {
        ElementHelper.legalPropertyKeyValueArray(keyValues);
        if (ElementHelper.getIdValue(keyValues).isPresent() && !((StandardJanusGraph)this.getGraph()).getConfiguration().allowVertexIdSetting()) {
            throw Vertex.Exceptions.userSuppliedIdsNotSupported();
        }
        Object labelValue = null;
        for (int i = 0; i < keyValues.length; i += 2) {
            if (!keyValues[i].equals(T.label)) continue;
            labelValue = keyValues[i + 1];
            Preconditions.checkArgument((labelValue instanceof VertexLabel || labelValue instanceof String ? 1 : 0) != 0, (String)"Expected a string or VertexLabel as the vertex label argument, but got: %s", (Object[])new Object[]{labelValue});
            if (!(labelValue instanceof String)) continue;
            ElementHelper.validateLabel((String)labelValue);
        }
        VertexLabel label = BaseVertexLabel.DEFAULT_VERTEXLABEL;
        if (labelValue != null) {
            label = labelValue instanceof VertexLabel ? (VertexLabel)labelValue : this.getOrCreateVertexLabel((String)labelValue);
        }
        Long id = ElementHelper.getIdValue(keyValues).map(Number.class::cast).map(Number::longValue).orElse(null);
        JanusGraphVertex vertex = this.addVertex(id, label);
        org.janusgraph.graphdb.util.ElementHelper.attachProperties(vertex, keyValues);
        return vertex;
    }

    @Override
    public Iterator<Vertex> vertices(Object ... vertexIds) {
        if (vertexIds == null || vertexIds.length == 0) {
            return this.getVertices(new long[0]).iterator();
        }
        ElementUtils.verifyArgsMustBeEitherIdOrElement(vertexIds);
        long[] ids2 = new long[vertexIds.length];
        int pos = 0;
        for (Object vertexId : vertexIds) {
            long id = ElementUtils.getVertexId(vertexId);
            if (id <= 0L) continue;
            ids2[pos++] = id;
        }
        if (pos == 0) {
            return Collections.emptyIterator();
        }
        if (pos < ids2.length) {
            ids2 = Arrays.copyOf(ids2, pos);
        }
        return this.getVertices(ids2).iterator();
    }

    @Override
    public Iterator<Edge> edges(Object ... edgeIds) {
        if (edgeIds == null || edgeIds.length == 0) {
            return this.getEdges(new RelationIdentifier[0]).iterator();
        }
        ElementUtils.verifyArgsMustBeEitherIdOrElement(edgeIds);
        RelationIdentifier[] ids2 = new RelationIdentifier[edgeIds.length];
        int pos = 0;
        for (Object edgeId : edgeIds) {
            RelationIdentifier id = ElementUtils.getEdgeId(edgeId);
            if (id == null) continue;
            ids2[pos++] = id;
        }
        if (pos == 0) {
            return Collections.emptyIterator();
        }
        if (pos < ids2.length) {
            ids2 = Arrays.copyOf(ids2, pos);
        }
        return this.getEdges(ids2).iterator();
    }

    public String toString() {
        int ihc = System.identityHashCode(this);
        String ihcString = String.format("0x%s", Hex.bytesToHex((byte)(ihc >>> 24 & 0xFF), (byte)(ihc >>> 16 & 0xFF), (byte)(ihc >>> 8 & 0xFF), (byte)(ihc & 0xFF)));
        return StringFactory.graphString(this, ihcString);
    }

    @Override
    public Transaction tx() {
        return new AbstractThreadedTransaction(this.getGraph()){

            @Override
            public void doOpen() {
                if (JanusGraphBlueprintsTransaction.this.isClosed()) {
                    throw new IllegalStateException("Cannot re-open a closed transaction.");
                }
            }

            @Override
            public void doCommit() {
                JanusGraphBlueprintsTransaction.this.commit();
            }

            @Override
            public void doRollback() {
                JanusGraphBlueprintsTransaction.this.rollback();
            }

            @Override
            public <G extends Graph> G createThreadedTx() {
                throw new UnsupportedOperationException("JanusGraph does not support nested transactions.");
            }

            @Override
            public boolean isOpen() {
                return JanusGraphBlueprintsTransaction.this.isOpen();
            }

            @Override
            protected void doClose() {
                if (this.isOpen()) {
                    throw Transaction.Exceptions.openTransactionsOnClose();
                }
                super.doClose();
            }
        };
    }

    @Override
    public void close() {
        this.tx().close();
    }
}

