/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphMultiVertexQuery;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;

public class JanusGraphEdgeVertexStep
extends EdgeVertexStep
implements Profiling {
    private boolean initialized = false;
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;
    private final int txVertexCacheSize;

    public JanusGraphEdgeVertexStep(EdgeVertexStep originalStep, int txVertexCacheSize) {
        super(originalStep.getTraversal(), originalStep.getDirection());
        originalStep.getLabels().forEach(this::addLabel);
        this.txVertexCacheSize = txVertexCacheSize;
    }

    private void initialize() {
        assert (!this.initialized);
        this.initialized = true;
        if (!this.starts.hasNext()) {
            throw FastNoSuchElementException.instance();
        }
        ArrayList edges = new ArrayList();
        HashSet vertices = Sets.newHashSet();
        this.starts.forEachRemaining(e -> {
            edges.add(e);
            if (vertices.size() < this.txVertexCacheSize) {
                if (Direction.IN.equals((Object)this.direction) || Direction.BOTH.equals((Object)this.direction)) {
                    vertices.add(((Edge)e.get()).inVertex());
                }
                if (Direction.OUT.equals((Object)this.direction) || Direction.BOTH.equals((Object)this.direction)) {
                    vertices.add(((Edge)e.get()).outVertex());
                }
            }
        });
        if (vertices.size() > 1) {
            JanusGraphMultiVertexQuery<? extends JanusGraphMultiVertexQuery> multiQuery = JanusGraphTraversalUtil.getTx(this.traversal).multiQuery(new JanusGraphVertex[0]);
            ((BasicVertexCentricQueryBuilder)((Object)multiQuery)).profiler(this.queryProfiler);
            multiQuery.addAllVertices(vertices).preFetch();
        }
        this.starts.add(edges.iterator());
    }

    @Override
    protected Traverser.Admin<Vertex> processNextStart() {
        if (!this.initialized) {
            this.initialize();
        }
        return super.processNextStart();
    }

    @Override
    public void reset() {
        super.reset();
        this.initialized = false;
    }

    @Override
    public JanusGraphEdgeVertexStep clone() {
        JanusGraphEdgeVertexStep clone = (JanusGraphEdgeVertexStep)super.clone();
        clone.initialized = false;
        return clone;
    }

    @Override
    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
    }
}

