/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction.addedrelations;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.ObjectSet;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.transaction.addedrelations.AddedRelationsContainer;

public class SimpleAddedRelations
implements AddedRelationsContainer {
    private static final int INITIAL_ADDED_SIZE = 10;
    private final ObjectSet<InternalRelation> container = new ObjectHashSet<InternalRelation>(10);

    @Override
    public boolean add(InternalRelation relation) {
        this.container.add(relation);
        return true;
    }

    @Override
    public boolean remove(InternalRelation relation) {
        this.container.removeAll(relation);
        return true;
    }

    @Override
    public Iterable<InternalRelation> getView(Predicate<InternalRelation> filter) {
        return Iterables.filter(this::iterator, filter);
    }

    @Override
    public boolean isEmpty() {
        return this.container.isEmpty();
    }

    @Override
    public Collection<InternalRelation> getAll() {
        return Collections.unmodifiableCollection(new AbstractCollection<InternalRelation>(){

            @Override
            @Nonnull
            public Iterator<InternalRelation> iterator() {
                return SimpleAddedRelations.this.iterator();
            }

            @Override
            public int size() {
                return SimpleAddedRelations.this.container.size();
            }
        });
    }

    private Iterator<InternalRelation> iterator() {
        return Iterators.transform(this.container.iterator(), e -> {
            assert (e != null);
            return (InternalRelation)e.value;
        });
    }
}

