/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import java.util.Iterator;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.graphdb.util.AllEdgesIterator;

public class AllEdgesIterable {
    private AllEdgesIterable() {
    }

    public static Iterable<Edge> of(Iterable<? extends Vertex> vertices) {
        return new IterableBased(vertices);
    }

    public static Iterable<Edge> of(Set<? extends Vertex> vertices) {
        return new SetBased(vertices);
    }

    private static class SetBased
    implements Iterable<Edge> {
        private final Set<? extends Vertex> vertices;

        public SetBased(Set<? extends Vertex> vertices) {
            this.vertices = vertices;
        }

        @Override
        public Iterator<Edge> iterator() {
            return new AllEdgesIterator(this.vertices);
        }
    }

    private static class IterableBased
    implements Iterable<Edge> {
        private final Iterable<? extends Vertex> vertices;

        public IterableBased(Iterable<? extends Vertex> vertices) {
            this.vertices = vertices;
        }

        @Override
        public Iterator<Edge> iterator() {
            return new AllEdgesIterator(this.vertices.iterator());
        }
    }
}

