/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.system;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.janusgraph.core.util.ReflectiveConfigOptionLoader;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;

public class ConfigurationPrinter {
    private static final String DELIM = "|";
    private static final String DELIM_PADDING = " ";
    private static final boolean DELIM_AT_LINE_START = true;
    private static final boolean DELIM_AT_LINE_END = true;
    private final PrintStream stream;

    public static void main(String[] args) throws IOException, ReflectiveOperationException {
        ReflectiveConfigOptionLoader.INSTANCE.loadStandard(ConfigurationPrinter.class);
        if (2 != args.length) {
            System.err.println("Usage: " + ConfigurationPrinter.class.getName() + " <package.class.fieldname of a ConfigNamespace root> <output filename>");
            System.exit(-1);
        }
        ConfigNamespace root = ConfigurationPrinter.stringToNamespace(args[0]);
        PrintStream stream = new PrintStream((OutputStream)new FileOutputStream(args[1]), false, "UTF-8");
        new ConfigurationPrinter(stream).write(root);
        stream.flush();
        stream.close();
    }

    private ConfigurationPrinter(PrintStream stream) {
        this.stream = stream;
    }

    private void write(ConfigNamespace root) {
        this.printAutoGenerationHeader();
        this.printNamespace(root, "");
    }

    private void printAutoGenerationHeader() {
        this.stream.println("<!--");
        this.stream.println("NOTE: THIS FILE IS GENERATED VIA \"mvn --quiet clean install -DskipTests=true -pl janusgraph-doc -am\"");
        this.stream.println("DO NOT EDIT IT DIRECTLY; CHANGES WILL BE OVERWRITTEN.");
        this.stream.println("-->");
    }

    private static ConfigNamespace stringToNamespace(String raw) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        int i = raw.lastIndexOf(".");
        String fullClassName = raw.substring(0, i);
        String fieldName = raw.substring(i + 1);
        return (ConfigNamespace)Class.forName(fullClassName).getField(fieldName).get(null);
    }

    private String getFullPath(ConfigOption<?> opt) {
        StringBuilder sb = new StringBuilder(64);
        sb.insert(0, opt.getName());
        for (ConfigNamespace parent = opt.getNamespace(); null != parent && !parent.isRoot(); parent = parent.getNamespace()) {
            if (parent.isUmbrella()) {
                sb.insert(0, "[X].");
            }
            sb.insert(0, ".");
            sb.insert(0, parent.getName());
        }
        return sb.toString();
    }

    private void printNamespace(ConfigNamespace n, String prefix) {
        String newPrefix = prefix + n.getName() + ".";
        if (n.isUmbrella()) {
            newPrefix = newPrefix + "[X].";
        }
        if (n.isRoot()) {
            newPrefix = "";
        }
        if (!Iterables.isEmpty(this.getSortedChildOptions(n))) {
            this.stream.println(this.getNamespaceSectionHeader(n, prefix));
            this.stream.println(this.getTableHeader());
            for (ConfigOption configOption : this.getSortedChildOptions(n)) {
                this.stream.println(this.getTableLineForOption(configOption, newPrefix));
            }
        }
        for (ConfigNamespace configNamespace : this.getSortedChildNamespaces(n)) {
            this.printNamespace(configNamespace, newPrefix);
        }
    }

    private String getNamespaceSectionHeader(ConfigNamespace n, String prefix) {
        String fullName = prefix + n.getName();
        if (n.isUmbrella()) {
            fullName = fullName + " *";
        }
        return "\n### " + fullName + "\n" + n.getDescription() + "\n";
    }

    private List<ConfigOption<?>> getSortedChildOptions(ConfigNamespace n) {
        return this.getSortedChildren(n, (Function<ConfigElement, Boolean>)((Function)arg0 -> arg0.isOption() && !((ConfigOption)arg0).isHidden()));
    }

    private List<ConfigNamespace> getSortedChildNamespaces(ConfigNamespace n) {
        return this.getSortedChildren(n, (Function<ConfigElement, Boolean>)((Function)ConfigElement::isNamespace));
    }

    private String getTableLineForOption(ConfigOption o, String prefix) {
        ArrayList<String> colData = new ArrayList<String>(10);
        String name = prefix + o.getName();
        if (o.isDeprecated()) {
            ConfigOption<?> successor = o.getDeprecationReplacement();
            name = null == successor ? "*Deprecated* [line-through]#" + name + "#" : "*Deprecated.  See " + this.getFullPath(successor) + "* [line-through]#" + name + "#";
        }
        colData.add(name);
        colData.add(this.removeDelim(o.getDescription()));
        colData.add(o.getDatatype().getSimpleName());
        colData.add(this.removeDelim(this.getStringForDefaultValue(o)));
        colData.add(o.getType().toString());
        String line = Joiner.on((String)" | ").join(colData);
        line = "| " + line;
        line = line + DELIM_PADDING + DELIM;
        return line;
    }

    private String getTableHeader() {
        String colNames = "| Name | Description | Datatype | Default Value | Mutability |";
        return "\n" + colNames + "\n| ---- | ---- | ---- | ---- | ---- |";
    }

    private <E> List<E> getSortedChildren(ConfigNamespace n, Function<ConfigElement, Boolean> predicate) {
        ArrayList<ConfigElement> sortedElements = new ArrayList<ConfigElement>();
        for (ConfigElement e : n.getChildren()) {
            if (!((Boolean)predicate.apply((Object)e)).booleanValue()) continue;
            sortedElements.add(e);
        }
        sortedElements.sort(Comparator.comparing(ConfigElement::getName));
        return sortedElements;
    }

    private String removeDelim(String s) {
        return s.replace(DELIM, "");
    }

    private String getStringForDefaultValue(ConfigOption<?> c) {
        Object o = c.getDefaultValue();
        if (null == o) {
            return "(no default value)";
        }
        if (o instanceof Duration) {
            Duration d = (Duration)o;
            return d.toMillis() + " ms";
        }
        if (o instanceof String[]) {
            return Joiner.on((String)",").join((Object[])((String[])o));
        }
        return o.toString();
    }
}

