/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.system;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.Configuration;

public class ConfigurationUtil {
    private static final char CONFIGURATION_SEPARATOR = '.';

    public static List<String> getUniquePrefixes(Configuration config) {
        HashSet<String> nameSet = new HashSet<String>();
        ArrayList<String> names = new ArrayList<String>();
        Iterator<String> keyIterator = config.getKeys();
        while (keyIterator.hasNext()) {
            String name;
            String key = keyIterator.next();
            int pos = key.indexOf(46);
            if (pos <= 0 || !nameSet.add(name = key.substring(0, pos))) continue;
            names.add(name);
        }
        return names;
    }

    public static <T> T instantiate(String className) {
        return ConfigurationUtil.instantiate(className, new Object[0], new Class[0]);
    }

    public static <T> T instantiate(String className, Object[] constructorArgs, Class[] classes) {
        Preconditions.checkArgument((constructorArgs != null && classes != null ? 1 : 0) != 0);
        Preconditions.checkArgument((constructorArgs.length == classes.length ? 1 : 0) != 0);
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(classes);
            return (T)constructor.newInstance(constructorArgs);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find implementation class: " + className, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Implementation class does not have required constructor: " + className, e);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not instantiate implementation: " + className, e);
        }
    }
}

