/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.log;

import com.orientechnologies.common.log.OAnsiCode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.IllegalFormatException;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class OLogFormatter
extends Formatter {
    protected static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss:SSS");
    protected static final String EOL = System.getProperty("line.separator");

    @Override
    public String format(LogRecord record) {
        if (record.getThrown() == null) {
            return this.customFormatMessage(record);
        }
        StringBuilder buffer = new StringBuilder(512);
        buffer.append(record.getMessage());
        Throwable current = record.getThrown();
        if (current != null) {
            buffer.append(EOL);
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            current.printStackTrace(printWriter);
            printWriter.flush();
            buffer.append(writer.getBuffer());
            printWriter.close();
        }
        return buffer.toString();
    }

    protected String customFormatMessage(LogRecord iRecord) {
        Level level = iRecord.getLevel();
        String message = OAnsiCode.format(iRecord.getMessage(), false);
        Object[] additionalArgs = iRecord.getParameters();
        String requester = this.getSourceClassSimpleName(iRecord.getLoggerName());
        StringBuilder buffer = new StringBuilder(512);
        buffer.append(EOL);
        buffer.append(dateFormatter.format(LocalDateTime.now()));
        buffer.append(String.format(" %-5.5s ", level.getName()));
        try {
            if (additionalArgs != null) {
                buffer.append(String.format(message, additionalArgs));
            } else {
                buffer.append(message);
            }
        }
        catch (IllegalFormatException ignore) {
            buffer.append(message);
        }
        if (requester != null) {
            buffer.append(" [");
            buffer.append(requester);
            buffer.append(']');
        }
        return OAnsiCode.format(buffer.toString(), false);
    }

    protected String getSourceClassSimpleName(String iSourceClassName) {
        if (iSourceClassName == null) {
            return null;
        }
        return iSourceClassName.substring(iSourceClassName.lastIndexOf(".") + 1);
    }
}

