/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class OCharSerializer
implements OBinarySerializer<Character> {
    public static final int CHAR_SIZE = 2;
    public static final byte ID = 3;
    private static final OBinaryConverter BINARY_CONVERTER = OBinaryConverterFactory.getConverter();
    public static final OCharSerializer INSTANCE = new OCharSerializer();

    @Override
    public int getObjectSize(Character object, Object ... hints) {
        return 2;
    }

    @Override
    public void serialize(Character object, byte[] stream, int startPosition, Object ... hints) {
        this.serializeLiteral(object.charValue(), stream, startPosition);
    }

    public void serializeLiteral(char value, byte[] stream, int startPosition) {
        stream[startPosition] = (byte)(value >>> 8);
        stream[startPosition + 1] = (byte)value;
    }

    @Override
    public Character deserialize(byte[] stream, int startPosition) {
        return Character.valueOf(this.deserializeLiteral(stream, startPosition));
    }

    public char deserializeLiteral(byte[] stream, int startPosition) {
        return (char)(((stream[startPosition] & 0xFF) << 8) + (stream[startPosition + 1] & 0xFF));
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 2;
    }

    @Override
    public byte getId() {
        return 3;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 2;
    }

    @Override
    public void serializeNativeObject(Character object, byte[] stream, int startPosition, Object ... hints) {
        OCharSerializer.checkBoundaries(stream, startPosition);
        BINARY_CONVERTER.putChar(stream, startPosition, object.charValue(), ByteOrder.nativeOrder());
    }

    @Override
    public Character deserializeNativeObject(byte[] stream, int startPosition) {
        OCharSerializer.checkBoundaries(stream, startPosition);
        return Character.valueOf(BINARY_CONVERTER.getChar(stream, startPosition, ByteOrder.nativeOrder()));
    }

    public void serializeNative(char object, byte[] stream, int startPosition, Object ... hints) {
        OCharSerializer.checkBoundaries(stream, startPosition);
        BINARY_CONVERTER.putChar(stream, startPosition, object, ByteOrder.nativeOrder());
    }

    public char deserializeNative(byte[] stream, int startPosition) {
        OCharSerializer.checkBoundaries(stream, startPosition);
        return BINARY_CONVERTER.getChar(stream, startPosition, ByteOrder.nativeOrder());
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 2;
    }

    @Override
    public Character preprocess(Character value, Object ... hints) {
        return value;
    }

    @Override
    public void serializeInByteBufferObject(Character object, ByteBuffer buffer, Object ... hints) {
        buffer.putChar(object.charValue());
    }

    @Override
    public Character deserializeFromByteBufferObject(ByteBuffer buffer) {
        return Character.valueOf(buffer.getChar());
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return 2;
    }

    @Override
    public Character deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return Character.valueOf((char)walChanges.getShortValue(buffer, offset));
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return 2;
    }

    private static void checkBoundaries(byte[] stream, int startPosition) {
        if (startPosition + 2 > stream.length) {
            throw new IllegalStateException("Requested stream size is " + (startPosition + 2) + " but provided stream has size " + stream.length);
        }
    }
}

