/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ODoubleSerializer
implements OBinarySerializer<Double> {
    public static final byte ID = 6;
    public static final int DOUBLE_SIZE = 8;
    private static final OBinaryConverter CONVERTER = OBinaryConverterFactory.getConverter();
    public static final ODoubleSerializer INSTANCE = new ODoubleSerializer();

    @Override
    public int getObjectSize(Double object, Object ... hints) {
        return 8;
    }

    @Override
    public void serialize(Double object, byte[] stream, int startPosition, Object ... hints) {
        OLongSerializer.INSTANCE.serializeLiteral(Double.doubleToLongBits(object), stream, startPosition);
    }

    @Override
    public Double deserialize(byte[] stream, int startPosition) {
        return Double.longBitsToDouble(OLongSerializer.INSTANCE.deserializeLiteral(stream, startPosition));
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 8;
    }

    @Override
    public byte getId() {
        return 6;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 8;
    }

    public void serializeNative(double object, byte[] stream, int startPosition, Object ... hints) {
        ODoubleSerializer.checkBoundaries(stream, startPosition);
        CONVERTER.putLong(stream, startPosition, Double.doubleToLongBits(object), ByteOrder.nativeOrder());
    }

    public double deserializeNative(byte[] stream, int startPosition) {
        ODoubleSerializer.checkBoundaries(stream, startPosition);
        return Double.longBitsToDouble(CONVERTER.getLong(stream, startPosition, ByteOrder.nativeOrder()));
    }

    @Override
    public void serializeNativeObject(Double object, byte[] stream, int startPosition, Object ... hints) {
        ODoubleSerializer.checkBoundaries(stream, startPosition);
        CONVERTER.putLong(stream, startPosition, Double.doubleToLongBits(object), ByteOrder.nativeOrder());
    }

    @Override
    public Double deserializeNativeObject(byte[] stream, int startPosition) {
        ODoubleSerializer.checkBoundaries(stream, startPosition);
        return Double.longBitsToDouble(CONVERTER.getLong(stream, startPosition, ByteOrder.nativeOrder()));
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 8;
    }

    @Override
    public Double preprocess(Double value, Object ... hints) {
        return value;
    }

    @Override
    public void serializeInByteBufferObject(Double object, ByteBuffer buffer, Object ... hints) {
        buffer.putLong(Double.doubleToLongBits(object));
    }

    @Override
    public Double deserializeFromByteBufferObject(ByteBuffer buffer) {
        return Double.longBitsToDouble(buffer.getLong());
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return 8;
    }

    @Override
    public Double deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return Double.longBitsToDouble(walChanges.getLongValue(buffer, offset));
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return 8;
    }

    private static void checkBoundaries(byte[] stream, int startPosition) {
        if (startPosition + 8 > stream.length) {
            throw new IllegalStateException("Requested stream size is " + (startPosition + 8) + " but provided stream has size " + stream.length);
        }
    }
}

