/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.orient.client.remote.message.push.OStorageConfigurationPayload;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class OStorageConfigurationRemote
implements OStorageConfiguration {
    private OContextConfiguration contextConfiguration;
    private String dateFormat;
    private String dateTimeFormat;
    private String name;
    private int version;
    private String directory;
    private Map<String, OStorageEntryConfiguration> properties;
    private String schemaRecordId;
    private String indexMgrRecordId;
    private String clusterSelection;
    private String conflictStrategy;
    private boolean validationEnabled;
    private String localeLanguage;
    private int minimumClusters;
    private boolean strictSql;
    private String charset;
    private TimeZone timeZone;
    private String localeCountry;
    private String recordSerializer;
    private int recordSerializerVersion;
    private int binaryFormatVersion;
    private List<OStorageClusterConfiguration> clusters;
    private String networkRecordSerializer;

    public OStorageConfigurationRemote(String networkRecordSerializer, OStorageConfigurationPayload payload, OContextConfiguration contextConfiguration) {
        this.networkRecordSerializer = networkRecordSerializer;
        this.contextConfiguration = contextConfiguration;
        this.dateFormat = payload.getDateFormat();
        this.dateTimeFormat = payload.getDateTimeFormat();
        this.name = payload.getName();
        this.version = payload.getVersion();
        this.directory = payload.getDirectory();
        this.properties = new HashMap<String, OStorageEntryConfiguration>();
        for (OStorageEntryConfiguration conf : payload.getProperties()) {
            this.properties.put(conf.name, conf);
        }
        this.schemaRecordId = payload.getSchemaRecordId().toString();
        this.indexMgrRecordId = payload.getIndexMgrRecordId().toString();
        this.clusterSelection = payload.getClusterSelection();
        this.conflictStrategy = payload.getConflictStrategy();
        this.validationEnabled = payload.isValidationEnabled();
        this.localeLanguage = payload.getLocaleLanguage();
        this.minimumClusters = payload.getMinimumClusters();
        this.strictSql = payload.isStrictSql();
        this.charset = payload.getCharset();
        this.timeZone = payload.getTimeZone();
        this.localeCountry = payload.getLocaleCountry();
        this.recordSerializer = payload.getRecordSerializer();
        this.recordSerializerVersion = payload.getRecordSerializerVersion();
        this.binaryFormatVersion = payload.getBinaryFormatVersion();
        this.clusters = payload.getClusters();
    }

    @Override
    public SimpleDateFormat getDateTimeFormatInstance() {
        return new SimpleDateFormat(this.dateTimeFormat);
    }

    @Override
    public SimpleDateFormat getDateFormatInstance() {
        return new SimpleDateFormat(this.dateFormat);
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public Locale getLocaleInstance() {
        return Locale.forLanguageTag(this.localeCountry);
    }

    @Override
    public String getSchemaRecordId() {
        return this.schemaRecordId;
    }

    @Override
    public int getMinimumClusters() {
        return this.minimumClusters;
    }

    @Override
    public boolean isStrictSql() {
        return this.strictSql;
    }

    public OStorageConfiguration load(OContextConfiguration contextConfiguration) {
        this.contextConfiguration = contextConfiguration;
        return null;
    }

    @Override
    public String getIndexMgrRecordId() {
        return this.indexMgrRecordId;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    @Override
    public OContextConfiguration getContextConfiguration() {
        return this.contextConfiguration;
    }

    @Override
    public String getLocaleCountry() {
        return this.localeCountry;
    }

    @Override
    public String getLocaleLanguage() {
        return this.localeLanguage;
    }

    @Override
    public List<OStorageEntryConfiguration> getProperties() {
        return new ArrayList<OStorageEntryConfiguration>(this.properties.values());
    }

    @Override
    public String getClusterSelection() {
        return this.clusterSelection;
    }

    @Override
    public String getConflictStrategy() {
        return this.conflictStrategy;
    }

    @Override
    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    @Override
    public OStorageConfiguration.IndexEngineData getIndexEngine(String name, int defaultIndexId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRecordSerializer() {
        return this.networkRecordSerializer;
    }

    @Override
    public int getRecordSerializerVersion() {
        return this.recordSerializerVersion;
    }

    @Override
    public int getBinaryFormatVersion() {
        return this.binaryFormatVersion;
    }

    public void dropCluster(int iClusterId) {
        if (this.clusters.size() > iClusterId) {
            this.clusters.set(iClusterId, null);
        }
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProperty(String graphConsistencyMode) {
        return this.properties.get((Object)graphConsistencyMode).value;
    }

    @Override
    public String getDirectory() {
        return this.directory;
    }

    @Override
    public List<OStorageClusterConfiguration> getClusters() {
        return this.clusters;
    }

    @Override
    public String getCreatedAtVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> indexEngines() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPageSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFreeListBoundary() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxKeySize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getUuid() {
        throw new UnsupportedOperationException("Current version of the binary protocol do not support uuid");
    }

    @Override
    public void setUuid(OAtomicOperation atomicOperation, String uuid) {
        throw new UnsupportedOperationException("Current version of the binary protocol do not support uuid");
    }
}

