/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.client.remote.message.OQueryResponse;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.Map;

public final class OQueryRequest
implements OBinaryRequest<OQueryResponse> {
    public static byte COMMAND = 0;
    public static byte QUERY = 1;
    public static byte EXECUTE = (byte)2;
    private int recordsPerPage = 100;
    private ORecordSerializer serializer;
    private String language;
    private String statement;
    private byte operationType;
    private Map<String, Object> params;
    private byte[] paramsBytes;
    private boolean namedParams;

    public OQueryRequest(String language, String iCommand, Object[] positionalParams, byte operationType, ORecordSerializer serializer, int recordsPerPage) {
        this.language = language;
        this.statement = iCommand;
        this.params = OStorageRemote.paramsArrayToParamsMap(positionalParams);
        this.namedParams = false;
        this.serializer = serializer;
        this.recordsPerPage = recordsPerPage;
        if (this.recordsPerPage <= 0) {
            this.recordsPerPage = 100;
        }
        this.operationType = operationType;
        ODocument parms = new ODocument();
        parms.field("params", this.params);
        this.paramsBytes = OMessageHelper.getRecordBytes(parms, serializer);
    }

    public OQueryRequest(String language, String iCommand, Map<String, Object> namedParams, byte operationType, ORecordSerializer serializer, int recordsPerPage) {
        this.language = language;
        this.statement = iCommand;
        this.params = namedParams;
        ODocument parms = new ODocument();
        parms.field("params", this.params);
        this.paramsBytes = OMessageHelper.getRecordBytes(parms, serializer);
        this.namedParams = true;
        this.serializer = serializer;
        this.recordsPerPage = recordsPerPage;
        if (this.recordsPerPage <= 0) {
            this.recordsPerPage = 100;
        }
        this.operationType = operationType;
    }

    public OQueryRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeString(this.language);
        network.writeString(this.statement);
        network.writeByte(this.operationType);
        network.writeInt(this.recordsPerPage);
        network.writeString(null);
        network.writeBytes(this.paramsBytes);
        network.writeBoolean(this.namedParams);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.language = channel.readString();
        this.statement = channel.readString();
        this.operationType = channel.readByte();
        this.recordsPerPage = channel.readInt();
        channel.readString();
        this.paramsBytes = channel.readBytes();
        this.namedParams = channel.readBoolean();
        this.serializer = serializer;
    }

    @Override
    public byte getCommand() {
        return 45;
    }

    @Override
    public String getDescription() {
        return "Execute remote query";
    }

    @Override
    public OQueryResponse createResponse() {
        return new OQueryResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeQuery(this);
    }

    public String getStatement() {
        return this.statement;
    }

    public Map<String, Object> getParams() {
        if (this.params == null && this.paramsBytes != null) {
            ODocument paramsDoc = new ODocument();
            paramsDoc.setTrackingChanges(false);
            this.serializer.fromStream(this.paramsBytes, paramsDoc, null);
            this.params = (Map)paramsDoc.field("params");
        }
        return this.params;
    }

    public byte getOperationType() {
        return this.operationType;
    }

    public boolean isNamedParams() {
        return this.namedParams;
    }

    public Map getNamedParameters() {
        return this.getParams();
    }

    public Object[] getPositionalParameters() {
        Map<String, Object> params = this.getParams();
        if (params == null) {
            return null;
        }
        Object[] result = new Object[params.size()];
        params.entrySet().forEach(e -> {
            result[Integer.parseInt((String)((String)e.getKey()))] = e.getValue();
        });
        return result;
    }

    public int getRecordsPerPage() {
        return this.recordsPerPage;
    }

    public ORecordSerializer getSerializer() {
        return this.serializer;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

