/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.script;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandRequestTextAbstract;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import javax.script.CompiledScript;

public class OCommandScript
extends OCommandRequestTextAbstract {
    private String language;
    private CompiledScript compiledScript;
    private OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE executionMode = OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;

    public OCommandScript() {
        this.useCache = true;
    }

    public OCommandScript(String iLanguage, String iText) {
        super(iText);
        this.setLanguage(iLanguage);
        this.useCache = true;
    }

    public OCommandScript(String iText) {
        this("sql", iText);
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    public String getLanguage() {
        return this.language;
    }

    public OCommandScript setLanguage(String language) {
        if (language == null || language.isEmpty()) {
            throw new IllegalArgumentException("Not a valid script language specified: " + language);
        }
        this.language = language;
        return this;
    }

    @Override
    public OCommandRequestText fromStream(byte[] iStream, ORecordSerializer serializer) throws OSerializationException {
        OMemoryStream buffer = new OMemoryStream(iStream);
        this.language = buffer.getAsString();
        int currPosition = buffer.getPosition();
        String value = buffer.getAsString();
        try {
            this.executionMode = OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.valueOf(value);
        }
        catch (IllegalArgumentException ignore) {
            buffer.setPosition(currPosition);
        }
        this.fromStream(buffer, serializer);
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        OMemoryStream buffer = new OMemoryStream();
        buffer.setUtf8(this.language);
        buffer.setUtf8(this.executionMode.name());
        return this.toStream(buffer);
    }

    public CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    public void setCompiledScript(CompiledScript script) {
        this.compiledScript = script;
    }

    @Override
    public String toString() {
        if (this.language != null) {
            return this.language + "." + this.text;
        }
        return "script." + this.text;
    }

    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getExecutionMode() {
        return this.executionMode;
    }

    public OCommandScript setExecutionMode(OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE executionMode) {
        this.executionMode = executionMode;
        return this;
    }
}

