/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.compression.impl;

import com.orientechnologies.orient.core.compression.impl.OAbstractCompression;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class OZIPCompression
extends OAbstractCompression {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] compress(byte[] content, int offset, int length) {
        try {
            byte[] result;
            OMemoryStream memoryOutputStream = new OMemoryStream();
            this.setLevel(zipOutputStream);
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(memoryOutputStream);){
                ZipEntry ze = new ZipEntry("content");
                zipOutputStream.putNextEntry(ze);
                try {
                    zipOutputStream.write(content, offset, length);
                }
                finally {
                    zipOutputStream.closeEntry();
                }
                zipOutputStream.finish();
                result = memoryOutputStream.toByteArray();
            }
            return result;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Exception during data compression", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] uncompress(byte[] content, int offset, int length) {
        byte[] byArray;
        ByteArrayInputStream memoryInputStream = new ByteArrayInputStream(content, offset, length);
        ZipInputStream gzipInputStream = new ZipInputStream(memoryInputStream);
        try {
            int bytesRead;
            byte[] buffer = new byte[1024];
            byte[] result = new byte[1024];
            gzipInputStream.getNextEntry();
            int len = 0;
            while ((bytesRead = gzipInputStream.read(buffer, 0, buffer.length)) > -1) {
                if (len + bytesRead > result.length) {
                    int newSize = 2 * result.length;
                    if (newSize < len + bytesRead) {
                        newSize = Integer.MAX_VALUE;
                    }
                    byte[] oldResult = result;
                    result = new byte[newSize];
                    System.arraycopy(oldResult, 0, result, 0, oldResult.length);
                }
                System.arraycopy(buffer, 0, result, len, bytesRead);
                len += bytesRead;
            }
            byArray = Arrays.copyOf(result, len);
        }
        catch (Throwable throwable) {
            try {
                gzipInputStream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Exception during data uncompression", ioe);
            }
        }
        gzipInputStream.close();
        return byArray;
    }

    protected abstract void setLevel(ZipOutputStream var1);
}

