/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.config;

import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public interface OStorageConfiguration {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final int CURRENT_VERSION = 23;
    public static final int CURRENT_BINARY_FORMAT_VERSION = 13;

    public SimpleDateFormat getDateTimeFormatInstance();

    public SimpleDateFormat getDateFormatInstance();

    public String getCharset();

    public Locale getLocaleInstance();

    public String getSchemaRecordId();

    public int getMinimumClusters();

    public boolean isStrictSql();

    public String getIndexMgrRecordId();

    public TimeZone getTimeZone();

    public String getDateFormat();

    public String getDateTimeFormat();

    public OContextConfiguration getContextConfiguration();

    public String getLocaleCountry();

    public String getLocaleLanguage();

    public List<OStorageEntryConfiguration> getProperties();

    public String getClusterSelection();

    public String getConflictStrategy();

    public boolean isValidationEnabled();

    public IndexEngineData getIndexEngine(String var1, int var2);

    public String getRecordSerializer();

    public int getRecordSerializerVersion();

    public int getBinaryFormatVersion();

    public int getVersion();

    public String getName();

    public String getProperty(String var1);

    public String getDirectory();

    public List<OStorageClusterConfiguration> getClusters();

    public String getCreatedAtVersion();

    public Set<String> indexEngines();

    public int getPageSize();

    public int getFreeListBoundary();

    public int getMaxKeySize();

    public void setUuid(OAtomicOperation var1, String var2);

    public String getUuid();

    public static final class IndexEngineData {
        private final int indexId;
        private final String name;
        private final String algorithm;
        private final String indexType;
        private final Boolean durableInNonTxMode;
        private final int version;
        private final int apiVersion;
        private final boolean multivalue;
        private final byte valueSerializerId;
        private final byte keySerializedId;
        private final boolean isAutomatic;
        private final OType[] keyTypes;
        private final boolean nullValuesSupport;
        private final int keySize;
        private final Map<String, String> engineProperties;
        private final String encryption;
        private final String encryptionOptions;

        public IndexEngineData(int indexId, String name, String algorithm, String indexType, Boolean durableInNonTxMode, int version, int apiVersion, boolean multivalue, byte valueSerializerId, byte keySerializedId, boolean isAutomatic, OType[] keyTypes, boolean nullValuesSupport, int keySize, String encryption, String encryptionOptions, Map<String, String> engineProperties) {
            this.indexId = indexId;
            this.name = name;
            this.algorithm = algorithm;
            this.indexType = indexType;
            this.durableInNonTxMode = durableInNonTxMode;
            this.version = version;
            this.apiVersion = apiVersion;
            this.multivalue = multivalue;
            this.valueSerializerId = valueSerializerId;
            this.keySerializedId = keySerializedId;
            this.isAutomatic = isAutomatic;
            this.keyTypes = keyTypes;
            this.nullValuesSupport = nullValuesSupport;
            this.keySize = keySize;
            this.encryption = encryption;
            this.encryptionOptions = encryptionOptions;
            this.engineProperties = engineProperties == null ? null : new HashMap<String, String>(engineProperties);
        }

        public int getIndexId() {
            return this.indexId;
        }

        public int getKeySize() {
            return this.keySize;
        }

        public String getName() {
            return this.name;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public Boolean getDurableInNonTxMode() {
            return this.durableInNonTxMode;
        }

        public int getVersion() {
            return this.version;
        }

        public int getApiVersion() {
            return this.apiVersion;
        }

        public boolean isMultivalue() {
            return this.multivalue;
        }

        public byte getValueSerializerId() {
            return this.valueSerializerId;
        }

        public byte getKeySerializedId() {
            return this.keySerializedId;
        }

        public boolean isAutomatic() {
            return this.isAutomatic;
        }

        public OType[] getKeyTypes() {
            return this.keyTypes;
        }

        public String getEncryption() {
            return this.encryption;
        }

        public String getEncryptionOptions() {
            return this.encryptionOptions;
        }

        public boolean isNullValuesSupport() {
            return this.nullValuesSupport;
        }

        public Map<String, String> getEngineProperties() {
            if (this.engineProperties == null) {
                return null;
            }
            return Collections.unmodifiableMap(this.engineProperties);
        }

        public String getIndexType() {
            return this.indexType;
        }
    }
}

