/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class OPartitionedDatabasePoolFactory
extends OOrientListenerAbstract {
    private volatile int maxPoolSize = 64;
    private boolean closed = false;
    private final ConcurrentLinkedHashMap<PoolIdentity, OPartitionedDatabasePool> poolStore;
    private final EvictionListener<PoolIdentity, OPartitionedDatabasePool> evictionListener = new EvictionListener<PoolIdentity, OPartitionedDatabasePool>(){

        @Override
        public void onEviction(PoolIdentity poolIdentity, OPartitionedDatabasePool partitionedDatabasePool) {
            partitionedDatabasePool.close();
        }
    };

    public OPartitionedDatabasePoolFactory() {
        this(100);
    }

    public OPartitionedDatabasePoolFactory(int capacity) {
        this.poolStore = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(capacity).listener(this.evictionListener).build();
        Orient.instance().registerWeakOrientStartupListener(this);
        Orient.instance().registerWeakOrientShutdownListener(this);
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.checkForClose();
        this.maxPoolSize = maxPoolSize;
    }

    public void reset() {
        while (!this.poolStore.isEmpty()) {
            Iterator<OPartitionedDatabasePool> poolIterator = this.poolStore.values().iterator();
            while (poolIterator.hasNext()) {
                OPartitionedDatabasePool pool = poolIterator.next();
                try {
                    pool.close();
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "Error during pool close", e, new Object[0]);
                }
                poolIterator.remove();
            }
        }
        for (OPartitionedDatabasePool pool : this.poolStore.values()) {
            pool.close();
        }
        this.poolStore.clear();
    }

    public OPartitionedDatabasePool get(String url, String userName, String userPassword) {
        OPartitionedDatabasePool oldPool;
        this.checkForClose();
        PoolIdentity poolIdentity = new PoolIdentity(url, userName, userPassword);
        OPartitionedDatabasePool pool = this.poolStore.get(poolIdentity);
        if (pool != null && !pool.isClosed()) {
            return pool;
        }
        if (pool != null) {
            this.poolStore.remove(poolIdentity, pool);
        }
        while ((oldPool = this.poolStore.putIfAbsent(poolIdentity, pool = new OPartitionedDatabasePool(url, userName, userPassword, 8, this.maxPoolSize))) != null) {
            if (!oldPool.isClosed()) {
                return oldPool;
            }
            this.poolStore.remove(poolIdentity, oldPool);
        }
        return pool;
    }

    public Collection<OPartitionedDatabasePool> getPools() {
        this.checkForClose();
        return Collections.unmodifiableCollection(this.poolStore.values());
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.reset();
    }

    private void checkForClose() {
        if (this.closed) {
            throw new IllegalStateException("Pool factory is closed");
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void onShutdown() {
        this.close();
    }

    private static final class PoolIdentity {
        private final String url;
        private final String userName;
        private final String userPassword;

        private PoolIdentity(String url, String userName, String userPassword) {
            this.url = url;
            this.userName = userName;
            this.userPassword = userPassword;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PoolIdentity that = (PoolIdentity)o;
            if (!this.url.equals(that.url)) {
                return false;
            }
            if (!this.userName.equals(that.userName)) {
                return false;
            }
            return this.userPassword.equals(that.userPassword);
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = 31 * result + this.userName.hashCode();
            result = 31 * result + this.userPassword.hashCode();
            return result;
        }
    }
}

