/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.config;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public class ONodeIdentity
implements Cloneable {
    private String id;
    private String name;

    public ONodeIdentity(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public ONodeIdentity() {
    }

    public static ONodeIdentity generate(String nodeName) {
        return new ONodeIdentity(UUID.randomUUID().toString(), nodeName);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ONodeIdentity that = (ONodeIdentity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.name + '{' + this.id + '}';
    }

    public void serialize(DataOutput output) throws IOException {
        output.writeUTF(this.id);
        output.writeUTF(this.name);
    }

    public void deserialize(DataInput input) throws IOException {
        this.id = input.readUTF();
        this.name = input.readUTF();
    }
}

