/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.client.remote.message.tx.IndexChange;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperation38Response;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializerDelta;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class OTransactionOptimisticClient
extends OTransactionOptimistic {
    private Set<String> indexChanged = new HashSet<String>();

    public OTransactionOptimisticClient(ODatabaseDocumentInternal iDatabase) {
        super(iDatabase);
    }

    public void replaceContent(List<ORecordOperation38Response> operations, List<IndexChange> indexChanges) {
        Map oldEntries = this.allEntries;
        this.allEntries = new LinkedHashMap();
        int createCount = -2;
        for (ORecordOperation38Response operation : operations) {
            if (!operation.getOldId().equals(operation.getId())) {
                this.updatedRids.put(operation.getId().copy(), operation.getOldId());
            }
            ORecord record = null;
            ORecordOperation op = (ORecordOperation)oldEntries.get(operation.getOldId());
            if (op != null) {
                record = op.getRecord();
            }
            if (record == null) {
                this.getDatabase().getLocalCache().findRecord(operation.getOldId());
            }
            if (record != null) {
                record.unload();
            } else {
                record = Orient.instance().getRecordFactoryManager().newInstance(operation.getRecordType(), operation.getOldId().getClusterId(), this.database);
            }
            if (operation.getType() == 1 && operation.getRecordType() == 100) {
                record.fromStream(operation.getOriginal());
                ODocumentSerializerDelta deltaSerializer = ODocumentSerializerDelta.instance();
                deltaSerializer.deserializeDelta(operation.getRecord(), (ODocument)record);
            } else {
                record.fromStream(operation.getRecord());
            }
            ORecordInternal.setIdentity(record, (ORecordId)operation.getId());
            ORecordInternal.setVersion(record, operation.getVersion());
            ORecordInternal.setContentChanged(record, operation.isContentChanged());
            this.getDatabase().getLocalCache().updateRecord(record);
            boolean callHook = this.checkCallHook(oldEntries, operation.getId(), operation.getType());
            this.addRecord(record, operation.getType(), null, callHook);
            if (operation.getType() != 3) continue;
            --createCount;
        }
        this.newObjectCounter = createCount;
        for (IndexChange change : indexChanges) {
            TreeMap<Object, OTransactionIndexChangesPerKey> changesPerKey = new TreeMap<Object, OTransactionIndexChangesPerKey>(ODefaultComparator.INSTANCE);
            for (Map.Entry keyChange : change.getKeyChanges().changesPerKey.entrySet()) {
                Object key = keyChange.getKey();
                if (key instanceof OIdentifiable && ((OIdentifiable)key).getIdentity().isNew()) {
                    key = ((OIdentifiable)key).getRecord();
                }
                OTransactionIndexChangesPerKey singleChange = new OTransactionIndexChangesPerKey(key);
                singleChange.entries.addAll(((OTransactionIndexChangesPerKey)keyChange.getValue()).entries);
                changesPerKey.put(key, singleChange);
            }
            change.getKeyChanges().changesPerKey = changesPerKey;
            this.indexEntries.put(change.getName(), change.getKeyChanges());
        }
    }

    private boolean checkCallHook(Map<ORID, ORecordOperation> oldEntries, ORID rid, byte type) {
        ORecordOperation val = oldEntries.get(rid);
        return val == null || val.getType() != type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(ORecord iRecord, byte iStatus, String iClusterName, boolean callHook) {
        if (iStatus != 0) {
            this.changedDocuments.remove(iRecord);
        }
        try {
            if (callHook) {
                switch (iStatus) {
                    case 3: {
                        OIdentifiable res = this.database.beforeCreateOperations(iRecord, iClusterName);
                        if (res == null) break;
                        iRecord = (ORecord)res;
                        this.changed = true;
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        OIdentifiable res = this.database.beforeUpdateOperations(iRecord, iClusterName);
                        if (res == null) break;
                        iRecord = (ORecord)res;
                        this.changed = true;
                        break;
                    }
                    case 2: {
                        this.database.beforeDeleteOperations(iRecord, iClusterName);
                    }
                }
            }
            try {
                ORecordId rid = (ORecordId)iRecord.getIdentity();
                ORecordOperation txEntry = this.getRecordEntry(rid);
                if (txEntry == null) {
                    if (!rid.isTemporary() || iStatus == 3) {
                        txEntry = new ORecordOperation(iRecord, iStatus);
                        this.allEntries.put(rid.copy(), txEntry);
                    }
                } else {
                    txEntry.record = iRecord;
                    switch (txEntry.type) {
                        case 0: {
                            switch (iStatus) {
                                case 1: {
                                    txEntry.type = 1;
                                    break;
                                }
                                case 2: {
                                    txEntry.type = (byte)2;
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (iStatus) {
                                case 2: {
                                    txEntry.type = (byte)2;
                                }
                            }
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            switch (iStatus) {
                                case 2: {
                                    this.allEntries.remove(rid);
                                }
                            }
                        }
                    }
                }
                if (callHook) {
                    switch (iStatus) {
                        case 3: {
                            this.database.callbackHooks(ORecordHook.TYPE.AFTER_CREATE, iRecord);
                            break;
                        }
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.database.callbackHooks(ORecordHook.TYPE.AFTER_UPDATE, iRecord);
                            break;
                        }
                        case 2: {
                            this.database.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, iRecord);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (callHook) {
                    switch (iStatus) {
                        case 3: {
                            this.database.callbackHooks(ORecordHook.TYPE.CREATE_FAILED, iRecord);
                            break;
                        }
                        case 1: {
                            this.database.callbackHooks(ORecordHook.TYPE.UPDATE_FAILED, iRecord);
                            break;
                        }
                        case 2: {
                            this.database.callbackHooks(ORecordHook.TYPE.DELETE_FAILED, iRecord);
                        }
                    }
                }
                throw OException.wrapException(new ODatabaseException("Error on saving record " + iRecord.getIdentity()), e);
            }
        }
        finally {
            if (callHook) {
                switch (iStatus) {
                    case 3: {
                        this.database.callbackHooks(ORecordHook.TYPE.FINALIZE_CREATION, iRecord);
                        break;
                    }
                    case 1: {
                        this.database.callbackHooks(ORecordHook.TYPE.FINALIZE_UPDATE, iRecord);
                        break;
                    }
                    case 2: {
                        this.database.callbackHooks(ORecordHook.TYPE.FINALIZE_DELETION, iRecord);
                    }
                }
            }
        }
    }

    public Set<String> getIndexChanged() {
        return this.indexChanged;
    }

    public void addIndexChanged(String indexName) {
        this.indexChanged.add(indexName);
    }
}

