/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OLazyRecordIterator;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordMultiValueHelper;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class ORecordLazyMap
extends OTrackedMap<OIdentifiable>
implements ORecordLazyMultiValue {
    private final byte recordType;
    private ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE multiValueStatus = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.EMPTY;
    private boolean autoConvertToRecord = true;

    public ORecordLazyMap(ORecordElement iSourceRecord) {
        super(iSourceRecord);
        this.recordType = (byte)100;
    }

    public ORecordLazyMap(ODocument iSourceRecord, byte iRecordType) {
        super(iSourceRecord);
        this.recordType = iRecordType;
        if (iSourceRecord != null && !iSourceRecord.isLazyLoad()) {
            this.autoConvertToRecord = false;
        }
    }

    public ORecordLazyMap(ODocument iSourceRecord, Map<Object, OIdentifiable> iOrigin) {
        this(iSourceRecord);
        if (iOrigin != null && !iOrigin.isEmpty()) {
            this.putAll(iOrigin);
        }
    }

    @Override
    public boolean containsValue(Object o) {
        return super.containsValue(o);
    }

    @Override
    public OIdentifiable get(Object iKey) {
        if (iKey == null) {
            return null;
        }
        String key = iKey.toString();
        if (this.autoConvertToRecord) {
            this.convertLink2Record(key);
        }
        return (OIdentifiable)super.get(key);
    }

    @Override
    public OIdentifiable put(Object key, OIdentifiable value) {
        if (this.multiValueStatus == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS && value instanceof ORecord && !value.getIdentity().isNew()) {
            value = value.getIdentity();
        } else {
            this.multiValueStatus = ORecordMultiValueHelper.updateContentType(this.multiValueStatus, value);
        }
        return super.put(key, value);
    }

    @Override
    public Collection<OIdentifiable> values() {
        this.convertLinks2Records();
        return super.values();
    }

    @Override
    public OIdentifiable remove(Object o) {
        OIdentifiable result = (OIdentifiable)super.remove(o);
        if (this.size() == 0) {
            this.multiValueStatus = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.EMPTY;
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.multiValueStatus = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.EMPTY;
    }

    @Override
    public String toString() {
        return ORecordMultiValueHelper.toString(this);
    }

    @Override
    public boolean isAutoConvertToRecord() {
        return this.autoConvertToRecord;
    }

    @Override
    public void setAutoConvertToRecord(boolean convertToRecord) {
        this.autoConvertToRecord = convertToRecord;
    }

    @Override
    public void convertLinks2Records() {
        if (this.multiValueStatus == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RECORDS || !this.autoConvertToRecord) {
            return;
        }
        for (Object k : this.keySet()) {
            this.convertLink2Record(k);
        }
        this.multiValueStatus = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RECORDS;
    }

    @Override
    public boolean convertRecords2Links() {
        if (this.multiValueStatus == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS) {
            return true;
        }
        boolean allConverted = true;
        for (Object k : this.keySet()) {
            if (this.convertRecord2Link(k)) continue;
            allConverted = false;
        }
        if (allConverted) {
            this.multiValueStatus = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS;
        }
        return allConverted;
    }

    private boolean convertRecord2Link(Object iKey) {
        if (this.multiValueStatus == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS) {
            return true;
        }
        Object value = super.get(iKey);
        if (value != null) {
            if (value instanceof ORecord && !((ORecord)value).getIdentity().isNew()) {
                super.putInternal(iKey, ((ORecord)value).getIdentity());
                return true;
            }
            if (value instanceof ORID) {
                return true;
            }
        }
        return false;
    }

    private void convertLink2Record(Object iKey) {
        if (this.multiValueStatus == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RECORDS) {
            return;
        }
        Object value = iKey instanceof ORID ? iKey : super.get(iKey);
        if (value != null && value instanceof ORID) {
            ORID rid = (ORID)value;
            try {
                Object record = rid.getRecord();
                if (record != null) {
                    ORecordInternal.unTrack(this.sourceRecord, rid);
                    ORecordInternal.track(this.sourceRecord, record);
                }
                super.putInternal(iKey, record);
            }
            catch (ORecordNotFoundException oRecordNotFoundException) {
                // empty catch block
            }
        }
    }

    public byte getRecordType() {
        return this.recordType;
    }

    @Override
    public Iterator<OIdentifiable> rawIterator() {
        return new OLazyRecordIterator(this.sourceRecord, super.values().iterator(), false);
    }

    @Override
    public boolean detach() {
        return this.convertRecords2Links();
    }

    @Override
    public int size() {
        return super.size();
    }
}

