/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OAutoConvertToRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OLazyRecordIterator;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordMultiValueHelper;
import com.orientechnologies.orient.core.db.record.ORecordTrackedIterator;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.OIdentityChangeListener;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.OSimpleMultiValueTracker;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class ORecordLazySet
extends AbstractCollection<OIdentifiable>
implements Set<OIdentifiable>,
OTrackedMultiValue<OIdentifiable, OIdentifiable>,
ORecordElement,
ORecordLazyMultiValue,
OIdentityChangeListener {
    protected boolean autoConvertToRecord = true;
    protected final ORecordElement sourceRecord;
    protected Map<OIdentifiable, Object> map = new HashMap<OIdentifiable, Object>();
    protected static final Object ENTRY_REMOVAL = new Object();
    private boolean dirty = false;
    private boolean transactionDirty = false;
    private OSimpleMultiValueTracker<OIdentifiable, OIdentifiable> tracker = new OSimpleMultiValueTracker(this);

    public ORecordLazySet(ORecordElement iSourceRecord) {
        this.sourceRecord = iSourceRecord;
    }

    public ORecordLazySet(ORecordElement iSourceRecord, Collection<OIdentifiable> iOrigin) {
        this(iSourceRecord);
        if (iOrigin != null && !iOrigin.isEmpty()) {
            this.addAll((Collection<? extends OIdentifiable>)iOrigin);
        }
    }

    @Override
    public ORecordElement getOwner() {
        return this.sourceRecord;
    }

    @Override
    public boolean addInternal(OIdentifiable e) {
        if (this.map.containsKey(e)) {
            return false;
        }
        this.map.put(e, ENTRY_REMOVAL);
        this.addOwnerToEmbeddedDoc(e);
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public void clear() {
        this.setDirty();
        this.map.clear();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object item : c) {
            if (!this.remove(item)) continue;
            changed = true;
        }
        if (changed) {
            this.setDirty();
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends OIdentifiable> c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        boolean convert = false;
        if (c instanceof OAutoConvertToRecord) {
            convert = ((OAutoConvertToRecord)((Object)c)).isAutoConvertToRecord();
            ((OAutoConvertToRecord)((Object)c)).setAutoConvertToRecord(false);
        }
        for (OIdentifiable oIdentifiable : c) {
            this.add(oIdentifiable);
        }
        if (c instanceof OAutoConvertToRecord) {
            ((OAutoConvertToRecord)((Object)c)).setAutoConvertToRecord(convert);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        return super.retainAll(c);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public ORecordLazySet setDirty() {
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
        this.dirty = true;
        this.transactionDirty = true;
        return this;
    }

    @Override
    public void setDirtyNoChanged() {
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirtyNoChanged();
        }
    }

    public Set<OIdentifiable> returnOriginalState(List<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> events) {
        HashSet<OIdentifiable> reverted = new HashSet<OIdentifiable>(this);
        ListIterator<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> listIterator = events.listIterator(events.size());
        block4: while (listIterator.hasPrevious()) {
            OMultiValueChangeEvent<OIdentifiable, OIdentifiable> event = listIterator.previous();
            switch (event.getChangeType()) {
                case ADD: {
                    reverted.remove(event.getKey());
                    continue block4;
                }
                case REMOVE: {
                    reverted.add(event.getOldValue());
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)event.getChangeType()));
        }
        return reverted;
    }

    protected void addOwnerToEmbeddedDoc(OIdentifiable e) {
        if (this.sourceRecord != null && e != null) {
            ORecordInternal.track(this.sourceRecord, e);
        }
    }

    protected void addEvent(OIdentifiable added) {
        this.addOwnerToEmbeddedDoc(added);
        if (this.tracker.isEnabled()) {
            this.tracker.add(added, added);
        } else {
            this.setDirty();
        }
    }

    private void updateEvent(OIdentifiable oldValue, OIdentifiable newValue) {
        if (oldValue instanceof ODocument) {
            ODocumentInternal.removeOwner((ODocument)oldValue, this);
        }
        this.addOwnerToEmbeddedDoc(newValue);
        if (this.tracker.isEnabled()) {
            this.tracker.updated(oldValue, newValue, newValue);
        } else {
            this.setDirty();
        }
    }

    protected void removeEvent(OIdentifiable removed) {
        if (removed instanceof ODocument) {
            ODocumentInternal.removeOwner((ODocument)removed, this);
        }
        if (this.tracker.isEnabled()) {
            this.tracker.remove(removed, removed);
        } else {
            this.setDirty();
        }
    }

    @Override
    public Class<?> getGenericClass() {
        return OIdentifiable.class;
    }

    @Override
    public void replace(OMultiValueChangeEvent<Object, Object> event, Object newValue) {
    }

    @Override
    public void enableTracking(ORecordElement parent) {
        if (!this.tracker.isEnabled()) {
            this.tracker.enable();
            if (this instanceof ORecordLazyMultiValue) {
                OTrackedMultiValue.nestedEnabled(this.rawIterator(), this);
            } else {
                OTrackedMultiValue.nestedEnabled(this.iterator(), this);
            }
        }
    }

    @Override
    public void disableTracking(ORecordElement document) {
        if (this.tracker.isEnabled()) {
            this.tracker.disable();
            if (this instanceof ORecordLazyMultiValue) {
                OTrackedMultiValue.nestedDisable(this.rawIterator(), this);
            } else {
                OTrackedMultiValue.nestedDisable(this.iterator(), this);
            }
        }
        this.dirty = false;
    }

    @Override
    public void transactionClear() {
        this.tracker.transactionClear();
        if (this instanceof ORecordLazyMultiValue) {
            OTrackedMultiValue.nestedTransactionClear(this.rawIterator());
        } else {
            OTrackedMultiValue.nestedTransactionClear(this.iterator());
        }
        this.transactionDirty = false;
    }

    @Override
    public boolean isModified() {
        return this.dirty;
    }

    @Override
    public boolean isTransactionModified() {
        return this.transactionDirty;
    }

    @Override
    public OMultiValueChangeTimeLine<Object, Object> getTimeLine() {
        return this.tracker.getTimeLine();
    }

    @Override
    public boolean detach() {
        return this.convertRecords2Links();
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return new OLazyRecordIterator((Iterator<? extends OIdentifiable>)new OLazyIterator<OIdentifiable>(){
            private Iterator<Map.Entry<OIdentifiable, Object>> iter;
            private Map.Entry<OIdentifiable, Object> last;
            {
                this.iter = ORecordLazySet.this.map.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public OIdentifiable next() {
                Map.Entry<OIdentifiable, Object> entry = this.iter.next();
                this.last = entry;
                if (entry.getValue() != ENTRY_REMOVAL) {
                    return (OIdentifiable)entry.getValue();
                }
                if (entry.getKey() instanceof ORecordId && ORecordLazySet.this.autoConvertToRecord && ODatabaseRecordThreadLocal.instance().isDefined()) {
                    try {
                        Object rec = entry.getKey().getRecord();
                        if (ORecordLazySet.this.sourceRecord != null && rec != null) {
                            ORecordInternal.track(ORecordLazySet.this.sourceRecord, rec);
                        }
                        if (this.iter instanceof OLazyIterator) {
                            ((OLazyIterator)this.iter).update(entry);
                        }
                        this.last = entry;
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error on iterating record collection", e, new Object[0]);
                        entry = null;
                    }
                }
                return entry == null ? null : entry.getKey();
            }

            @Override
            public void remove() {
                this.iter.remove();
                if (this.last.getKey() instanceof ORecord) {
                    ORecordInternal.removeIdentityChangeListener((ORecord)this.last.getKey(), ORecordLazySet.this);
                }
            }

            @Override
            public OIdentifiable update(OIdentifiable iValue) {
                if (iValue != null) {
                    ORecordLazySet.this.map.put(iValue.getIdentity(), iValue.getRecord());
                }
                return iValue;
            }
        }, this.autoConvertToRecord);
    }

    @Override
    public Iterator<OIdentifiable> rawIterator() {
        return new OLazyRecordIterator(new ORecordTrackedIterator(this.sourceRecord, this.map.keySet().iterator()), false);
    }

    @Override
    public boolean add(OIdentifiable e) {
        if (this.map.containsKey(e)) {
            return false;
        }
        if (e == null) {
            this.map.put(null, null);
        } else if (e instanceof ORecord && e.getIdentity().isNew()) {
            ORecordInternal.addIdentityChangeListener((ORecord)e, this);
            this.map.put(e, e);
        } else if (!e.getIdentity().isPersistent()) {
            this.map.put(e, e);
        } else {
            this.map.put(e, ENTRY_REMOVAL);
        }
        this.addEvent(e);
        return true;
    }

    @Override
    public void convertLinks2Records() {
        for (Map.Entry<OIdentifiable, Object> entry : this.map.entrySet()) {
            if (entry.getValue() instanceof ORecord) continue;
            try {
                Object record = entry.getKey().getRecord();
                if (record != null) {
                    ORecordInternal.unTrack(this.sourceRecord, entry.getKey());
                    ORecordInternal.track(this.sourceRecord, record);
                }
                entry.setValue(record);
            }
            catch (ORecordNotFoundException oRecordNotFoundException) {}
        }
    }

    @Override
    public void onAfterIdentityChange(ORecord record) {
        this.map.put(record, record);
    }

    @Override
    public void onBeforeIdentityChange(ORecord record) {
        this.map.remove(record);
    }

    @Override
    public boolean convertRecords2Links() {
        return true;
    }

    public boolean clearDeletedRecords() {
        boolean removed = false;
        Iterator<Map.Entry<OIdentifiable, Object>> all = this.map.entrySet().iterator();
        while (all.hasNext()) {
            Map.Entry<OIdentifiable, Object> entry = all.next();
            if (entry.getValue() != ENTRY_REMOVAL) continue;
            try {
                if (entry.getKey().getRecord() != null) continue;
                all.remove();
                removed = true;
            }
            catch (ORecordNotFoundException ignore) {
                all.remove();
                removed = true;
            }
        }
        return removed;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return this.clearDeletedRecords();
        }
        Object old = this.map.remove(o);
        if (old != null) {
            if (o instanceof ORecord) {
                ORecordInternal.removeIdentityChangeListener((ORecord)o, this);
            }
            this.removeEvent((OIdentifiable)o);
            return true;
        }
        return false;
    }

    @Override
    public boolean isAutoConvertToRecord() {
        return this.autoConvertToRecord;
    }

    @Override
    public void setAutoConvertToRecord(boolean convertToRecord) {
        this.autoConvertToRecord = convertToRecord;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Set) {
            Set coll = (Set)obj;
            if (this.map.size() == coll.size()) {
                for (Object obje : coll) {
                    if (this.map.containsKey(obje)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public String toString() {
        return ORecordMultiValueHelper.toString(this);
    }

    @Override
    public OMultiValueChangeTimeLine<OIdentifiable, OIdentifiable> getTransactionTimeLine() {
        return this.tracker.getTransactionTimeLine();
    }
}

