/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.OAutoConvertToRecord;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.OSimpleMultiValueTracker;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class OTrackedMap<T>
extends LinkedHashMap<Object, T>
implements ORecordElement,
OTrackedMultiValue<Object, T>,
Serializable {
    protected final ORecordElement sourceRecord;
    protected Class<?> genericClass;
    private final boolean embeddedCollection;
    private boolean dirty = false;
    private boolean transactionDirty = false;
    private OSimpleMultiValueTracker<Object, T> tracker = new OSimpleMultiValueTracker(this);

    public OTrackedMap(ORecordElement iRecord, Map<Object, T> iOrigin, Class<?> cls) {
        this(iRecord);
        this.genericClass = cls;
        if (iOrigin != null && !iOrigin.isEmpty()) {
            this.putAll(iOrigin);
        }
    }

    public OTrackedMap(ORecordElement iSourceRecord) {
        this.sourceRecord = iSourceRecord;
        this.embeddedCollection = this.getClass().equals(OTrackedMap.class);
    }

    @Override
    public ORecordElement getOwner() {
        return this.sourceRecord;
    }

    @Override
    public boolean addInternal(T e) {
        throw new UnsupportedOperationException();
    }

    public T putInternal(Object key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("null key not supported by embedded map");
        }
        boolean containsKey = this.containsKey(key);
        T oldValue = super.put(key, value);
        if (containsKey && oldValue == value) {
            return oldValue;
        }
        if (oldValue instanceof ODocument) {
            ODocumentInternal.removeOwner((ODocument)oldValue, this);
        }
        this.addOwnerToEmbeddedDoc(value);
        return oldValue;
    }

    @Override
    public T put(Object key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("null key not supported by embedded map");
        }
        boolean containsKey = this.containsKey(key);
        T oldValue = super.put(key, value);
        if (containsKey && oldValue == value) {
            return oldValue;
        }
        if (containsKey) {
            this.updateEvent(key, oldValue, value);
        } else {
            this.addEvent(key, value);
        }
        return oldValue;
    }

    private void addOwnerToEmbeddedDoc(T e) {
        if (this.embeddedCollection && e instanceof ODocument && !((ODocument)e).getIdentity().isValid()) {
            ODocumentInternal.addOwner((ODocument)e, this);
        }
        if (e instanceof ODocument) {
            ORecordInternal.track(this.sourceRecord, (ODocument)e);
        }
    }

    @Override
    public T remove(Object iKey) {
        boolean containsKey = this.containsKey(iKey);
        if (containsKey) {
            Object oldValue = super.remove(iKey);
            this.removeEvent(iKey, oldValue);
            return (T)oldValue;
        }
        return null;
    }

    @Override
    public void clear() {
        for (Map.Entry entry : super.entrySet()) {
            this.removeEvent(entry.getKey(), entry.getValue());
        }
        super.clear();
    }

    @Override
    public void putAll(Map<?, ? extends T> m) {
        boolean convert = false;
        if (m instanceof OAutoConvertToRecord) {
            convert = ((OAutoConvertToRecord)((Object)m)).isAutoConvertToRecord();
            ((OAutoConvertToRecord)((Object)m)).setAutoConvertToRecord(false);
        }
        for (Map.Entry<?, T> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        if (m instanceof OAutoConvertToRecord) {
            ((OAutoConvertToRecord)((Object)m)).setAutoConvertToRecord(convert);
        }
    }

    public OTrackedMap<T> setDirty() {
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
        this.dirty = true;
        this.transactionDirty = true;
        return this;
    }

    @Override
    public void setDirtyNoChanged() {
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirtyNoChanged();
        }
    }

    public Map<Object, T> returnOriginalState(List<OMultiValueChangeEvent<Object, T>> multiValueChangeEvents) {
        HashMap<Object, T> reverted = new HashMap<Object, T>(this);
        ListIterator<OMultiValueChangeEvent<Object, T>> listIterator = multiValueChangeEvents.listIterator(multiValueChangeEvents.size());
        block5: while (listIterator.hasPrevious()) {
            OMultiValueChangeEvent<Object, T> event = listIterator.previous();
            switch (event.getChangeType()) {
                case ADD: {
                    reverted.remove(event.getKey());
                    continue block5;
                }
                case REMOVE: {
                    reverted.put(event.getKey(), event.getOldValue());
                    continue block5;
                }
                case UPDATE: {
                    reverted.put(event.getKey(), event.getOldValue());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)event.getChangeType()));
        }
        return reverted;
    }

    @Override
    public Class<?> getGenericClass() {
        return this.genericClass;
    }

    private Object writeReplace() {
        return new LinkedHashMap(this);
    }

    @Override
    public void replace(OMultiValueChangeEvent<Object, Object> event, Object newValue) {
        super.put(event.getKey(), newValue);
    }

    private void addEvent(Object key, T value) {
        this.addOwnerToEmbeddedDoc(value);
        if (this.tracker.isEnabled()) {
            this.tracker.add(key, value);
        } else {
            this.setDirty();
        }
    }

    private void updateEvent(Object key, T oldValue, T newValue) {
        if (oldValue instanceof ODocument) {
            ODocumentInternal.removeOwner((ODocument)oldValue, this);
        }
        this.addOwnerToEmbeddedDoc(newValue);
        if (this.tracker.isEnabled()) {
            this.tracker.updated(key, newValue, oldValue);
        } else {
            this.setDirty();
        }
    }

    private void removeEvent(Object iKey, T removed) {
        if (removed instanceof ODocument) {
            ODocumentInternal.removeOwner((ODocument)removed, this);
        }
        if (this.tracker.isEnabled()) {
            this.tracker.remove(iKey, removed);
        } else {
            this.setDirty();
        }
    }

    @Override
    public void enableTracking(ORecordElement parent) {
        if (!this.tracker.isEnabled()) {
            this.tracker.enable();
            if (this instanceof ORecordLazyMultiValue) {
                OTrackedMultiValue.nestedEnabled(((ORecordLazyMultiValue)((Object)this)).rawIterator(), this);
            } else {
                OTrackedMultiValue.nestedEnabled(this.values().iterator(), this);
            }
        }
    }

    @Override
    public void disableTracking(ORecordElement document) {
        if (this.tracker.isEnabled()) {
            this.tracker.disable();
            if (this instanceof ORecordLazyMultiValue) {
                OTrackedMultiValue.nestedDisable(((ORecordLazyMultiValue)((Object)this)).rawIterator(), this);
            } else {
                OTrackedMultiValue.nestedDisable(this.values().iterator(), this);
            }
        }
        this.dirty = false;
    }

    @Override
    public void transactionClear() {
        this.tracker.transactionClear();
        if (this instanceof ORecordLazyMultiValue) {
            OTrackedMultiValue.nestedTransactionClear(((ORecordLazyMultiValue)((Object)this)).rawIterator());
        } else {
            OTrackedMultiValue.nestedTransactionClear(this.values().iterator());
        }
        this.transactionDirty = false;
    }

    @Override
    public boolean isModified() {
        return this.dirty;
    }

    @Override
    public boolean isTransactionModified() {
        return this.transactionDirty;
    }

    @Override
    public OMultiValueChangeTimeLine<Object, Object> getTimeLine() {
        return this.tracker.getTimeLine();
    }

    @Override
    public OMultiValueChangeTimeLine<Object, T> getTransactionTimeLine() {
        return this.tracker.getTransactionTimeLine();
    }
}

