/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import java.util.Iterator;
import java.util.List;

public interface OTrackedMultiValue<K, V> {
    public Object returnOriginalState(List<OMultiValueChangeEvent<K, V>> var1);

    public Class<?> getGenericClass();

    public void replace(OMultiValueChangeEvent<Object, Object> var1, Object var2);

    public void enableTracking(ORecordElement var1);

    public void disableTracking(ORecordElement var1);

    public boolean isModified();

    public boolean isTransactionModified();

    public OMultiValueChangeTimeLine<Object, Object> getTimeLine();

    public static <X> void nestedEnabled(Iterator<X> iterator, ORecordElement parent) {
        while (iterator.hasNext()) {
            X x = iterator.next();
            if (!(x instanceof OTrackedMultiValue)) continue;
            ((OTrackedMultiValue)x).enableTracking(parent);
        }
    }

    public static <X> void nestedDisable(Iterator<X> iterator, ORecordElement parent) {
        while (iterator.hasNext()) {
            X x = iterator.next();
            if (x instanceof OTrackedMultiValue) {
                ((OTrackedMultiValue)x).disableTracking(parent);
                continue;
            }
            if (!(x instanceof ODocument) || !((ODocument)x).isEmbedded()) continue;
            ODocumentInternal.clearTrackData((ODocument)x);
            ORecordInternal.unsetDirty((ODocument)x);
        }
    }

    public static <X> void nestedTransactionClear(Iterator<X> iterator) {
        while (iterator.hasNext()) {
            X x = iterator.next();
            if (x instanceof OTrackedMultiValue) {
                ((OTrackedMultiValue)x).transactionClear();
                continue;
            }
            if (!(x instanceof ODocument) || !((ODocument)x).isEmbedded()) continue;
            ODocumentInternal.clearTransactionTrackData((ODocument)x);
        }
    }

    public void transactionClear();

    public boolean addInternal(V var1);

    public OMultiValueChangeTimeLine<K, V> getTransactionTimeLine();
}

