/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool;

import com.orientechnologies.orient.core.db.tool.ODatabaseTool;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class OCheckIndexTool
extends ODatabaseTool {
    private long totalErrors = 0L;

    @Override
    protected void parseSetting(String option, List<String> items) {
    }

    @Override
    public void run() {
        for (OIndex oIndex : this.database.getMetadata().getIndexManagerInternal().getIndexes(this.database)) {
            if (!this.canCheck(oIndex)) continue;
            this.checkIndex(oIndex);
        }
        this.message("Total errors found on indexes: " + this.getTotalErrors(), new Object[0]);
    }

    private boolean canCheck(OIndex index) {
        OIndexDefinition indexDef = index.getDefinition();
        String className = indexDef.getClassName();
        if (className == null) {
            return false;
        }
        List<String> fields = indexDef.getFields();
        List<String> fieldDefs = indexDef.getFieldsToIndex();
        for (int i = 0; i < fieldDefs.size(); ++i) {
            if (fields.get(i).equals(fieldDefs.get(i))) continue;
            return false;
        }
        return true;
    }

    private void checkIndex(OIndex index) {
        int[] clusterIds;
        List<String> fields = index.getDefinition().getFields();
        String className = index.getDefinition().getClassName();
        OClass clazz = this.database.getMetadata().getSchema().getClass(className);
        for (int clusterId : clusterIds = clazz.getPolymorphicClusterIds()) {
            this.checkCluster(clusterId, index, fields);
        }
    }

    private void checkCluster(int clusterId, OIndex index, List<String> fields) {
        long totRecordsForCluster = this.database.countClusterElements(clusterId);
        String clusterName = this.database.getClusterNameById(clusterId);
        int totSteps = 5;
        this.message("Checking cluster " + clusterName + "  for index " + index.getName() + "\n", new Object[0]);
        ORecordIteratorCluster iter2 = this.database.browseCluster(clusterName);
        long count = 0L;
        long step = -1L;
        while (iter2.hasNext()) {
            Object record;
            long currentStep = count * (long)totSteps / totRecordsForCluster;
            if (currentStep > step) {
                this.printProgress(clusterName, clusterId, (int)currentStep, totSteps);
                step = currentStep;
            }
            if ((record = iter2.next()) instanceof ODocument) {
                ODocument doc = (ODocument)record;
                this.checkThatRecordIsIndexed(doc, index, fields);
            }
            ++count;
        }
        this.printProgress(clusterName, clusterId, totSteps, totSteps);
        this.message("\n", new Object[0]);
    }

    void printProgress(String clusterName, int clusterId, int step, int totSteps) {
        StringBuilder msg = new StringBuilder();
        msg.append("\rcluster " + clusterName + " (" + clusterId + ") |");
        for (int i = 0; i < totSteps; ++i) {
            if (i < step) {
                msg.append("*");
                continue;
            }
            msg.append(" ");
        }
        msg.append("| ");
        msg.append(step * 100 / totSteps);
        msg.append("%%");
        this.message(msg.toString(), new Object[0]);
    }

    private void checkThatRecordIsIndexed(ODocument doc, OIndex index, List<String> fields) {
        Object[] vals = new Object[fields.size()];
        ORID docId = doc.getIdentity();
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = doc.field(fields.get(i));
        }
        Object indexKey = index.getDefinition().createValue(vals);
        if (indexKey == null) {
            return;
        }
        Collection<Object> indexKeys = !(indexKey instanceof Collection) ? Collections.singletonList(indexKey) : (Collection)indexKey;
        for (Object key : indexKeys) {
            Stream<ORID> stream = index.getInternal().getRids(key);
            Throwable throwable = null;
            try {
                if (!stream.noneMatch(rid -> rid.equals(docId))) continue;
                ++this.totalErrors;
                this.message("\rERROR: Index " + index.getName() + " - record not found: " + doc.getIdentity() + "\n", new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
    }

    public long getTotalErrors() {
        return this.totalErrors;
    }
}

