/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.engine;

import com.orientechnologies.common.jnr.ONative;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OMemory;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.util.Locale;

public class OMemoryAndLocalPaginatedEnginesInitializer {
    public static final OMemoryAndLocalPaginatedEnginesInitializer INSTANCE = new OMemoryAndLocalPaginatedEnginesInitializer();
    private boolean initialized = false;

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.configureDefaults();
        OMemory.checkCacheMemoryConfiguration();
        OMemory.fixCommonConfigurationProblems();
    }

    private void configureDefaults() {
        if (!OGlobalConfiguration.DISK_CACHE_SIZE.isChanged()) {
            this.configureDefaultDiskCacheSize();
        }
        if (!OGlobalConfiguration.WAL_RESTORE_BATCH_SIZE.isChanged()) {
            this.configureDefaultWalRestoreBatchSize();
        }
    }

    private void configureDefaultWalRestoreBatchSize() {
        long jvmMaxMemory = Runtime.getRuntime().maxMemory();
        if (jvmMaxMemory > 0x80000000L) {
            OGlobalConfiguration.WAL_RESTORE_BATCH_SIZE.setValue(50000);
        } else if (jvmMaxMemory > 0x20000000L) {
            OGlobalConfiguration.WAL_RESTORE_BATCH_SIZE.setValue(10000);
        }
    }

    private void configureDefaultDiskCacheSize() {
        long diskCacheInMB;
        ONative.MemoryLimitResult osMemory = ONative.instance().getMemoryLimit(true);
        if (osMemory == null) {
            OLogManager.instance().warnNoDb(this, "Can not determine amount of memory installed on machine, default size of disk cache will be used", new Object[0]);
            return;
        }
        long jvmMaxMemory = OMemory.getCappedRuntimeMaxMemory(0x80000000L);
        OLogManager.instance().infoNoDb(this, "JVM can use maximum %dMB of heap memory", jvmMaxMemory / 0x100000L);
        if (osMemory.insideContainer) {
            OLogManager.instance().infoNoDb(this, "Because OrientDB is running inside a container %s of memory will be left unallocated according to the setting '%s' not taking into account heap memory", OGlobalConfiguration.MEMORY_LEFT_TO_CONTAINER.getValueAsString(), OGlobalConfiguration.MEMORY_LEFT_TO_CONTAINER.getKey());
            diskCacheInMB = (this.calculateMemoryLeft(osMemory.memoryLimit, OGlobalConfiguration.MEMORY_LEFT_TO_CONTAINER.getKey(), OGlobalConfiguration.MEMORY_LEFT_TO_CONTAINER.getValueAsString()) - jvmMaxMemory) / 0x100000L;
        } else {
            OLogManager.instance().infoNoDb(this, "Because OrientDB is running outside a container %s of memory will be left unallocated according to the setting '%s' not taking into account heap memory", OGlobalConfiguration.MEMORY_LEFT_TO_OS.getValueAsString(), OGlobalConfiguration.MEMORY_LEFT_TO_OS.getKey());
            diskCacheInMB = (this.calculateMemoryLeft(osMemory.memoryLimit, OGlobalConfiguration.MEMORY_LEFT_TO_OS.getKey(), OGlobalConfiguration.MEMORY_LEFT_TO_OS.getValueAsString()) - jvmMaxMemory) / 0x100000L;
        }
        if (diskCacheInMB > 0L) {
            OLogManager.instance().infoNoDb(null, "OrientDB auto-config DISKCACHE=%,dMB (heap=%,dMB os=%,dMB)", diskCacheInMB, jvmMaxMemory / 1024L / 1024L, osMemory.memoryLimit / 1024L / 1024L);
            OGlobalConfiguration.DISK_CACHE_SIZE.setValue(diskCacheInMB);
        } else {
            diskCacheInMB = 256L;
            OLogManager.instance().warnNoDb(null, "Not enough physical memory available for DISKCACHE: %,dMB (heap=%,dMB). Set lower Maximum Heap (-Xmx setting on JVM) and restart OrientDB. Now running with DISKCACHE=" + diskCacheInMB + "MB", osMemory.memoryLimit / 1024L / 1024L, jvmMaxMemory / 1024L / 1024L);
            OGlobalConfiguration.DISK_CACHE_SIZE.setValue(diskCacheInMB);
            OLogManager.instance().infoNoDb(null, "OrientDB config DISKCACHE=%,dMB (heap=%,dMB os=%,dMB)", diskCacheInMB, jvmMaxMemory / 1024L / 1024L, osMemory.memoryLimit / 1024L / 1024L);
        }
    }

    private long calculateMemoryLeft(long memoryLimit, String parameter, String memoryLeft) {
        if (memoryLeft == null) {
            this.warningInvalidMemoryLeftValue(parameter, null);
            return memoryLimit;
        }
        if ((memoryLeft = memoryLeft.toLowerCase(Locale.ENGLISH)).length() < 2) {
            this.warningInvalidMemoryLeftValue(parameter, memoryLeft);
            return memoryLimit;
        }
        char lastChar = memoryLeft.charAt(memoryLeft.length() - 1);
        if (lastChar == '%') {
            int percent;
            String percentValue = memoryLeft.substring(0, memoryLeft.length() - 1);
            try {
                percent = Integer.parseInt(percentValue);
            }
            catch (NumberFormatException e) {
                this.warningInvalidMemoryLeftValue(parameter, memoryLeft);
                return memoryLimit;
            }
            if (percent < 0 || percent >= 100) {
                this.warningInvalidMemoryLeftValue(parameter, memoryLeft);
                return memoryLimit;
            }
            return (int)((double)memoryLimit * (100.0 - (double)percent) / 100.0);
        }
        if (lastChar == 'b') {
            long bytes;
            String bytesValue = memoryLeft.substring(0, memoryLeft.length() - 1);
            try {
                bytes = Long.parseLong(bytesValue);
            }
            catch (NumberFormatException e) {
                this.warningInvalidMemoryLeftValue(parameter, memoryLeft);
                return memoryLimit;
            }
            if (bytes < 0L) {
                this.warningInvalidMemoryLeftValue(parameter, memoryLeft);
                return memoryLimit;
            }
            return memoryLimit - bytes;
        }
        if (lastChar == 'k') {
            long kbytes;
            String kbytesValue = memoryLeft.substring(0, memoryLeft.length() - 1);
            try {
                kbytes = Long.parseLong(kbytesValue);
            }
            catch (NumberFormatException e) {
                this.warningInvalidMemoryLeftValue(parameter, memoryLeft);
                return memoryLimit;
            }
            long bytes = kbytes * 1024L;
            if (bytes < 0L) {
                this.warningInvalidMemoryLeftValue(parameter, memoryLeft);
                return memoryLimit;
            }
            return memoryLimit - bytes;
        }
        if (lastChar == 'm') {
            long mbytes;
            String mbytesValue = memoryLeft.substring(0, memoryLeft.length() - 1);
            try {
                mbytes = Long.parseLong(mbytesValue);
            }
            catch (NumberFormatException e) {
                this.warningInvalidMemoryLeftValue(parameter, memoryLeft);
                return memoryLimit;
            }
            long bytes = mbytes * 1024L * 1024L;
            if (bytes < 0L) {
                this.warningInvalidMemoryLeftValue(parameter, memoryLeft);
                return memoryLimit;
            }
            return memoryLimit - bytes;
        }
        if (lastChar == 'g') {
            long gbytes;
            String gbytesValue = memoryLeft.substring(0, memoryLeft.length() - 1);
            try {
                gbytes = Long.parseLong(gbytesValue);
            }
            catch (NumberFormatException e) {
                this.warningInvalidMemoryLeftValue(parameter, memoryLeft);
                return memoryLimit;
            }
            long bytes = gbytes * 1024L * 1024L * 1024L;
            if (bytes < 0L) {
                this.warningInvalidMemoryLeftValue(parameter, memoryLeft);
                return memoryLimit;
            }
            return memoryLimit - bytes;
        }
        this.warningInvalidMemoryLeftValue(parameter, memoryLeft);
        return memoryLimit;
    }

    private void warningInvalidMemoryLeftValue(String parameter, String memoryLeft) {
        OLogManager.instance().warnNoDb(this, "Invalid value of '%s' parameter ('%s') memory limit will not be decreased", memoryLeft, parameter);
    }
}

