/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.fetch;

import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OFetchPlan {
    private static final String ANY_WILDCARD = "*";
    private final Map<String, OFetchPlanLevel> fetchPlan = new HashMap<String, OFetchPlanLevel>();
    private final Map<String, OFetchPlanLevel> fetchPlanStartsWith = new HashMap<String, OFetchPlanLevel>();

    public OFetchPlan(String iFetchPlan) {
        List<String> planParts;
        this.fetchPlan.put(ANY_WILDCARD, new OFetchPlanLevel(0, 0, 0));
        if (iFetchPlan != null && !iFetchPlan.isEmpty() && !(planParts = OStringSerializerHelper.split(iFetchPlan, ' ', new char[0])).isEmpty()) {
            for (String planPart : planParts) {
                OFetchPlanLevel fp;
                List<String> parts = OStringSerializerHelper.split(planPart, ':', new char[0]);
                if (parts.size() != 2) {
                    throw new IllegalArgumentException("Wrong fetch plan: " + planPart);
                }
                String key = parts.get(0);
                int level = Integer.parseInt(parts.get(1));
                if (key.startsWith("[")) {
                    int endLevel = key.indexOf("]");
                    if (endLevel == -1) {
                        throw new IllegalArgumentException("Missing closing square bracket on depth level in fetch plan: " + key);
                    }
                    String range = key.substring(1, endLevel);
                    if ((key = key.substring(endLevel + 1)).indexOf(".") > -1) {
                        throw new IllegalArgumentException("Nested levels (fields separated by dot) are not allowed on fetch plan when dynamic depth level is specified (square brackets): " + key);
                    }
                    List<String> indexRanges = OStringSerializerHelper.smartSplit(range, '-', ' ');
                    if (indexRanges.size() > 1) {
                        String from = indexRanges.get(0);
                        String to = indexRanges.get(1);
                        int rangeFrom = from != null && !from.isEmpty() ? Integer.parseInt(from) : 0;
                        int rangeTo = to != null && !to.isEmpty() ? Integer.parseInt(to) : -1;
                        fp = new OFetchPlanLevel(rangeFrom, rangeTo, level);
                    } else if (range.equals(ANY_WILDCARD)) {
                        fp = new OFetchPlanLevel(0, -1, level);
                    } else {
                        int v = Integer.parseInt(range);
                        fp = new OFetchPlanLevel(v, v, level);
                    }
                } else {
                    fp = level == -1 ? new OFetchPlanLevel(0, -1, level) : new OFetchPlanLevel(0, 0, level);
                }
                if (key.length() > 1 && key.endsWith(ANY_WILDCARD)) {
                    this.fetchPlanStartsWith.put(key.substring(0, key.length() - 1), fp);
                    continue;
                }
                this.fetchPlan.put(key, fp);
            }
        }
    }

    public int getDepthLevel(String iFieldPath, int iCurrentLevel) {
        int i;
        OFetchPlanLevel fpLevelValue;
        String fpLevelKey;
        OFetchPlanLevel value = this.fetchPlan.get(ANY_WILDCARD);
        Integer defDepthLevel = value.level;
        String[] fpParts = iFieldPath.split("\\.");
        for (Map.Entry<String, OFetchPlanLevel> fpLevel : this.fetchPlan.entrySet()) {
            fpLevelKey = fpLevel.getKey();
            fpLevelValue = fpLevel.getValue();
            if (iCurrentLevel >= fpLevelValue.depthLevelFrom && (fpLevelValue.depthLevelTo == -1 || iCurrentLevel <= fpLevelValue.depthLevelTo)) {
                if (iFieldPath.equals(fpLevelKey)) {
                    return fpLevelValue.level;
                }
                if (fpLevelKey.startsWith(iFieldPath)) {
                    return 1;
                }
                for (i = 0; i < fpParts.length; ++i) {
                    if (i < fpLevelValue.depthLevelFrom || fpLevelValue.depthLevelTo != -1 && i > fpLevelValue.depthLevelTo || !fpParts[i].equals(fpLevelKey)) continue;
                    return fpLevelValue.level;
                }
                continue;
            }
            if (iFieldPath.equals(fpLevelKey)) {
                return fpLevelValue.level;
            }
            if (!fpLevelKey.startsWith(iFieldPath)) continue;
            return 1;
        }
        if (!this.fetchPlanStartsWith.isEmpty()) {
            for (Map.Entry<String, OFetchPlanLevel> fpLevel : this.fetchPlanStartsWith.entrySet()) {
                fpLevelKey = fpLevel.getKey();
                fpLevelValue = fpLevel.getValue();
                if (iCurrentLevel < fpLevelValue.depthLevelFrom || fpLevelValue.depthLevelTo != -1 && iCurrentLevel > fpLevelValue.depthLevelTo) continue;
                for (i = 0; i < fpParts.length; ++i) {
                    if (!fpParts[i].startsWith(fpLevelKey)) continue;
                    return fpLevelValue.level;
                }
            }
        }
        return defDepthLevel;
    }

    public boolean has(String iFieldPath, int iCurrentLevel) {
        int i;
        OFetchPlanLevel fpLevelValue;
        String fpLevelKey;
        String[] fpParts = iFieldPath.split("\\.");
        for (Map.Entry<String, OFetchPlanLevel> fpLevel : this.fetchPlan.entrySet()) {
            fpLevelKey = fpLevel.getKey();
            fpLevelValue = fpLevel.getValue();
            if (iCurrentLevel >= fpLevelValue.depthLevelFrom && (fpLevelValue.depthLevelTo == -1 || iCurrentLevel <= fpLevelValue.depthLevelTo)) {
                if (iFieldPath.equals(fpLevelKey)) {
                    return true;
                }
                if (fpLevelKey.startsWith(iFieldPath)) {
                    return true;
                }
                for (i = 0; i < fpParts.length; ++i) {
                    if (i < fpLevelValue.depthLevelFrom || fpLevelValue.depthLevelTo != -1 && i > fpLevelValue.depthLevelTo || !fpParts[i].equals(fpLevelKey)) continue;
                    return true;
                }
                continue;
            }
            if (iFieldPath.equals(fpLevelKey)) {
                return true;
            }
            if (!fpLevelKey.startsWith(iFieldPath)) continue;
            return true;
        }
        if (!this.fetchPlanStartsWith.isEmpty()) {
            for (Map.Entry<String, OFetchPlanLevel> fpLevel : this.fetchPlanStartsWith.entrySet()) {
                fpLevelKey = fpLevel.getKey();
                fpLevelValue = fpLevel.getValue();
                if (iCurrentLevel < fpLevelValue.depthLevelFrom || fpLevelValue.depthLevelTo != -1 && iCurrentLevel > fpLevelValue.depthLevelTo) continue;
                for (i = 0; i < fpParts.length; ++i) {
                    if (!fpParts[i].startsWith(fpLevelKey)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static class OFetchPlanLevel {
        public int depthLevelFrom;
        public int depthLevelTo;
        public int level;

        public OFetchPlanLevel(int iFrom, int iTo, int iLevel) {
            this.depthLevelFrom = iFrom;
            this.depthLevelTo = iTo;
            this.level = iLevel;
        }
    }
}

