/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.index.OAbstractIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeCollate;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OCompositeIndexDefinition
extends OAbstractIndexDefinition {
    private static final long serialVersionUID = -885861736290603016L;
    private final List<OIndexDefinition> indexDefinitions;
    private String className;
    private int multiValueDefinitionIndex = -1;
    private OCompositeCollate collate = new OCompositeCollate(this);

    public OCompositeIndexDefinition() {
        this.indexDefinitions = new ArrayList<OIndexDefinition>(5);
    }

    public OCompositeIndexDefinition(String iClassName) {
        this.indexDefinitions = new ArrayList<OIndexDefinition>(5);
        this.className = iClassName;
    }

    public OCompositeIndexDefinition(String iClassName, List<? extends OIndexDefinition> iIndexes, int version) {
        this.indexDefinitions = new ArrayList<OIndexDefinition>(5);
        for (OIndexDefinition oIndexDefinition : iIndexes) {
            this.indexDefinitions.add(oIndexDefinition);
            this.collate.addCollate(oIndexDefinition.getCollate());
            if (!(oIndexDefinition instanceof OIndexDefinitionMultiValue)) continue;
            if (this.multiValueDefinitionIndex == -1) {
                this.multiValueDefinitionIndex = this.indexDefinitions.size() - 1;
                continue;
            }
            throw new OIndexException("Composite key cannot contain more than one collection item");
        }
        this.className = iClassName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public void addIndex(OIndexDefinition indexDefinition) {
        this.indexDefinitions.add(indexDefinition);
        if (indexDefinition instanceof OIndexDefinitionMultiValue) {
            if (this.multiValueDefinitionIndex == -1) {
                this.multiValueDefinitionIndex = this.indexDefinitions.size() - 1;
            } else {
                throw new OIndexException("Composite key cannot contain more than one collection item");
            }
        }
        this.collate.addCollate(indexDefinition.getCollate());
    }

    @Override
    public List<String> getFields() {
        LinkedList<String> fields = new LinkedList<String>();
        for (OIndexDefinition indexDefinition : this.indexDefinitions) {
            fields.addAll(indexDefinition.getFields());
        }
        return Collections.unmodifiableList(fields);
    }

    @Override
    public List<String> getFieldsToIndex() {
        LinkedList<String> fields = new LinkedList<String>();
        for (OIndexDefinition indexDefinition : this.indexDefinitions) {
            fields.addAll(indexDefinition.getFieldsToIndex());
        }
        return Collections.unmodifiableList(fields);
    }

    @Override
    public Object getDocumentValueToIndex(ODocument iDocument) {
        ArrayList<OCompositeKey> compositeKeys = new ArrayList<OCompositeKey>(10);
        OCompositeKey firstKey = new OCompositeKey();
        boolean containsCollection = false;
        compositeKeys.add(firstKey);
        for (OIndexDefinition indexDefinition : this.indexDefinitions) {
            Object result = indexDefinition.getDocumentValueToIndex(iDocument);
            if (result == null && this.isNullValuesIgnored()) {
                return null;
            }
            if (result instanceof Collection && ((Collection)result).isEmpty() && this.isNullValuesIgnored()) {
                return null;
            }
            containsCollection = OCompositeIndexDefinition.addKey(firstKey, compositeKeys, containsCollection, result);
        }
        if (!containsCollection) {
            return firstKey;
        }
        return compositeKeys;
    }

    public int getMultiValueDefinitionIndex() {
        return this.multiValueDefinitionIndex;
    }

    public String getMultiValueField() {
        if (this.multiValueDefinitionIndex >= 0) {
            return this.indexDefinitions.get(this.multiValueDefinitionIndex).getFields().get(0);
        }
        return null;
    }

    @Override
    public Object createValue(List<?> params) {
        int currentParamIndex = 0;
        OCompositeKey firstKey = new OCompositeKey();
        ArrayList<OCompositeKey> compositeKeys = new ArrayList<OCompositeKey>(10);
        compositeKeys.add(firstKey);
        boolean containsCollection = false;
        for (OIndexDefinition indexDefinition : this.indexDefinitions) {
            if (currentParamIndex + 1 > params.size()) break;
            int endIndex = currentParamIndex + indexDefinition.getParamCount() > params.size() ? params.size() : currentParamIndex + indexDefinition.getParamCount();
            List<?> indexParams = params.subList(currentParamIndex, endIndex);
            currentParamIndex += indexDefinition.getParamCount();
            Object keyValue = indexDefinition.createValue(indexParams);
            if (keyValue == null && this.isNullValuesIgnored()) {
                return null;
            }
            if (keyValue instanceof Collection && ((Collection)keyValue).isEmpty() && this.isNullValuesIgnored()) {
                return null;
            }
            containsCollection = OCompositeIndexDefinition.addKey(firstKey, compositeKeys, containsCollection, keyValue);
        }
        if (!containsCollection) {
            return firstKey;
        }
        return compositeKeys;
    }

    public OIndexDefinitionMultiValue getMultiValueDefinition() {
        if (this.multiValueDefinitionIndex > -1) {
            return (OIndexDefinitionMultiValue)this.indexDefinitions.get(this.multiValueDefinitionIndex);
        }
        return null;
    }

    public OCompositeKey createSingleValue(List<?> params) {
        OCompositeKey compositeKey = new OCompositeKey();
        int currentParamIndex = 0;
        for (OIndexDefinition indexDefinition : this.indexDefinitions) {
            if (currentParamIndex + 1 > params.size()) break;
            int endIndex = currentParamIndex + indexDefinition.getParamCount() > params.size() ? params.size() : currentParamIndex + indexDefinition.getParamCount();
            List<?> indexParams = params.subList(currentParamIndex, endIndex);
            currentParamIndex += indexDefinition.getParamCount();
            Object keyValue = indexDefinition instanceof OIndexDefinitionMultiValue ? ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(indexParams.toArray()) : indexDefinition.createValue(indexParams);
            if (keyValue == null && this.isNullValuesIgnored()) {
                return null;
            }
            compositeKey.addKey(keyValue);
        }
        return compositeKey;
    }

    private static boolean addKey(OCompositeKey firstKey, List<OCompositeKey> compositeKeys, boolean containsCollection, Object keyValue) {
        if (keyValue instanceof Collection) {
            Collection collectionKey = (Collection)keyValue;
            int collectionSize = collectionKey.isEmpty() ? 1 : collectionKey.size();
            if (!containsCollection) {
                for (int i = 1; i < collectionSize; ++i) {
                    OCompositeKey compositeKey = new OCompositeKey(firstKey.getKeys());
                    compositeKeys.add(compositeKey);
                }
            } else {
                throw new OIndexException("Composite key cannot contain more than one collection item");
            }
            int compositeIndex = 0;
            if (!collectionKey.isEmpty()) {
                for (Object keyItem : collectionKey) {
                    OCompositeKey compositeKey = compositeKeys.get(compositeIndex);
                    compositeKey.addKey(keyItem);
                    ++compositeIndex;
                }
            } else {
                firstKey.addKey(null);
            }
            containsCollection = true;
        } else if (containsCollection) {
            for (OCompositeKey compositeKey : compositeKeys) {
                compositeKey.addKey(keyValue);
            }
        } else {
            firstKey.addKey(keyValue);
        }
        return containsCollection;
    }

    @Override
    public Object createValue(Object ... params) {
        if (params.length == 1 && params[0] instanceof Collection) {
            return params[0];
        }
        return this.createValue(Arrays.asList(params));
    }

    public void processChangeEvent(OMultiValueChangeEvent<?, ?> changeEvent, Map<OCompositeKey, Integer> keysToAdd, Map<OCompositeKey, Integer> keysToRemove, Object ... params) {
        OIndexDefinitionMultiValue indexDefinitionMultiValue = (OIndexDefinitionMultiValue)this.indexDefinitions.get(this.multiValueDefinitionIndex);
        CompositeWrapperMap compositeWrapperKeysToAdd = new CompositeWrapperMap(keysToAdd, this.indexDefinitions, params, this.multiValueDefinitionIndex);
        CompositeWrapperMap compositeWrapperKeysToRemove = new CompositeWrapperMap(keysToRemove, this.indexDefinitions, params, this.multiValueDefinitionIndex);
        indexDefinitionMultiValue.processChangeEvent(changeEvent, compositeWrapperKeysToAdd, compositeWrapperKeysToRemove);
    }

    @Override
    public int getParamCount() {
        int total = 0;
        for (OIndexDefinition indexDefinition : this.indexDefinitions) {
            total += indexDefinition.getParamCount();
        }
        return total;
    }

    @Override
    public OType[] getTypes() {
        LinkedList types = new LinkedList();
        for (OIndexDefinition indexDefinition : this.indexDefinitions) {
            Collections.addAll(types, indexDefinition.getTypes());
        }
        return types.toArray(new OType[types.size()]);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCompositeIndexDefinition that = (OCompositeIndexDefinition)o;
        if (!this.className.equals(that.className)) {
            return false;
        }
        return this.indexDefinitions.equals(that.indexDefinitions);
    }

    @Override
    public int hashCode() {
        int result = this.indexDefinitions.hashCode();
        result = 31 * result + this.className.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "OCompositeIndexDefinition{indexDefinitions=" + this.indexDefinitions + ", className='" + this.className + '\'' + '}';
    }

    @Override
    public ODocument toStream() {
        this.serializeToStream();
        return this.document;
    }

    @Override
    protected void serializeToStream() {
        super.serializeToStream();
        ArrayList<ODocument> inds = new ArrayList<ODocument>(this.indexDefinitions.size());
        ArrayList<String> indClasses = new ArrayList<String>(this.indexDefinitions.size());
        this.document.field("className", this.className);
        for (OIndexDefinition indexDefinition : this.indexDefinitions) {
            ODocument indexDocument = indexDefinition.toStream();
            inds.add(indexDocument);
            indClasses.add(indexDefinition.getClass().getName());
        }
        this.document.field("indexDefinitions", inds, OType.EMBEDDEDLIST);
        this.document.field("indClasses", indClasses, OType.EMBEDDEDLIST);
        this.document.field("nullValuesIgnored", this.isNullValuesIgnored());
    }

    @Override
    public String toCreateIndexDDL(String indexName, String indexType, String engine) {
        StringBuilder ddl = new StringBuilder("create index ");
        ddl.append(indexName).append(" on ").append(this.className).append(" ( ");
        Iterator<String> fieldIterator = this.getFieldsToIndex().iterator();
        if (fieldIterator.hasNext()) {
            ddl.append(this.quoteFieldName(fieldIterator.next()));
            while (fieldIterator.hasNext()) {
                ddl.append(", ").append(this.quoteFieldName(fieldIterator.next()));
            }
        }
        ddl.append(" ) ").append(indexType).append(' ');
        if (engine != null) {
            ddl.append("ENGINE " + engine).append(' ');
        }
        if (this.multiValueDefinitionIndex == -1) {
            boolean first = true;
            for (OType oType : this.getTypes()) {
                if (first) {
                    first = false;
                } else {
                    ddl.append(", ");
                }
                ddl.append(oType.name());
            }
        }
        return ddl.toString();
    }

    private String quoteFieldName(String next) {
        if (next == null) {
            return null;
        }
        if ((next = next.trim()).startsWith("`")) {
            return next;
        }
        if (next.toLowerCase(Locale.ENGLISH).endsWith("collate ci")) {
            next = next.substring(0, next.length() - "collate ci".length());
            return "`" + next.trim() + "` collate ci";
        }
        return "`" + next + "`";
    }

    @Override
    protected void fromStream() {
        this.serializeFromStream();
    }

    @Override
    protected void serializeFromStream() {
        super.serializeFromStream();
        try {
            this.className = (String)this.document.field("className");
            List inds = (List)this.document.field("indexDefinitions");
            List indClasses = (List)this.document.field("indClasses");
            this.indexDefinitions.clear();
            this.collate = new OCompositeCollate(this);
            for (int i = 0; i < indClasses.size(); ++i) {
                Class<?> clazz = Class.forName((String)indClasses.get(i));
                ODocument indDoc = (ODocument)inds.get(i);
                OIndexDefinition indexDefinition = (OIndexDefinition)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                indexDefinition.fromStream(indDoc);
                this.indexDefinitions.add(indexDefinition);
                this.collate.addCollate(indexDefinition.getCollate());
                if (!(indexDefinition instanceof OIndexDefinitionMultiValue)) continue;
                this.multiValueDefinitionIndex = this.indexDefinitions.size() - 1;
            }
            this.setNullValuesIgnored(!Boolean.FALSE.equals(this.document.field("nullValuesIgnored")));
        }
        catch (ClassNotFoundException e) {
            throw OException.wrapException(new OIndexException("Error during composite index deserialization"), e);
        }
        catch (NoSuchMethodException e) {
            throw OException.wrapException(new OIndexException("Error during composite index deserialization"), e);
        }
        catch (InvocationTargetException e) {
            throw OException.wrapException(new OIndexException("Error during composite index deserialization"), e);
        }
        catch (InstantiationException e) {
            throw OException.wrapException(new OIndexException("Error during composite index deserialization"), e);
        }
        catch (IllegalAccessException e) {
            throw OException.wrapException(new OIndexException("Error during composite index deserialization"), e);
        }
    }

    @Override
    public OCollate getCollate() {
        return this.collate;
    }

    @Override
    public void setCollate(OCollate collate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAutomatic() {
        return this.indexDefinitions.get(0).isAutomatic();
    }

    private static final class CompositeWrapperMap
    implements Map<Object, Integer> {
        private final Map<OCompositeKey, Integer> underlying;
        private final Object[] params;
        private final List<OIndexDefinition> indexDefinitions;
        private final int multiValueIndex;

        private CompositeWrapperMap(Map<OCompositeKey, Integer> underlying, List<OIndexDefinition> indexDefinitions, Object[] params, int multiValueIndex) {
            this.underlying = underlying;
            this.params = params;
            this.multiValueIndex = multiValueIndex;
            this.indexDefinitions = indexDefinitions;
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            OCompositeKey compositeKey = this.convertToCompositeKey(key);
            return this.underlying.containsKey(compositeKey);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.underlying.containsValue(value);
        }

        @Override
        public Integer get(Object key) {
            return this.underlying.get(this.convertToCompositeKey(key));
        }

        @Override
        public Integer put(Object key, Integer value) {
            OCompositeKey compositeKey = this.convertToCompositeKey(key);
            return this.underlying.put(compositeKey, value);
        }

        @Override
        public Integer remove(Object key) {
            return this.underlying.remove(this.convertToCompositeKey(key));
        }

        @Override
        public void putAll(Map<? extends Object, ? extends Integer> m) {
            throw new UnsupportedOperationException("Unsupported because of performance reasons");
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public Set<Object> keySet() {
            throw new UnsupportedOperationException("Unsupported because of performance reasons");
        }

        @Override
        public Collection<Integer> values() {
            return this.underlying.values();
        }

        @Override
        public Set<Map.Entry<Object, Integer>> entrySet() {
            throw new UnsupportedOperationException();
        }

        private OCompositeKey convertToCompositeKey(Object key) {
            OCompositeKey compositeKey = new OCompositeKey();
            int paramsIndex = 0;
            for (int i = 0; i < this.indexDefinitions.size(); ++i) {
                OIndexDefinition indexDefinition = this.indexDefinitions.get(i);
                if (i != this.multiValueIndex) {
                    compositeKey.addKey(indexDefinition.createValue(this.params[paramsIndex]));
                    ++paramsIndex;
                    continue;
                }
                compositeKey.addKey(((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(key));
            }
            return compositeKey;
        }
    }
}

