/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexMetadata;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;

public class OIndexAbstractDelegate
implements OIndexInternal {
    protected OIndexInternal delegate;

    public OIndexAbstractDelegate(OIndexInternal internal) {
        this.delegate = internal;
    }

    @Override
    public OIndexInternal getInternal() {
        return this;
    }

    @Override
    public OIndex create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        return this.delegate.create(name, indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener);
    }

    @Override
    @Deprecated
    public Object get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public Stream<ORID> getRids(Object key) {
        return this.delegate.getRids(key);
    }

    @Override
    public OIndex put(Object key, OIdentifiable value) {
        this.checkForKeyType(key);
        return this.delegate.put(key, value);
    }

    @Override
    public int getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public boolean remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public boolean remove(Object key, OIdentifiable rid) {
        return this.delegate.remove(key, rid);
    }

    @Override
    @Deprecated
    public OIndex clear() {
        return this.delegate.clear();
    }

    protected void checkForKeyType(Object iKey) {
        if (this.delegate.getDefinition() == null) {
            OType type = OType.getTypeByClass(iKey.getClass());
            if (type == null) {
                return;
            }
            OIndexManagerAbstract indexManager = ODatabaseRecordThreadLocal.instance().get().getMetadata().getIndexManagerInternal();
            this.delegate.setType(type);
            indexManager.save();
        }
    }

    @Override
    @Deprecated
    public long getSize() {
        return this.delegate.getSize();
    }

    @Override
    @Deprecated
    public long count(Object key) {
        return this.delegate.count(key);
    }

    @Override
    @Deprecated
    public long getKeySize() {
        return this.delegate.getKeySize();
    }

    @Override
    @Deprecated
    public void flush() {
        this.delegate.flush();
    }

    @Override
    @Deprecated
    public long getRebuildVersion() {
        return this.delegate.getRebuildVersion();
    }

    @Override
    @Deprecated
    public boolean isRebuilding() {
        return this.delegate.isRebuilding();
    }

    @Override
    @Deprecated
    public Object getFirstKey() {
        return this.delegate.getFirstKey();
    }

    @Override
    @Deprecated
    public Object getLastKey() {
        return this.delegate.getLastKey();
    }

    @Override
    @Deprecated
    public OIndexCursor cursor() {
        return this.delegate.cursor();
    }

    @Override
    @Deprecated
    public OIndexCursor descCursor() {
        return this.delegate.descCursor();
    }

    @Override
    @Deprecated
    public OIndexKeyCursor keyCursor() {
        return this.delegate.keyCursor();
    }

    @Override
    @Deprecated
    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        return this.delegate.iterateEntries(keys, ascSortOrder);
    }

    @Override
    @Deprecated
    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        return this.delegate.iterateEntriesBetween(fromKey, fromInclusive, toKey, toInclusive, ascOrder);
    }

    @Override
    @Deprecated
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        return this.delegate.iterateEntriesMajor(fromKey, fromInclusive, ascOrder);
    }

    @Override
    @Deprecated
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        return this.delegate.iterateEntriesMajor(toKey, toInclusive, ascOrder);
    }

    @Override
    public OIndex delete() {
        return this.delegate.delete();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String getType() {
        return this.delegate.getType();
    }

    @Override
    public String getAlgorithm() {
        return this.delegate.getAlgorithm();
    }

    @Override
    public boolean isAutomatic() {
        return this.delegate.isAutomatic();
    }

    @Override
    public boolean isUnique() {
        return this.delegate.isUnique();
    }

    @Override
    public ODocument getConfiguration() {
        return this.delegate.getConfiguration();
    }

    @Override
    public ODocument getMetadata() {
        return this.delegate.getMetadata();
    }

    @Override
    public long rebuild() {
        return this.delegate.rebuild();
    }

    @Override
    public long rebuild(OProgressListener iProgressListener) {
        return this.delegate.rebuild(iProgressListener);
    }

    @Override
    public OType[] getKeyTypes() {
        return this.delegate.getKeyTypes();
    }

    @Override
    public OIndexDefinition getDefinition() {
        return this.delegate.getDefinition();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OIndexAbstractDelegate that = (OIndexAbstractDelegate)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Set<String> getClusters() {
        return this.delegate.getClusters();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String getDatabaseName() {
        return this.delegate.getDatabaseName();
    }

    @Override
    public boolean supportsOrderedIterations() {
        return this.delegate.supportsOrderedIterations();
    }

    @Override
    public int getIndexId() {
        return this.delegate.getIndexId();
    }

    @Override
    public int compareTo(OIndex o) {
        return this.delegate.compareTo(o);
    }

    @Override
    public Object getCollatingValue(Object key) {
        return this.delegate.getCollatingValue(key);
    }

    @Override
    public boolean loadFromConfiguration(ODocument config) {
        return this.delegate.loadFromConfiguration(config);
    }

    @Override
    public ODocument updateConfiguration() {
        return this.delegate.updateConfiguration();
    }

    @Override
    public OIndex addCluster(String clusterName) {
        return this.delegate.addCluster(clusterName);
    }

    @Override
    public OIndex removeCluster(String clusterName) {
        return this.delegate.removeCluster(clusterName);
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return this.delegate.canBeUsedInEqualityOperators();
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return this.delegate.hasRangeQuerySupport();
    }

    @Override
    public OIndexMetadata loadMetadata(ODocument config) {
        return this.delegate.loadMetadata(config);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void preCommit(OIndexAbstract.IndexTxSnapshot snapshots) {
        this.delegate.preCommit(snapshots);
    }

    @Override
    public void addTxOperation(OIndexAbstract.IndexTxSnapshot snapshots, OTransactionIndexChanges changes) {
        this.delegate.addTxOperation(snapshots, changes);
    }

    @Override
    public void commit(OIndexAbstract.IndexTxSnapshot snapshots) {
        this.delegate.commit(snapshots);
    }

    @Override
    public void postCommit(OIndexAbstract.IndexTxSnapshot snapshots) {
        this.delegate.postCommit(snapshots);
    }

    @Override
    public void setType(OType type) {
        this.delegate.setType(type);
    }

    @Override
    public String getIndexNameByKey(Object key) {
        return this.delegate.getIndexNameByKey(key);
    }

    @Override
    public boolean acquireAtomicExclusiveLock(Object key) {
        return this.delegate.acquireAtomicExclusiveLock(key);
    }

    @Override
    public long size() {
        return this.delegate.size();
    }

    @Override
    public Stream<ORawPair<Object, ORID>> stream() {
        return this.delegate.stream();
    }

    @Override
    public Stream<ORawPair<Object, ORID>> descStream() {
        return this.delegate.descStream();
    }

    @Override
    public Stream<Object> keyStream() {
        return this.delegate.keyStream();
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        return this.delegate.streamEntriesBetween(fromKey, fromInclusive, toKey, toInclusive, ascOrder);
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntries(Collection<?> keys, boolean ascSortOrder) {
        return this.delegate.streamEntries(keys, ascSortOrder);
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        return this.delegate.streamEntriesMajor(fromKey, fromInclusive, ascOrder);
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        return this.delegate.streamEntriesMinor(toKey, toInclusive, ascOrder);
    }

    @Override
    public boolean isNativeTxSupported() {
        return this.delegate.isNativeTxSupported();
    }

    @Override
    public Iterable<OTransactionIndexChangesPerKey.OTransactionIndexEntry> interpretTxKeyChanges(OTransactionIndexChangesPerKey changes) {
        return this.delegate.interpretTxKeyChanges(changes);
    }

    @Override
    public void doPut(OAbstractPaginatedStorage storage, Object key, ORID rid) throws OInvalidIndexEngineIdException {
        this.delegate.doPut(storage, key, rid);
    }

    @Override
    public boolean doRemove(OAbstractPaginatedStorage storage, Object key, ORID rid) throws OInvalidIndexEngineIdException {
        return this.delegate.doRemove(storage, key, rid);
    }

    @Override
    public boolean doRemove(OAbstractPaginatedStorage storage, Object key) throws OInvalidIndexEngineIdException {
        return this.delegate.doRemove(storage, key);
    }
}

