/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.ODefaultIndexFactory;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexMetadata;
import com.orientechnologies.orient.core.index.OIndexRemoteMultiValue;
import com.orientechnologies.orient.core.index.OIndexRemoteOneValue;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class OIndexManagerRemote
extends OIndexManagerAbstract {
    private AtomicBoolean skipPush = new AtomicBoolean(false);
    private static final String QUERY_DROP = "drop index `%s` if exists";
    private static final long serialVersionUID = -6570577338095096235L;
    private OStorage storage;

    public OIndexManagerRemote(OStorage storage) {
        this.storage = storage;
    }

    @Override
    public OIndex createIndex(ODatabaseDocumentInternal database, String iName, String iType, OIndexDefinition iIndexDefinition, int[] iClusterIdsToIndex, OProgressListener progressListener, ODocument metadata, String engine) {
        String createIndexDDL = iIndexDefinition != null ? iIndexDefinition.toCreateIndexDDL(iName, iType, engine) : new OSimpleKeyIndexDefinition().toCreateIndexDDL(iName, iType, engine);
        if (metadata != null) {
            createIndexDDL = createIndexDDL + " METADATA " + metadata.toJSON();
        }
        this.acquireExclusiveLock();
        try {
            if (progressListener != null) {
                progressListener.onBegin(this, 0L, false);
            }
            database.command(createIndexDDL, new Object[0]).close();
            ORecordInternal.setIdentity(this.document, new ORecordId(database.getStorage().getConfiguration().getIndexMgrRecordId()));
            if (progressListener != null) {
                progressListener.onCompletition(this, true);
            }
            this.reload();
            OIndex oIndex = this.preProcessBeforeReturn(database, (OIndex)this.indexes.get(iName));
            return oIndex;
        }
        catch (OCommandExecutionException x) {
            throw new OIndexException(x.getMessage());
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OIndex createIndex(ODatabaseDocumentInternal database, String iName, String iType, OIndexDefinition indexDefinition, int[] clusterIdsToIndex, OProgressListener progressListener, ODocument metadata) {
        return this.createIndex(database, iName, iType, indexDefinition, clusterIdsToIndex, progressListener, metadata, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropIndex(ODatabaseDocumentInternal database, String iIndexName) {
        this.acquireExclusiveLock();
        try {
            String text = String.format(QUERY_DROP, iIndexName);
            database.command(text, new Object[0]).close();
            this.indexes.remove(iIndexName);
            this.reload();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public ODocument toStream() {
        throw new UnsupportedOperationException("Remote index cannot be streamed");
    }

    public void recreateIndexes() {
        throw new UnsupportedOperationException("recreateIndexes()");
    }

    @Override
    public void recreateIndexes(ODatabaseDocumentInternal database) {
        throw new UnsupportedOperationException("recreateIndexes(ODatabaseDocumentInternal)");
    }

    @Override
    public void waitTillIndexRestore() {
    }

    @Override
    public boolean autoRecreateIndexesAfterCrash(ODatabaseDocumentInternal database) {
        return false;
    }

    public boolean autoRecreateIndexesAfterCrash() {
        return false;
    }

    @Override
    public void removeClassPropertyIndex(OIndex idx) {
    }

    protected OIndex getRemoteIndexInstance(boolean isMultiValueIndex, String type, String name, String algorithm, Set<String> clustersToIndex, OIndexDefinition indexDefinition, ORID identity, ODocument configuration) {
        if (isMultiValueIndex) {
            return new OIndexRemoteMultiValue(name, type, algorithm, identity, indexDefinition, configuration, clustersToIndex, this.getStorage().getName());
        }
        return new OIndexRemoteOneValue(name, type, algorithm, identity, indexDefinition, configuration, clustersToIndex, this.getStorage().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fromStream() {
        this.acquireExclusiveLock();
        try {
            this.clearMetadata();
            Collection idxs = (Collection)this.document.field("indexes");
            if (idxs != null) {
                for (ODocument d : idxs) {
                    d.setLazyLoad(false);
                    try {
                        boolean isMultiValue = ODefaultIndexFactory.isMultiValueIndex((String)d.field("type"));
                        OIndexMetadata newIndexMetadata = OIndexAbstract.loadMetadataInternal(d, (String)d.field("type"), (String)d.field("algorithm"), (String)d.field("valueContainerAlgorithm"));
                        this.addIndexInternal(this.getRemoteIndexInstance(isMultiValue, newIndexMetadata.getType(), newIndexMetadata.getName(), newIndexMetadata.getAlgorithm(), newIndexMetadata.getClustersToIndex(), newIndexMetadata.getIndexDefinition(), (ORID)d.field("mapRid"), d));
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error on loading of index by configuration: %s", e, d);
                    }
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OIndex preProcessBeforeReturn(ODatabaseDocumentInternal database, OIndex index) {
        return index;
    }

    @Override
    protected void acquireExclusiveLock() {
        this.skipPush.set(true);
    }

    @Override
    protected void releaseExclusiveLock() {
        this.skipPush.set(false);
    }

    @Override
    public void fromStream(ODocument iDocument) {
        super.acquireExclusiveLock();
        try {
            super.fromStream(iDocument);
        }
        finally {
            super.releaseExclusiveLock();
        }
    }

    public void update(ODocument indexManager) {
        if (!this.skipPush.get()) {
            super.fromStream(indexManager);
        }
    }

    @Override
    protected OStorage getStorage() {
        return this.storage;
    }
}

