/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.IndexStreamSecurityDecorator;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerRID;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public abstract class OIndexOneValue
extends OIndexAbstract {
    public OIndexOneValue(String name, String type, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata, int binaryFormatVersion) {
        super(name, type, algorithm, valueContainerAlgorithm, metadata, version, storage, binaryFormatVersion);
    }

    @Override
    @Deprecated
    public Object get(Object key) {
        try (Stream<ORID> stream = this.getRids(key);){
            Iterator iterator = stream.iterator();
            if (iterator.hasNext()) {
                Object t = iterator.next();
                return t;
            }
        }
        return null;
    }

    @Override
    public Stream<ORID> getRids(Object key) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        while (true) {
            try {
                Stream<ORID> stream;
                if (this.apiVersion == 0) {
                    ORID rid = (ORID)this.storage.getIndexValue(this.indexId, key);
                    if (rid == null) {
                        Stream<ORID> stream2 = Stream.empty();
                        return stream2;
                    }
                    stream = Stream.of(rid);
                } else if (this.apiVersion == 1) {
                    stream = this.storage.getIndexValues(this.indexId, key);
                } else {
                    throw new IllegalStateException("Unknown version of index API " + this.apiVersion);
                }
                Stream<ORID> stream3 = IndexStreamSecurityDecorator.decorateRidStream(this, stream);
                return stream3;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexOneValue create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        return (OIndexOneValue)super.create(indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, this.determineValueSerializer());
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntries(Collection<?> keys, boolean ascSortOrder) {
        ArrayList sortedKeys = new ArrayList(keys);
        Comparator<Object> comparator = ascSortOrder ? ODefaultComparator.INSTANCE : Collections.reverseOrder(ODefaultComparator.INSTANCE);
        sortedKeys.sort(comparator);
        return IndexStreamSecurityDecorator.decorateStream(this, sortedKeys.stream().flatMap(key -> {
            Object collatedKey = this.getCollatingValue(key);
            this.acquireSharedLock();
            while (true) {
                block10: {
                    block8: {
                        ORID rid2;
                        block9: {
                            if (this.apiVersion != 0) break block8;
                            rid2 = (ORID)this.storage.getIndexValue(this.indexId, collatedKey);
                            if (rid2 != null) break block9;
                            Stream stream = Stream.empty();
                            this.releaseSharedLock();
                            return stream;
                        }
                        Stream<ORawPair<Object, ORID>> stream = Stream.of(new ORawPair<Object, ORID>(collatedKey, rid2));
                        this.releaseSharedLock();
                        return stream;
                    }
                    if (this.apiVersion != 1) break block10;
                    Stream<ORawPair> rid2 = this.storage.getIndexValues(this.indexId, collatedKey).map(rid -> new ORawPair<Object, ORID>(collatedKey, (ORID)rid));
                    this.releaseSharedLock();
                    return rid2;
                }
                try {
                    try {
                        throw new IllegalStateException("Invalid version of index API - " + this.apiVersion);
                    }
                    catch (OInvalidIndexEngineIdException ignore) {
                        this.doReloadIndexEngine();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                break;
            }
        }).filter(Objects::nonNull));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        fromKey = this.getCollatingValue(fromKey);
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        while (true) {
            try {
                Stream<ORawPair<Object, ORID>> stream = IndexStreamSecurityDecorator.decorateStream(this, this.storage.iterateIndexEntriesBetween(this.indexId, fromKey, fromInclusive, toKey, toInclusive, ascOrder, null));
                return stream;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        fromKey = this.getCollatingValue(fromKey);
        this.acquireSharedLock();
        while (true) {
            try {
                Stream<ORawPair<Object, ORID>> stream = IndexStreamSecurityDecorator.decorateStream(this, this.storage.iterateIndexEntriesMajor(this.indexId, fromKey, fromInclusive, ascOrder, null));
                return stream;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        while (true) {
            try {
                Stream<ORawPair<Object, ORID>> stream = IndexStreamSecurityDecorator.decorateStream(this, this.storage.iterateIndexEntriesMinor(this.indexId, toKey, toInclusive, ascOrder, null));
                return stream;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long size() {
        this.acquireSharedLock();
        while (true) {
            try {
                long l = this.storage.getIndexSize(this.indexId, null);
                return l;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Stream<ORawPair<Object, ORID>> stream() {
        this.acquireSharedLock();
        while (true) {
            try {
                Stream<ORawPair<Object, ORID>> stream = IndexStreamSecurityDecorator.decorateStream(this, this.storage.getIndexStream(this.indexId, null));
                return stream;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Stream<ORawPair<Object, ORID>> descStream() {
        this.acquireSharedLock();
        while (true) {
            try {
                Stream<ORawPair<Object, ORID>> stream = IndexStreamSecurityDecorator.decorateStream(this, this.storage.getIndexDescStream(this.indexId, null));
                return stream;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    protected OBinarySerializer determineValueSerializer() {
        return OStreamSerializerRID.INSTANCE;
    }
}

