/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.spliterators.Streams;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.IndexStreamSecurityDecorator;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexTxAware;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class OIndexTxAwareMultiValue
extends OIndexTxAware<Collection<OIdentifiable>> {
    public OIndexTxAwareMultiValue(ODatabaseDocumentInternal database, OIndexInternal delegate) {
        super(database, delegate);
    }

    @Override
    @Deprecated
    public Collection<OIdentifiable> get(Object key) {
        List<OIdentifiable> rids;
        try (Stream<ORID> stream = this.getRids(key);){
            rids = stream.collect(Collectors.toList());
        }
        return rids;
    }

    @Override
    public Stream<ORID> getRids(Object key) {
        OTransactionIndexChanges indexChanges = this.database.getMicroOrRegularTransaction().getIndexChangesInternal(this.delegate.getName());
        if (indexChanges == null) {
            return super.getRids(key);
        }
        Object collatedKey = this.getCollatingValue(key);
        Set<OIdentifiable> txChanges = OIndexTxAwareMultiValue.calculateTxValue(collatedKey, indexChanges);
        Stream<ORID> backedStream = super.getRids(collatedKey);
        if (txChanges == null) {
            txChanges = Collections.emptySet();
        }
        return IndexStreamSecurityDecorator.decorateRidStream(this, Stream.concat(backedStream.map(rid -> this.calculateTxIndexEntry(collatedKey, (ORID)rid, indexChanges)).filter(Objects::nonNull).map(pair -> (ORID)pair.second), txChanges.stream().map(OIdentifiable::getIdentity)));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> stream() {
        OTransactionIndexChanges indexChanges = this.database.getMicroOrRegularTransaction().getIndexChangesInternal(this.delegate.getName());
        if (indexChanges == null) {
            return super.stream();
        }
        Stream<ORawPair<Object, ORID>> txStream = StreamSupport.stream(new PureTxBetweenIndexForwardSpliterator(null, true, null, true, indexChanges), false);
        if (indexChanges.cleared) {
            return IndexStreamSecurityDecorator.decorateStream(this, txStream);
        }
        Stream<ORawPair<Object, ORID>> backedStream = super.stream();
        return IndexStreamSecurityDecorator.decorateStream(this, this.mergeTxAndBackedStreams(indexChanges, txStream, backedStream, true));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> descStream() {
        OTransactionIndexChanges indexChanges = this.database.getMicroOrRegularTransaction().getIndexChangesInternal(this.delegate.getName());
        if (indexChanges == null) {
            return super.descStream();
        }
        Stream<ORawPair<Object, ORID>> txStream = StreamSupport.stream(new PureTxBetweenIndexBackwardCursor(null, true, null, true, indexChanges), false);
        if (indexChanges.cleared) {
            return IndexStreamSecurityDecorator.decorateStream(this, txStream);
        }
        Stream<ORawPair<Object, ORID>> backedStream = super.descStream();
        return IndexStreamSecurityDecorator.decorateStream(this, this.mergeTxAndBackedStreams(indexChanges, txStream, backedStream, false));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        OTransactionIndexChanges indexChanges = this.database.getMicroOrRegularTransaction().getIndexChangesInternal(this.delegate.getName());
        if (indexChanges == null) {
            return super.streamEntriesBetween(fromKey, fromInclusive, toKey, toInclusive, ascOrder);
        }
        fromKey = this.getCollatingValue(fromKey);
        toKey = this.getCollatingValue(toKey);
        Stream<ORawPair<Object, ORID>> txStream = ascOrder ? StreamSupport.stream(new PureTxBetweenIndexForwardSpliterator(fromKey, fromInclusive, toKey, toInclusive, indexChanges), false) : StreamSupport.stream(new PureTxBetweenIndexBackwardCursor(fromKey, fromInclusive, toKey, toInclusive, indexChanges), false);
        if (indexChanges.cleared) {
            return IndexStreamSecurityDecorator.decorateStream(this, txStream);
        }
        Stream<ORawPair<Object, ORID>> backedStream = super.streamEntriesBetween(fromKey, fromInclusive, toKey, toInclusive, ascOrder);
        return IndexStreamSecurityDecorator.decorateStream(this, this.mergeTxAndBackedStreams(indexChanges, txStream, backedStream, ascOrder));
    }

    private Stream<ORawPair<Object, ORID>> mergeTxAndBackedStreams(OTransactionIndexChanges indexChanges, Stream<ORawPair<Object, ORID>> txStream, Stream<ORawPair<Object, ORID>> backedStream, boolean ascOrder) {
        return Streams.mergeSortedSpliterators(txStream, backedStream.map(entry -> this.calculateTxIndexEntry(entry.first, (ORID)entry.second, indexChanges)).filter(Objects::nonNull), (entryOne, entryTwo) -> {
            if (ascOrder) {
                return ODefaultComparator.INSTANCE.compare(this.getCollatingValue(entryOne.first), this.getCollatingValue(entryTwo.first));
            }
            return -ODefaultComparator.INSTANCE.compare(this.getCollatingValue(entryOne.first), this.getCollatingValue(entryTwo.first));
        });
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        OTransactionIndexChanges indexChanges = this.database.getMicroOrRegularTransaction().getIndexChangesInternal(this.delegate.getName());
        if (indexChanges == null) {
            return super.streamEntriesMajor(fromKey, fromInclusive, ascOrder);
        }
        fromKey = this.getCollatingValue(fromKey);
        Object lastKey = indexChanges.getLastKey();
        Stream<ORawPair<Object, ORID>> txStream = ascOrder ? StreamSupport.stream(new PureTxBetweenIndexForwardSpliterator(fromKey, fromInclusive, lastKey, true, indexChanges), false) : StreamSupport.stream(new PureTxBetweenIndexBackwardCursor(fromKey, fromInclusive, lastKey, true, indexChanges), false);
        if (indexChanges.cleared) {
            return IndexStreamSecurityDecorator.decorateStream(this, txStream);
        }
        Stream<ORawPair<Object, ORID>> backedStream = super.streamEntriesMajor(fromKey, fromInclusive, ascOrder);
        return IndexStreamSecurityDecorator.decorateStream(this, this.mergeTxAndBackedStreams(indexChanges, txStream, backedStream, ascOrder));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        OTransactionIndexChanges indexChanges = this.database.getMicroOrRegularTransaction().getIndexChangesInternal(this.delegate.getName());
        if (indexChanges == null) {
            return super.streamEntriesMinor(toKey, toInclusive, ascOrder);
        }
        toKey = this.getCollatingValue(toKey);
        Object firstKey = indexChanges.getFirstKey();
        Stream<ORawPair<Object, ORID>> txStream = ascOrder ? StreamSupport.stream(new PureTxBetweenIndexForwardSpliterator(firstKey, true, toKey, toInclusive, indexChanges), false) : StreamSupport.stream(new PureTxBetweenIndexBackwardCursor(firstKey, true, toKey, toInclusive, indexChanges), false);
        if (indexChanges.cleared) {
            return IndexStreamSecurityDecorator.decorateStream(this, txStream);
        }
        Stream<ORawPair<Object, ORID>> backedCursor = super.streamEntriesMinor(toKey, toInclusive, ascOrder);
        return IndexStreamSecurityDecorator.decorateStream(this, this.mergeTxAndBackedStreams(indexChanges, txStream, backedCursor, ascOrder));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntries(Collection<?> keys, boolean ascSortOrder) {
        OTransactionIndexChanges indexChanges = this.database.getMicroOrRegularTransaction().getIndexChangesInternal(this.delegate.getName());
        if (indexChanges == null) {
            return super.streamEntries(keys, ascSortOrder);
        }
        Stream<ORawPair<Object, ORID>> txStream = keys.stream().flatMap(key -> {
            Set<OIdentifiable> result = OIndexTxAwareMultiValue.calculateTxValue(this.getCollatingValue(key), indexChanges);
            if (result != null) {
                return result.stream().map(rid -> new ORawPair<Object, ORID>(this.getCollatingValue(key), rid.getIdentity()));
            }
            return null;
        }).filter(Objects::nonNull).sorted((entryOne, entryTwo) -> {
            if (ascSortOrder) {
                return ODefaultComparator.INSTANCE.compare(this.getCollatingValue(entryOne.first), this.getCollatingValue(entryTwo.first));
            }
            return -ODefaultComparator.INSTANCE.compare(this.getCollatingValue(entryOne.first), this.getCollatingValue(entryTwo.first));
        });
        if (indexChanges.cleared) {
            return IndexStreamSecurityDecorator.decorateStream(this, txStream);
        }
        Stream<ORawPair<Object, ORID>> backedCursor = super.streamEntries(keys, ascSortOrder);
        return IndexStreamSecurityDecorator.decorateStream(this, this.mergeTxAndBackedStreams(indexChanges, txStream, backedCursor, ascSortOrder));
    }

    private ORawPair<Object, ORID> calculateTxIndexEntry(Object key, ORID backendValue, OTransactionIndexChanges indexChanges) {
        key = this.getCollatingValue(key);
        OTransactionIndexChangesPerKey changesPerKey = indexChanges.getChangesPerKey(key);
        if (changesPerKey.entries.isEmpty()) {
            return new ORawPair<Object, ORID>(key, backendValue);
        }
        int putCounter = 1;
        for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : changesPerKey.entries) {
            if (entry.operation == OTransactionIndexChanges.OPERATION.PUT && entry.value.equals(backendValue)) {
                ++putCounter;
                continue;
            }
            if (entry.operation != OTransactionIndexChanges.OPERATION.REMOVE) continue;
            if (entry.value == null) {
                putCounter = 0;
                continue;
            }
            if (!entry.value.equals(backendValue) || putCounter <= 0) continue;
            --putCounter;
        }
        if (putCounter <= 0) {
            return null;
        }
        return new ORawPair<Object, ORID>(key, backendValue);
    }

    private static Set<OIdentifiable> calculateTxValue(Object key, OTransactionIndexChanges indexChanges) {
        ArrayList<OIdentifiable> result = new ArrayList<OIdentifiable>();
        OTransactionIndexChangesPerKey changesPerKey = indexChanges.getChangesPerKey(key);
        if (changesPerKey.entries.isEmpty()) {
            return null;
        }
        for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : changesPerKey.entries) {
            if (entry.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                if (entry.value == null) {
                    result.clear();
                    continue;
                }
                result.remove(entry.value);
                continue;
            }
            result.add(entry.value);
        }
        if (result.isEmpty()) {
            return null;
        }
        return new HashSet<OIdentifiable>(result);
    }

    private class PureTxBetweenIndexBackwardCursor
    implements Spliterator<ORawPair<Object, ORID>> {
        private final OTransactionIndexChanges indexChanges;
        private Object firstKey;
        private Object nextKey;
        private Iterator<OIdentifiable> valuesIterator = new OEmptyIterator<OIdentifiable>();
        private Object key;

        private PureTxBetweenIndexBackwardCursor(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, OTransactionIndexChanges indexChanges) {
            Object[] keys;
            this.indexChanges = indexChanges;
            if (fromKey != null) {
                fromKey = OIndexTxAwareMultiValue.this.enhanceFromCompositeKeyBetweenDesc(fromKey, fromInclusive);
            }
            if (toKey != null) {
                toKey = OIndexTxAwareMultiValue.this.enhanceToCompositeKeyBetweenDesc(toKey, toInclusive);
            }
            if ((keys = indexChanges.firstAndLastKeys(fromKey, fromInclusive, toKey, toInclusive)).length == 0) {
                this.nextKey = null;
            } else {
                this.firstKey = keys[0];
                this.nextKey = keys[1];
            }
        }

        private ORawPair<Object, ORID> nextEntryInternal() {
            OIdentifiable identifiable = this.valuesIterator.next();
            return new ORawPair<Object, ORID>(this.key, identifiable.getIdentity());
        }

        @Override
        public boolean tryAdvance(Consumer<? super ORawPair<Object, ORID>> action) {
            Set result;
            if (this.valuesIterator.hasNext()) {
                ORawPair<Object, ORID> entry = this.nextEntryInternal();
                action.accept(entry);
                return true;
            }
            if (this.nextKey == null) {
                return false;
            }
            do {
                result = OIndexTxAwareMultiValue.calculateTxValue(this.nextKey, this.indexChanges);
                this.key = this.nextKey;
                this.nextKey = this.indexChanges.getLowerKey(this.nextKey);
                if (this.nextKey == null || ODefaultComparator.INSTANCE.compare(this.nextKey, this.firstKey) >= 0) continue;
                this.nextKey = null;
            } while ((result == null || result.isEmpty()) && this.nextKey != null);
            if (result == null || result.isEmpty()) {
                return false;
            }
            this.valuesIterator = result.iterator();
            ORawPair<Object, ORID> entry = this.nextEntryInternal();
            action.accept(entry);
            return true;
        }

        @Override
        public Spliterator<ORawPair<Object, ORID>> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 276;
        }

        @Override
        public Comparator<? super ORawPair<Object, ORID>> getComparator() {
            return (entryOne, entryTwo) -> -ODefaultComparator.INSTANCE.compare(entryOne.first, entryTwo.first);
        }
    }

    private class PureTxBetweenIndexForwardSpliterator
    implements Spliterator<ORawPair<Object, ORID>> {
        private final OTransactionIndexChanges indexChanges;
        private Object lastKey;
        private Object nextKey;
        private Iterator<OIdentifiable> valuesIterator = new OEmptyIterator<OIdentifiable>();
        private Object key;

        private PureTxBetweenIndexForwardSpliterator(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, OTransactionIndexChanges indexChanges) {
            Object[] keys;
            this.indexChanges = indexChanges;
            if (fromKey != null) {
                fromKey = OIndexTxAwareMultiValue.this.enhanceFromCompositeKeyBetweenAsc(fromKey, fromInclusive);
            }
            if (toKey != null) {
                toKey = OIndexTxAwareMultiValue.this.enhanceToCompositeKeyBetweenAsc(toKey, toInclusive);
            }
            if ((keys = indexChanges.firstAndLastKeys(fromKey, fromInclusive, toKey, toInclusive)).length == 0) {
                this.nextKey = null;
            } else {
                Object firstKey = keys[0];
                this.lastKey = keys[1];
                this.nextKey = firstKey;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super ORawPair<Object, ORID>> action) {
            Set result;
            if (this.valuesIterator.hasNext()) {
                ORawPair<Object, ORID> entry = this.nextEntryInternal();
                action.accept(entry);
                return true;
            }
            if (this.nextKey == null) {
                return false;
            }
            do {
                result = OIndexTxAwareMultiValue.calculateTxValue(this.nextKey, this.indexChanges);
                this.key = this.nextKey;
                this.nextKey = this.indexChanges.getHigherKey(this.nextKey);
                if (this.nextKey == null || ODefaultComparator.INSTANCE.compare(this.nextKey, this.lastKey) <= 0) continue;
                this.nextKey = null;
            } while ((result == null || result.isEmpty()) && this.nextKey != null);
            if (result == null || result.isEmpty()) {
                return false;
            }
            this.valuesIterator = result.iterator();
            ORawPair<Object, ORID> entry = this.nextEntryInternal();
            action.accept(entry);
            return true;
        }

        private ORawPair<Object, ORID> nextEntryInternal() {
            OIdentifiable identifiable = this.valuesIterator.next();
            return new ORawPair<Object, ORID>(this.key, identifiable.getIdentity());
        }

        @Override
        public Spliterator<ORawPair<Object, ORID>> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 276;
        }

        @Override
        public Comparator<? super ORawPair<Object, ORID>> getComparator() {
            return (entryOne, entryTwo) -> ODefaultComparator.INSTANCE.compare(entryOne.first, entryTwo.first);
        }
    }
}

