/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.engine.v1;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.index.engine.OMultiValueIndexEngine;
import com.orientechnologies.orient.core.index.engine.v1.OCellBTreeIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OCompactedLinkSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.CompositeKeySerializer;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.OCellBTreeMultiValue;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.CellBTreeMultiValueV2;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.OCellBTreeSingleValue;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v3.CellBTreeSingleValueV3;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class OCellBTreeMultiValueIndexEngine
implements OMultiValueIndexEngine,
OCellBTreeIndexEngine {
    public static final String DATA_FILE_EXTENSION = ".cbt";
    private static final String NULL_BUCKET_FILE_EXTENSION = ".nbt";
    public static final String M_CONTAINER_EXTENSION = ".mbt";
    private final OCellBTreeMultiValue<Object> mvTree;
    private final OCellBTreeSingleValue<OCompositeKey> svTree;
    private final OCellBTreeSingleValue<OIdentifiable> nullTree;
    private final String name;
    private final int id;
    private final String nullTreeName;

    public OCellBTreeMultiValueIndexEngine(int id, String name, OAbstractPaginatedStorage storage, int version) {
        this.id = id;
        this.name = name;
        this.nullTreeName = name + "$null";
        if (version == 1) {
            throw new IllegalArgumentException("Unsupported version of index : " + version);
        }
        if (version == 2) {
            this.mvTree = new CellBTreeMultiValueV2<Object>(name, DATA_FILE_EXTENSION, NULL_BUCKET_FILE_EXTENSION, M_CONTAINER_EXTENSION, storage);
            this.svTree = null;
            this.nullTree = null;
        } else {
            if (version == 3) {
                throw new IllegalArgumentException("Unsupported version of index : " + version);
            }
            if (version == 4) {
                this.mvTree = null;
                this.svTree = new CellBTreeSingleValueV3<OCompositeKey>(name, DATA_FILE_EXTENSION, NULL_BUCKET_FILE_EXTENSION, storage);
                this.nullTree = new CellBTreeSingleValueV3<OIdentifiable>(this.nullTreeName, DATA_FILE_EXTENSION, NULL_BUCKET_FILE_EXTENSION, storage);
            } else {
                throw new IllegalStateException("Invalid tree version " + version);
            }
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
    }

    @Override
    public void flush() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void create(OAtomicOperation atomicOperation, OBinarySerializer valueSerializer, boolean isAutomatic, OType[] keyTypes, boolean nullPointerSupport, OBinarySerializer keySerializer, int keySize, Map<String, String> engineProperties, OEncryption encryption) {
        try {
            if (this.mvTree != null) {
                this.mvTree.create(keySerializer, keyTypes, keySize, encryption, atomicOperation);
            } else {
                OType[] sbTypes = OCellBTreeMultiValueIndexEngine.calculateTypes(keyTypes);
                assert (this.svTree != null);
                assert (this.nullTree != null);
                this.svTree.create(atomicOperation, new CompositeKeySerializer(), sbTypes, keySize + 1, encryption);
                this.nullTree.create(atomicOperation, OCompactedLinkSerializer.INSTANCE, new OType[]{OType.LINK}, 1, null);
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during creation of index " + this.name), e);
        }
    }

    @Override
    public void delete(OAtomicOperation atomicOperation) {
        try {
            if (this.mvTree != null) {
                this.doClearMVTree(atomicOperation);
                this.mvTree.delete(atomicOperation);
            } else {
                assert (this.svTree != null);
                assert (this.nullTree != null);
                this.doClearSVTree(atomicOperation);
                this.svTree.delete(atomicOperation);
                this.nullTree.delete(atomicOperation);
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during deletion of index " + this.name), e);
        }
    }

    private void doClearMVTree(OAtomicOperation atomicOperation) {
        assert (this.mvTree != null);
        Object firstKey = this.mvTree.firstKey();
        Object lastKey = this.mvTree.lastKey();
        try (Stream<ORawPair<Object, ORID>> stream = this.mvTree.iterateEntriesBetween(firstKey, true, lastKey, true, true);){
            stream.forEach(pair -> {
                try {
                    this.mvTree.remove(atomicOperation, pair.first, (ORID)pair.second);
                }
                catch (IOException e) {
                    throw OException.wrapException(new OIndexException("Error during cleaning of index " + this.name), e);
                }
            });
        }
        var5_5 = null;
        try (Stream<ORID> rids = this.mvTree.get(null);){
            rids.forEach(rid -> {
                try {
                    this.mvTree.remove(atomicOperation, null, (ORID)rid);
                }
                catch (IOException e) {
                    throw OException.wrapException(new OStorageException("Error during cleaning of index " + this.name), e);
                }
            });
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    private void doClearSVTree(OAtomicOperation atomicOperation) {
        assert (this.svTree != null);
        assert (this.nullTree != null);
        Comparable<OCompositeKey> firstKey = this.svTree.firstKey();
        Comparable<OCompositeKey> lastKey = this.svTree.lastKey();
        try (Stream<ORawPair<Comparable<OCompositeKey>, ORID>> stream = this.svTree.iterateEntriesBetween((OCompositeKey)firstKey, true, (OCompositeKey)lastKey, true, true);){
            stream.forEach(pair -> {
                try {
                    this.svTree.remove(atomicOperation, (OCompositeKey)pair.first);
                }
                catch (IOException e) {
                    throw OException.wrapException(new OIndexException("Error during index cleaning"), e);
                }
            });
        }
        firstKey = this.nullTree.firstKey();
        lastKey = this.nullTree.lastKey();
        if (firstKey != null && lastKey != null) {
            stream = this.nullTree.iterateEntriesBetween((OIdentifiable)firstKey, true, (OIdentifiable)lastKey, true, true);
            var5_5 = null;
            try {
                stream.forEach(pair -> {
                    try {
                        this.nullTree.remove(atomicOperation, (OIdentifiable)pair.first);
                    }
                    catch (IOException e) {
                        throw OException.wrapException(new OIndexException("Error during index cleaning"), e);
                    }
                });
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    if (var5_5 != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
    }

    @Override
    public void load(String name, int keySize, OType[] keyTypes, OBinarySerializer keySerializer, OEncryption encryption) {
        if (this.mvTree != null) {
            this.mvTree.load(name, keySize, keyTypes, keySerializer, encryption);
        } else {
            assert (this.svTree != null);
            assert (this.nullTree != null);
            OType[] sbTypes = OCellBTreeMultiValueIndexEngine.calculateTypes(keyTypes);
            this.svTree.load(name, keySize + 1, sbTypes, new CompositeKeySerializer(), null);
            this.nullTree.load(this.nullTreeName, 1, new OType[]{OType.LINK}, OCompactedLinkSerializer.INSTANCE, null);
        }
    }

    @Override
    public boolean remove(OAtomicOperation atomicOperation, Object key, ORID value) {
        try {
            if (this.mvTree != null) {
                return this.mvTree.remove(atomicOperation, key, value);
            }
            if (key != null) {
                assert (this.svTree != null);
                OCompositeKey compositeKey = OCellBTreeMultiValueIndexEngine.createCompositeKey(key, value);
                boolean[] removed = new boolean[1];
                try (Stream<ORawPair<OCompositeKey, ORID>> stream = this.svTree.iterateEntriesBetween(compositeKey, true, compositeKey, true, true);){
                    stream.forEach(pair -> {
                        try {
                            boolean result = this.svTree.remove(atomicOperation, (OCompositeKey)pair.first) != null;
                            removed[0] = result || removed[0];
                        }
                        catch (IOException e) {
                            throw OException.wrapException(new OIndexException("Error during remove of entry (" + key + ", " + value + ")"), e);
                        }
                    });
                }
                return removed[0];
            }
            assert (this.nullTree != null);
            return this.nullTree.remove(atomicOperation, value) != null;
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during removal of entry with key " + key + "and RID " + value + " from index " + this.name), e);
        }
    }

    @Override
    public void clear(OAtomicOperation atomicOperation) {
        if (this.mvTree != null) {
            this.doClearMVTree(atomicOperation);
        } else {
            this.doClearSVTree(atomicOperation);
        }
    }

    @Override
    public void close() {
        if (this.mvTree != null) {
            this.mvTree.close();
        } else {
            assert (this.svTree != null);
            assert (this.nullTree != null);
            this.svTree.close();
            this.nullTree.close();
        }
    }

    @Override
    public Stream<ORID> get(Object key) {
        if (this.mvTree != null) {
            return this.mvTree.get(key);
        }
        if (key != null) {
            assert (this.svTree != null);
            OCompositeKey firstKey = OCellBTreeMultiValueIndexEngine.convertToCompositeKey(key);
            OCompositeKey lastKey = OCellBTreeMultiValueIndexEngine.convertToCompositeKey(key);
            return this.svTree.iterateEntriesBetween(firstKey, true, lastKey, true, true).map(pair -> (ORID)pair.second);
        }
        assert (this.nullTree != null);
        return this.nullTree.iterateEntriesBetween(new ORecordId(0, 0L), true, new ORecordId(Short.MAX_VALUE, Long.MAX_VALUE), true, true).map(pair -> (ORID)pair.second);
    }

    @Override
    public Stream<ORawPair<Object, ORID>> stream(OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        if (this.mvTree != null) {
            Object firstKey = this.mvTree.firstKey();
            if (firstKey == null) {
                return OCellBTreeMultiValueIndexEngine.emptyStream();
            }
            return this.mvTree.iterateEntriesMajor(firstKey, true, true);
        }
        assert (this.svTree != null);
        OCompositeKey firstKey = this.svTree.firstKey();
        if (firstKey == null) {
            return OCellBTreeMultiValueIndexEngine.emptyStream();
        }
        return OCellBTreeMultiValueIndexEngine.mapSVStream(this.svTree.iterateEntriesMajor(firstKey, true, true));
    }

    private static Stream<ORawPair<Object, ORID>> mapSVStream(Stream<ORawPair<OCompositeKey, ORID>> stream) {
        return stream.map(entry -> new ORawPair(OCellBTreeMultiValueIndexEngine.extractKey((OCompositeKey)entry.first), entry.second));
    }

    private static Stream<ORawPair<Object, ORID>> emptyStream() {
        return StreamSupport.stream(Spliterators.emptySpliterator(), false);
    }

    @Override
    public Stream<ORawPair<Object, ORID>> descStream(OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        if (this.mvTree != null) {
            Object lastKey = this.mvTree.lastKey();
            if (lastKey == null) {
                return OCellBTreeMultiValueIndexEngine.emptyStream();
            }
            return this.mvTree.iterateEntriesMinor(lastKey, true, false);
        }
        assert (this.svTree != null);
        OCompositeKey lastKey = this.svTree.lastKey();
        if (lastKey == null) {
            return OCellBTreeMultiValueIndexEngine.emptyStream();
        }
        return OCellBTreeMultiValueIndexEngine.mapSVStream(this.svTree.iterateEntriesMinor(lastKey, true, false));
    }

    @Override
    public Stream<Object> keyStream() {
        if (this.mvTree != null) {
            return this.mvTree.keyStream();
        }
        assert (this.svTree != null);
        return this.svTree.keyStream().map(OCellBTreeMultiValueIndexEngine::extractKey);
    }

    @Override
    public void put(OAtomicOperation atomicOperation, Object key, ORID value) {
        if (this.mvTree != null) {
            try {
                this.mvTree.put(atomicOperation, key, value);
            }
            catch (IOException e) {
                throw OException.wrapException(new OIndexException("Error during insertion of key " + key + " and RID " + value + " to index " + this.name), e);
            }
        }
        if (key != null) {
            assert (this.svTree != null);
            try {
                this.svTree.put(atomicOperation, OCellBTreeMultiValueIndexEngine.createCompositeKey(key, value), value);
            }
            catch (IOException e) {
                throw OException.wrapException(new OIndexException("Error during insertion of key " + key + " and RID " + value + " to index " + this.name), e);
            }
        }
        assert (this.nullTree != null);
        try {
            this.nullTree.put(atomicOperation, value, value);
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during insertion of null key and RID " + value + " to index " + this.name), e);
        }
    }

    @Override
    public Stream<ORawPair<Object, ORID>> iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        if (this.mvTree != null) {
            return this.mvTree.iterateEntriesBetween(rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder);
        }
        assert (this.svTree != null);
        if (rangeFrom == null && rangeTo == null) {
            return OCellBTreeMultiValueIndexEngine.mapSVStream(this.svTree.allEntries());
        }
        OCompositeKey toKey = OCellBTreeMultiValueIndexEngine.convertToCompositeKey(rangeTo);
        if (rangeFrom == null) {
            return OCellBTreeMultiValueIndexEngine.mapSVStream(this.svTree.iterateEntriesMinor(toKey, toInclusive, ascSortOrder));
        }
        OCompositeKey fromKey = OCellBTreeMultiValueIndexEngine.convertToCompositeKey(rangeFrom);
        if (rangeTo == null) {
            return OCellBTreeMultiValueIndexEngine.mapSVStream(this.svTree.iterateEntriesMajor(fromKey, fromInclusive, ascSortOrder));
        }
        return OCellBTreeMultiValueIndexEngine.mapSVStream(this.svTree.iterateEntriesBetween(fromKey, fromInclusive, toKey, toInclusive, ascSortOrder));
    }

    private static OCompositeKey convertToCompositeKey(Object rangeFrom) {
        OCompositeKey firstKey = rangeFrom instanceof OCompositeKey ? (OCompositeKey)rangeFrom : new OCompositeKey(rangeFrom);
        return firstKey;
    }

    @Override
    public Stream<ORawPair<Object, ORID>> iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        if (this.mvTree != null) {
            return this.mvTree.iterateEntriesMajor(fromKey, isInclusive, ascSortOrder);
        }
        assert (this.svTree != null);
        OCompositeKey firstKey = OCellBTreeMultiValueIndexEngine.convertToCompositeKey(fromKey);
        return OCellBTreeMultiValueIndexEngine.mapSVStream(this.svTree.iterateEntriesMajor(firstKey, isInclusive, ascSortOrder));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        if (this.mvTree != null) {
            return this.mvTree.iterateEntriesMinor(toKey, isInclusive, ascSortOrder);
        }
        assert (this.svTree != null);
        OCompositeKey lastKey = OCellBTreeMultiValueIndexEngine.convertToCompositeKey(toKey);
        return OCellBTreeMultiValueIndexEngine.mapSVStream(this.svTree.iterateEntriesMinor(lastKey, isInclusive, ascSortOrder));
    }

    @Override
    public long size(OBaseIndexEngine.ValuesTransformer transformer) {
        if (this.mvTree != null) {
            return this.mvTreeSize(transformer);
        }
        assert (this.svTree != null);
        assert (this.nullTree != null);
        return this.svTreeEntries();
    }

    private long mvTreeSize(OBaseIndexEngine.ValuesTransformer transformer) {
        assert (this.mvTree != null);
        if (transformer == null) {
            Object firstKey = this.mvTree.firstKey();
            Object lastKey = this.mvTree.lastKey();
            int counter = 0;
            try (Stream<ORID> oridStream = this.mvTree.get(null);){
                if (oridStream.iterator().hasNext()) {
                    ++counter;
                }
            }
            if (firstKey != null && lastKey != null) {
                Object[] prevKey = new Object[]{new Object()};
                try (Stream<ORawPair<Object, ORID>> stream = this.mvTree.iterateEntriesBetween(firstKey, true, lastKey, true, true);){
                    counter = (int)((long)counter + stream.filter(pair -> {
                        boolean result = !prevKey[0].equals(pair.first);
                        prevKey[0] = pair.first;
                        return result;
                    }).count());
                }
            }
            return counter;
        }
        return this.mvTree.size();
    }

    private long svTreeEntries() {
        assert (this.svTree != null);
        assert (this.nullTree != null);
        return this.svTree.size() + this.nullTree.size();
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return true;
    }

    @Override
    public boolean acquireAtomicExclusiveLock(Object key) {
        if (this.mvTree != null) {
            this.mvTree.acquireAtomicExclusiveLock();
        } else {
            assert (this.svTree != null);
            assert (this.nullTree != null);
            this.svTree.acquireAtomicExclusiveLock();
            this.nullTree.acquireAtomicExclusiveLock();
        }
        return true;
    }

    @Override
    public String getIndexNameByKey(Object key) {
        return this.name;
    }

    private static OType[] calculateTypes(OType[] keyTypes) {
        if (keyTypes == null) {
            throw new OIndexException("Types of fields should be provided upon of creation of index");
        }
        OType[] sbTypes = new OType[keyTypes.length + 1];
        System.arraycopy(keyTypes, 0, sbTypes, 0, keyTypes.length);
        sbTypes[sbTypes.length - 1] = OType.LINK;
        return sbTypes;
    }

    private static OCompositeKey createCompositeKey(Object key, ORID value) {
        OCompositeKey compositeKey = new OCompositeKey(key);
        compositeKey.addKey(value);
        return compositeKey;
    }

    private static Object extractKey(OCompositeKey compositeKey) {
        if (compositeKey == null) {
            return null;
        }
        List<Object> keys = compositeKey.getKeys();
        Object key = keys.size() == 2 ? keys.get(0) : new OCompositeKey(keys.subList(0, keys.size() - 1));
        return key;
    }
}

